/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.worker.COMPSsException;
import java.util.concurrent.Semaphore;

public class BarrierRequest
implements APRequest,
Barrier {
    private final String barrierName;
    private final Application app;
    private COMPSsException exception;
    private boolean released;
    private final Semaphore sem;
    private int graphSource = Integer.MIN_VALUE;

    public BarrierRequest(Application app) {
        this(app, "Barrier");
    }

    public BarrierRequest(Application app, String name) {
        this.app = app;
        this.exception = null;
        this.sem = new Semaphore(0);
        this.released = false;
        this.barrierName = name;
    }

    @Override
    public TraceEvent getEvent() {
        return TraceEvent.WAIT_FOR_ALL_TASKS;
    }

    public final Application getApp() {
        return this.app;
    }

    @Override
    public final void setException(COMPSsException exception) {
        this.exception = exception;
    }

    @Override
    public final COMPSsException getException() {
        return this.exception;
    }

    @Override
    public final void process(AccessProcessor ap, TaskDispatcher td) {
        this.handleBarrier();
        this.sem.release();
    }

    public void handleBarrier() {
        this.app.reachesBarrier(this);
    }

    @Override
    public final void release() {
        this.released = true;
        LOGGER.info(this.barrierName + " for app " + this.app.getId() + " released");
        this.sem.release();
    }

    public final void waitForCompletion() throws COMPSsException {
        this.sem.acquireUninterruptibly();
        boolean stalled = false;
        if (!this.released) {
            LOGGER.info(this.barrierName + " for app " + this.app.getId() + " becomes stalled. Releasing resources");
            this.app.stalled();
            stalled = true;
        }
        this.sem.acquireUninterruptibly();
        if (stalled) {
            this.app.readyToContinue(this.sem);
            this.sem.acquireUninterruptibly();
            LOGGER.info(this.barrierName + " for app " + this.app.getId() + " reacquired resources");
        }
        if (this.exception != null) {
            LOGGER.debug(this.barrierName + " raised a COMPSsException ( " + this.exception.getMessage() + ")");
            throw this.exception;
        }
    }

    @Override
    public int getGraphSource() {
        return this.graphSource;
    }

    @Override
    public void setGraphSource(int id) {
        this.graphSource = id;
    }
}

