/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.checkpoint.CheckpointGroup;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.TaskGroup;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.colors.ColorConfiguration;
import es.bsc.compss.types.colors.ColorNode;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.parameter.impl.Parameter;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.SignatureBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Task
extends AbstractTask {
    private static final String TASK_FAILED = "Task failed: ";
    private static final String TASK_CANCELED = "Task canceled: ";
    private static final int FIRST_TASK_ID = 1;
    private static AtomicInteger nextTaskId = new AtomicInteger(1);
    private final TaskDescription<Parameter> taskDescription;
    private Task enforcingTask;
    private int executionCount;
    private final TaskMonitor taskMonitor;
    private final TreeMap<Integer, CommutativeGroupTask> commutativeGroup;
    private final LinkedList<TaskGroup> taskGroups;
    private CheckpointGroup checkpointGroup;
    private boolean submitted;

    private Task(Application app, TaskMonitor monitor, TaskType type, COMPSsConstants.Lang lang, String signature, boolean isPrioritary, int numNodes, boolean isReduction, boolean isReplicated, boolean isDistributed, OnFailure onFailure, long timeOut, boolean hasTarget, int numReturns, List<Parameter> parameters) {
        super(app, nextTaskId.getAndIncrement());
        this.taskMonitor = monitor;
        this.commutativeGroup = new TreeMap();
        this.taskGroups = new LinkedList();
        CoreElement core = CoreManager.getCore(signature);
        String parallelismSource = app.getParallelismSource();
        this.taskDescription = new TaskDescription<Parameter>(type, lang, signature, core, parallelismSource, isPrioritary, numNodes, isReduction, isReplicated, isDistributed, hasTarget, numReturns, onFailure, timeOut, parameters);
        this.submitted = false;
    }

    public Task(Application app, COMPSsConstants.Lang lang, String signature, boolean isPrioritary, int numNodes, boolean isReduction, boolean isReplicated, boolean isDistributed, boolean hasTarget, int numReturns, List<Parameter> parameters, TaskMonitor monitor, OnFailure onFailure, long timeOut) {
        this(app, monitor, TaskType.METHOD, lang, signature, isPrioritary, numNodes, isReduction, isReplicated, isDistributed, onFailure, timeOut, hasTarget, numReturns, parameters);
    }

    public Task(Application app, String declareMethodFullyQualifiedName, boolean isPrioritary, boolean hasTarget, int numReturns, List<Parameter> parameters, TaskMonitor monitor, OnFailure onFailure, long timeOut) {
        this(app, monitor, TaskType.HTTP, COMPSsConstants.Lang.UNKNOWN, SignatureBuilder.getHTTPSignature(declareMethodFullyQualifiedName, hasTarget, numReturns, parameters), isPrioritary, 1, false, false, false, onFailure, timeOut, hasTarget, numReturns, parameters);
    }

    public void setEnforcingTask(Task task) {
        this.enforcingTask = task;
    }

    public boolean isFree() {
        return this.executionCount == 0;
    }

    public void setExecutionCount(int executionCount) {
        this.executionCount = executionCount;
    }

    public void decreaseExecutionCount() {
        --this.executionCount;
    }

    public TaskDescription<Parameter> getTaskDescription() {
        return this.taskDescription;
    }

    public boolean isSchedulingForced() {
        return this.enforcingTask != null;
    }

    public Task getEnforcingTask() {
        return this.enforcingTask;
    }

    public void setCommutativeGroup(CommutativeGroupTask com, EngineDataAccessId daId) {
        this.commutativeGroup.put(daId.getDataId(), com);
    }

    public CommutativeGroupTask getCommutativeGroup(Integer daId) {
        return this.commutativeGroup.get(daId);
    }

    public List<CommutativeGroupTask> getCommutativeGroupList() {
        LinkedList<CommutativeGroupTask> commutativeGroupList = new LinkedList<CommutativeGroupTask>();
        for (Map.Entry<Integer, CommutativeGroupTask> entry : this.commutativeGroup.entrySet()) {
            CommutativeGroupTask comTask = entry.getValue();
            commutativeGroupList.add(comTask);
        }
        return commutativeGroupList;
    }

    public void releaseCommutativeGroups() {
        for (CommutativeGroupTask group : this.commutativeGroup.values()) {
            group.finishedCommutativeTask(this);
        }
    }

    public void addTaskGroup(TaskGroup taskGroup) {
        this.taskGroups.add(taskGroup);
    }

    public LinkedList<TaskGroup> getTaskGroupList() {
        return this.taskGroups;
    }

    public CheckpointGroup getCheckpointGroup() {
        return this.checkpointGroup;
    }

    public void setCheckpointGroup(CheckpointGroup checkpointGroup) {
        this.checkpointGroup = checkpointGroup;
    }

    @Override
    public String getDotDescription() {
        int monitorTaskId = this.taskDescription.getCoreElement().getCoreId() + 1;
        ColorNode color = ColorConfiguration.getColors()[monitorTaskId % ColorConfiguration.NUM_COLORS];
        String shape = this.taskDescription.getType() == TaskType.METHOD ? (this.taskDescription.isReplicated() ? "doublecircle" : (this.taskDescription.isDistributed() ? "circle" : "circle")) : "diamond";
        return this.getId() + "[shape=" + shape + ", style=filled fillcolor=\"" + color.getFillColor() + "\" fontcolor=\"" + color.getFontColor() + "\"];";
    }

    @Override
    public String getLegendDescription() {
        StringBuilder information = new StringBuilder();
        information.append("<tr>").append("\n");
        information.append("<td align=\"right\">").append(this.getMethodName()).append("</td>").append("\n");
        information.append("<td bgcolor=\"").append(this.getColor()).append("\">&nbsp;</td>").append("\n");
        information.append("</tr>").append("\n");
        return information.toString();
    }

    public String getMethodName() {
        return this.taskDescription.getName();
    }

    @Override
    public String getColor() {
        int monitorTaskId = this.taskDescription.getCoreElement().getCoreId() + 1;
        ColorNode color = ColorConfiguration.getColors()[monitorTaskId % ColorConfiguration.NUM_COLORS];
        return color.getFillColor();
    }

    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    public boolean hasTaskGroups() {
        return !this.taskGroups.isEmpty();
    }

    public boolean hasCommutativeParams() {
        for (Parameter p : this.getTaskDescription().getParameters()) {
            if (!p.isPotentialDependency() || p.getDirection() != Direction.COMMUTATIVE) continue;
            return true;
        }
        return false;
    }

    public OnFailure getOnFailure() {
        return this.taskDescription.getOnFailure();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Task id: ").append(this.getId()).append("]");
        buffer.append(", [Status: ").append((Object)this.getStatus()).append("]");
        buffer.append(", ").append(this.getTaskDescription().toString()).append("]");
        return buffer.toString();
    }

    public List<Parameter> getParameters() {
        return this.taskDescription.getParameters();
    }

    @Override
    public boolean isReduction() {
        return this.taskDescription.isReduction();
    }

    public boolean wasSubmited() {
        return this.submitted;
    }

    public void setSubmitted() {
        this.submitted = true;
    }

    public final void register() {
        this.getApplication().onTaskAnalysisStart(this);
        boolean taskHasEdge = this.registerTask();
        this.getApplication().onTaskAnalysisEnd(this, taskHasEdge);
    }

    protected boolean registerTask() {
        int constrainingParam = -1;
        boolean taskHasEdge = false;
        int paramIdx = 0;
        for (Parameter param : this.getParameters()) {
            boolean isConstraining = paramIdx == constrainingParam;
            boolean paramHasEdge = param.register(this, isConstraining);
            taskHasEdge = taskHasEdge || paramHasEdge;
            ++paramIdx;
        }
        return taskHasEdge;
    }

    @Override
    public void end(boolean checkpointing) {
        int taskId = this.getId();
        boolean isFree = this.isFree();
        TaskState taskState = this.getStatus();
        LOGGER.info("Notification received for task " + taskId + " with end status " + (Object)((Object)taskState));
        if (!isFree) {
            LOGGER.debug("Task " + taskId + " is not registered as free. Waiting for other executions to end");
            return;
        }
        switch (taskState) {
            case FAILED: {
                OnFailure onFailure = this.getOnFailure();
                if (onFailure == OnFailure.RETRY || onFailure == OnFailure.FAIL) {
                    ErrorManager.error(TASK_FAILED + this);
                    return;
                }
                if (onFailure != OnFailure.IGNORE && onFailure != OnFailure.CANCEL_SUCCESSORS) break;
                ErrorManager.warn(TASK_FAILED + this);
                break;
            }
            case CANCELED: {
                ErrorManager.warn(TASK_CANCELED + this);
                break;
            }
        }
        if (DEBUG) {
            LOGGER.debug("Marking accessed parameters for task " + taskId);
        }
        if (this.getOnFailure() == OnFailure.CANCEL_SUCCESSORS && this.getStatus() == TaskState.FAILED || this.getStatus() == TaskState.CANCELED && this.getOnFailure() != OnFailure.IGNORE) {
            this.cancelParams();
        } else {
            this.commitParams();
        }
        if (DEBUG) {
            LOGGER.debug("Freeing barriers for task " + taskId);
        }
        if (DEBUG) {
            LOGGER.debug("Releasing waiting tasks for task " + taskId);
        }
        this.notifyListeners();
        if (DEBUG) {
            LOGGER.debug("Checking result file transfers for task " + taskId);
        }
        Application app = this.getApplication();
        app.endTask(this);
        TaskMonitor registeredMonitor = this.getTaskMonitor();
        switch (taskState) {
            case FAILED: {
                registeredMonitor.onFailure();
                break;
            }
            case CANCELED: {
                registeredMonitor.onCancellation();
                break;
            }
            default: {
                registeredMonitor.onCompletion();
            }
        }
        this.releaseCommutativeGroups();
        if (!checkpointing) {
            if (DEBUG) {
                LOGGER.debug("Checkpoint saving task " + taskId);
            }
            app.getCP().endTask(this);
        }
        super.end(checkpointing);
    }

    protected void commitParams() {
        for (Parameter param : this.getTaskDescription().getParameters()) {
            param.commit(this);
        }
    }

    protected void cancelParams() {
        for (Parameter param : this.getTaskDescription().getParameters()) {
            param.cancel(this);
        }
    }
}

