/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessid;

import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.info.DataVersion;

public class RWAccessId
extends EngineDataAccessId
implements EngineDataAccessId.ReadingDataAccessId,
EngineDataAccessId.WritingDataAccessId {
    private static final long serialVersionUID = 1L;
    private DataVersion readDataVersion;
    private DataVersion writtenDataVersion;

    public RWAccessId() {
    }

    public RWAccessId(DataInfo data, DataVersion rdv, DataVersion wdv) {
        super(data);
        this.readDataVersion = rdv;
        this.writtenDataVersion = wdv;
    }

    @Override
    public DataAccessId.Direction getDirection() {
        return DataAccessId.Direction.RW;
    }

    @Override
    public boolean isPreserveSourceData() {
        return this.readDataVersion.hasMoreReaders();
    }

    @Override
    public boolean isRead() {
        return true;
    }

    @Override
    public int getRVersionId() {
        return this.readDataVersion.getDataInstanceId().getVersionId();
    }

    @Override
    public DataVersion getReadDataVersion() {
        return this.readDataVersion;
    }

    @Override
    public EngineDataInstanceId getReadDataInstance() {
        return this.readDataVersion.getDataInstanceId();
    }

    @Override
    public boolean isWrite() {
        return true;
    }

    @Override
    public DataVersion getWrittenDataVersion() {
        return this.writtenDataVersion;
    }

    @Override
    public EngineDataInstanceId getWrittenDataInstance() {
        return this.writtenDataVersion.getDataInstanceId();
    }

    @Override
    public int getWVersionId() {
        return this.writtenDataVersion.getDataInstanceId().getVersionId();
    }

    public String toString() {
        return "Read data: " + this.readDataVersion.getDataInstanceId() + ", Written data: " + this.writtenDataVersion.getDataInstanceId() + (this.isPreserveSourceData() ? ", Preserved" : ", Erased");
    }

    @Override
    public EngineDataAccessId consolidateValidVersions() {
        if (!this.readDataVersion.isValid()) {
            DataVersion validR = this.readDataVersion.getPreviousValidPredecessor();
            if (validR != null) {
                return new RWAccessId(this.getAccessedDataInfo(), validR, this.writtenDataVersion);
            }
            return null;
        }
        return this;
    }

    @Override
    public String toDebugString() {
        int dataId = this.getDataId();
        StringBuilder sb = new StringBuilder("");
        sb.append("Access:").append("\n");
        sb.append("  * Type: RW").append("\n");
        sb.append("  * Read Datum: d").append(dataId).append("v").append(this.getRVersionId()).append("\n");
        sb.append("  * Write Datum: d").append(dataId).append("v").append(this.getWVersionId()).append("\n");
        return sb.toString();
    }
}

