/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.params;

import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.params.DataOwner;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataParams {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public abstract String getDescription();

    public final DataInfo register(DataOwner owner) {
        if (DEBUG) {
            LOGGER.debug("Registering Data associated to " + this.getDescription());
        }
        return this.registerData(owner);
    }

    public final DataInfo delete(DataOwner owner) throws ValueUnawareRuntimeException {
        if (DEBUG) {
            LOGGER.debug("Deleting Data associated to " + this.getDescription());
        }
        try {
            return this.unregisterData(owner);
        }
        catch (ValueUnawareRuntimeException vure) {
            if (DEBUG) {
                LOGGER.debug("No data found for data associated to " + this.getDescription());
            }
            throw vure;
        }
    }

    protected abstract DataInfo registerData(DataOwner var1);

    public abstract DataInfo getRegisteredData(DataOwner var1);

    protected abstract DataInfo unregisterData(DataOwner var1) throws ValueUnawareRuntimeException;

    public abstract void deleteLocal() throws Exception;
}

