/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.ParameterMonitor;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.colors.ColorConfiguration;
import es.bsc.compss.types.colors.ColorNode;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.parameter.impl.CollectiveParameter;
import es.bsc.compss.types.parameter.impl.FileParameter;
import es.bsc.compss.types.parameter.impl.Parameter;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReduceTask
extends Task {
    private static final ParameterMonitor IGNORE_PARAM = new ParameterMonitor(){

        @Override
        public void onCreation(DataType type, String dataName) {
        }
    };
    private final List<Task> tasks = new LinkedList<Task>();
    private int chunkSize;
    private double totalOperations;
    private final List<Parameter> partialsIn;
    private final List<Parameter> usedPartialsIn;
    private final List<Parameter> partialsOut;
    private final List<Parameter> usedPartialsOut;
    private final List<CollectiveParameter> intermediateCollections;
    private int reduceCollectionIndex = -1;
    private CollectiveParameter finalCol;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor");

    public ReduceTask(Application app, COMPSsConstants.Lang lang, String signature, boolean isPrioritary, int numNodes, boolean isReduction, int reduceChunkSize, boolean isReplicated, boolean isDistributed, boolean hasTarget, int numReturns, List<Parameter> parameters, TaskMonitor monitor, OnFailure onFailure, long timeOut) {
        super(app, lang, signature, isPrioritary, numNodes, isReduction, isReplicated, isDistributed, hasTarget, numReturns, parameters, monitor, onFailure, timeOut);
        this.chunkSize = reduceChunkSize;
        this.totalOperations = 0.0;
        this.partialsIn = new ArrayList<Parameter>();
        this.usedPartialsIn = new ArrayList<Parameter>();
        this.partialsOut = new ArrayList<Parameter>();
        this.usedPartialsOut = new ArrayList<Parameter>();
        this.intermediateCollections = new ArrayList<CollectiveParameter>();
        LOGGER.debug("[REDUCE-TASK] The REDUCE task has been created with chunk size " + this.chunkSize);
        try {
            this.createPartialParameters(parameters);
        }
        catch (IOException e) {
            LOGGER.debug("Exception detected when creating location for partials");
        }
    }

    private void createPartialParameters(List<Parameter> parameters) throws IOException {
        if (parameters.size() >= 2) {
            this.reduceCollectionIndex = this.searchFirstCollection(parameters);
            Parameter finalParameter = parameters.get(parameters.size() - 1);
            if (finalParameter.getDirection() == Direction.OUT && this.reduceCollectionIndex >= 0) {
                CollectiveParameter p = (CollectiveParameter)parameters.get(this.reduceCollectionIndex);
                List<Parameter> colList = p.getElements();
                if (colList.size() < 2) {
                    ErrorManager.warn("Reduce collection of Task " + this.getId() + " has not two parameters to reduce");
                }
                double completeOperations = 0.0;
                this.totalOperations = ResourceManager.getTotalNumberOfWorkers() + 1;
                double intermediateResults = 0.0;
                double accum = colList.size();
                while (accum > (double)this.chunkSize) {
                    completeOperations = Math.floor(accum / (double)this.chunkSize);
                    intermediateResults = accum % (double)this.chunkSize;
                    accum = completeOperations + intermediateResults;
                    this.totalOperations += accum;
                }
                LOGGER.debug("[REDUCE-TASK] Creating intermediate data (" + this.totalOperations + ") for reduce Task " + this.getId());
                Application app = this.getApplication();
                for (int i = 0; i < (int)this.totalOperations; ++i) {
                    String partialId = "reduce" + i + "PartialResultTask" + this.getId();
                    String canonicalPath = new File(partialId).getCanonicalPath();
                    SimpleURI uri = new SimpleURI(ProtocolType.FILE_URI.getSchema() + canonicalPath);
                    DataLocation dl = DataLocation.createLocation(Comm.getAppHost(), uri);
                    this.partialsOut.add(FileParameter.newFP(app, Direction.OUT, finalParameter.getStream(), finalParameter.getPrefix(), finalParameter.getName(), finalParameter.getType().toString(), finalParameter.getWeight(), finalParameter.isKeepRename(), dl, partialId, IGNORE_PARAM));
                    this.partialsIn.add(FileParameter.newFP(app, Direction.IN, finalParameter.getStream(), finalParameter.getPrefix(), finalParameter.getName(), finalParameter.getType().toString(), finalParameter.getWeight(), finalParameter.isKeepRename(), dl, partialId, IGNORE_PARAM));
                    CollectiveParameter cp = CollectiveParameter.newCP(app, DataType.COLLECTION_T, partialId + "Collection", p.getDirection(), p.getStream(), p.getPrefix(), p.getName(), p.getContentType(), p.getWeight(), p.isKeepRename(), IGNORE_PARAM, new ArrayList<Parameter>());
                    this.intermediateCollections.add(cp);
                }
                String finalId = "finalReduceTask" + this.getId();
                this.finalCol = CollectiveParameter.newCP(app, DataType.COLLECTION_T, finalId, Direction.IN, p.getStream(), p.getPrefix(), p.getName(), p.getContentType(), p.getWeight(), p.isKeepRename(), IGNORE_PARAM, new ArrayList<Parameter>());
            } else {
                ErrorManager.fatal("First parameter for a reduce task must be a collection and last parameter must be OUT or must have return");
            }
        } else {
            ErrorManager.fatal("Incorrect number of parameters for a reduce task. It should be higher than 2");
        }
    }

    private int searchFirstCollection(List<Parameter> parameters) {
        for (int i = 0; i < parameters.size() - 1; ++i) {
            if (parameters.get(i).getType() != DataType.COLLECTION_T) continue;
            return i;
        }
        return -1;
    }

    public int getReduceCollectionIndex() {
        return this.reduceCollectionIndex;
    }

    public List<Parameter> getIntermediateInParameters() {
        return this.partialsIn;
    }

    public List<Parameter> getIntermediateUsedInParameters() {
        return this.usedPartialsIn;
    }

    public void setPartialInUsed(Parameter partial) {
        this.usedPartialsIn.add(partial);
        this.partialsIn.remove(partial);
    }

    public List<Parameter> getIntermediateOutParameters() {
        return this.partialsOut;
    }

    public List<Parameter> getIntermediateUsedOutParameters() {
        return this.usedPartialsOut;
    }

    public void setPartialOutUsed(Parameter partial) {
        this.usedPartialsOut.add(partial);
        this.partialsOut.remove(partial);
    }

    public List<CollectiveParameter> getIntermediateCollections() {
        return this.intermediateCollections;
    }

    public CollectiveParameter getFinalCollection() {
        return this.finalCol;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void clearPartials() {
        this.partialsIn.clear();
        this.partialsOut.clear();
        this.intermediateCollections.clear();
    }

    private List<Parameter> getUnusedIntermediateParameters() {
        this.partialsIn.addAll(this.partialsOut);
        return this.partialsIn;
    }

    public int getTotalOperations() {
        return (int)this.totalOperations;
    }

    @Override
    public String getColor() {
        int monitorTaskId = this.getTaskDescription().getCoreElement().getCoreId() + 1;
        ColorNode color = ColorConfiguration.getColors()[monitorTaskId % (ColorConfiguration.NUM_COLORS + 1)];
        return color.getFillColor();
    }

    private List<Parameter> getParameterDataToRemove() {
        LinkedList<Parameter> dataToRemove = new LinkedList<Parameter>();
        dataToRemove.addAll(this.getIntermediateInParameters());
        dataToRemove.addAll(this.getIntermediateOutParameters());
        dataToRemove.addAll(this.getIntermediateCollections());
        return dataToRemove;
    }

    private List<Parameter> getIntermediateParameters() {
        LinkedList<Parameter> interParams = new LinkedList<Parameter>();
        interParams.addAll(this.getIntermediateOutParameters());
        interParams.addAll(this.getIntermediateInParameters());
        interParams.addAll(this.getIntermediateCollections());
        interParams.add(this.finalCol);
        return interParams;
    }

    @Override
    protected boolean registerTask() {
        boolean hasEdge = super.registerTask();
        for (Parameter p : this.getIntermediateParameters()) {
            p.register(this, false);
        }
        for (Parameter p : this.getParameterDataToRemove()) {
            try {
                p.removeData();
            }
            catch (ValueUnawareRuntimeException valueUnawareRuntimeException) {}
        }
        return hasEdge;
    }

    @Override
    protected void commitParams() {
        super.commitParams();
        for (Parameter param : this.getUnusedIntermediateParameters()) {
            param.commit(this);
        }
    }

    @Override
    protected void cancelParams() {
        super.cancelParams();
        for (Parameter param : this.getUnusedIntermediateParameters()) {
            param.cancel(this);
        }
    }
}

