/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.monitor.impl;

import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.RuntimeMonitor;
import es.bsc.compss.types.Task;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GraphGenerator {
    private static final boolean DRAW_GRAPH = System.getProperty("compss.graph") != null && "true".equals(System.getProperty("compss.graph"));
    private static final boolean GRAPH_GENERATOR_ENABLED = RuntimeMonitor.isEnabled() || DRAW_GRAPH;
    private static final String STREAM_DOT_DESCRIPTION = "[shape=rect style=\"rounded,filled\" width=0 height=0 margin=0.1 fontsize=10 fillcolor=\"#a9a9a9\" fontcolor=\"#000000\"]";
    private static final String CURRENT_GRAPH_FILENAME = "current_graph.dot";
    private static final String COMPLETE_GRAPH_FILENAME = "complete_graph.dot";
    private static final String COMPLETE_GRAPH_TMP_FILENAME = "complete_graph.dot.tmp";
    private static final String COMPLETE_LEGEND_TMP_FILENAME = "complete_legend.dot.tmp";
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components");
    private static final String ERROR_ADDING_DATA = "Error adding task to graph file";
    private static final String ERROR_ADDING_EDGE = "Error adding edge to graph file";
    private static final String ERROR_OPEN_CURRENT_GRAPH = "Error openning current graph file";
    private static final String ERROR_CLOSE_CURRENT_GRAPH = "Error closing current graph file";
    private static final String ERROR_COMMIT_FINAL_GRAPH = "Error commiting full graph to file";
    private final String currentGraphPath;
    private final String completeGraphPath;
    private final String completeGraphTmpPath;
    private final String completeLegendTmpPath;
    private BufferedWriter fullGraph;
    private BufferedWriter currentGraph;
    private BufferedWriter legend;
    private HashSet<Integer> legendTasks;
    private int openCollectivesEdges = 0;
    private HashMap<String, List<Task>> openCommutativeGroups = new HashMap();
    private HashMap<String, List<String>> pendingGroupDependencies = new HashMap();

    public static boolean isEnabled() {
        return GRAPH_GENERATOR_ENABLED;
    }

    public GraphGenerator(String graphPath) {
        this.currentGraphPath = graphPath + CURRENT_GRAPH_FILENAME;
        this.completeGraphPath = graphPath + COMPLETE_GRAPH_FILENAME;
        this.completeGraphTmpPath = graphPath + COMPLETE_GRAPH_TMP_FILENAME;
        this.completeLegendTmpPath = graphPath + COMPLETE_LEGEND_TMP_FILENAME;
        if (GRAPH_GENERATOR_ENABLED) {
            try {
                this.currentGraph = new BufferedWriter(new FileWriter(this.currentGraphPath));
                this.emptyCurrentGraph();
                this.currentGraph.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Error generating current graph file", (Throwable)ioe);
            }
            try {
                this.fullGraph = new BufferedWriter(new FileWriter(this.completeGraphPath));
                this.emptyFullGraph();
                this.fullGraph.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Error generating full graph file", (Throwable)ioe);
            }
            try {
                this.fullGraph = new BufferedWriter(new FileWriter(this.completeGraphTmpPath));
                this.openFullGraphFile(this.fullGraph);
                this.openDependenceGraph(this.fullGraph);
            }
            catch (IOException ioe) {
                LOGGER.error("Error generating graph file", (Throwable)ioe);
            }
            try {
                this.legend = new BufferedWriter(new FileWriter(this.completeLegendTmpPath));
            }
            catch (IOException ioe) {
                LOGGER.error("Error generating full graph working copy file", (Throwable)ioe);
            }
            this.legendTasks = new HashSet();
        }
    }

    public BufferedWriter getAndOpenCurrentGraph() {
        try {
            this.currentGraph = new BufferedWriter(new FileWriter(this.currentGraphPath));
            this.openCurrentGraphFile(this.currentGraph);
        }
        catch (IOException e) {
            LOGGER.error(ERROR_OPEN_CURRENT_GRAPH);
            return null;
        }
        return this.currentGraph;
    }

    public void closeCurrentGraph() {
        try {
            this.closeGraphFile(this.currentGraph);
            this.currentGraph.close();
        }
        catch (IOException e) {
            LOGGER.error(ERROR_CLOSE_CURRENT_GRAPH);
        }
    }

    public void commitGraph(boolean noMoreTasks) {
        LOGGER.debug("Commiting graph to final location");
        try {
            this.fullGraph.close();
            try (FileInputStream sourceFIS = new FileInputStream(this.completeGraphTmpPath);
                 FileOutputStream destFOS = new FileOutputStream(this.completeGraphPath);
                 FileChannel sourceChannel = sourceFIS.getChannel();
                 FileChannel destChannel = destFOS.getChannel();){
                destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
            }
            this.fullGraph = new BufferedWriter(new FileWriter(this.completeGraphTmpPath, true));
            BufferedWriter finalGraph = new BufferedWriter(new FileWriter(this.completeGraphPath, true));
            this.closeDependenceGraph(finalGraph);
            this.openLegend(finalGraph);
            this.legend.close();
            try (FileInputStream sourceFIS = new FileInputStream(this.completeLegendTmpPath);
                 FileOutputStream destFOS = new FileOutputStream(this.completeGraphPath, true);
                 FileChannel sourceChannel = sourceFIS.getChannel();
                 FileChannel destChannel = destFOS.getChannel();){
                destChannel.position(destChannel.size());
                sourceChannel.transferTo(0L, sourceChannel.size(), destChannel);
            }
            this.legend = new BufferedWriter(new FileWriter(this.completeLegendTmpPath, true));
            if (noMoreTasks) {
                this.closeLegend(finalGraph);
                this.closeGraphFile(finalGraph);
            }
            finalGraph.close();
        }
        catch (IOException e) {
            LOGGER.error(ERROR_COMMIT_FINAL_GRAPH, (Throwable)e);
        }
    }

    public void addSynchroToGraph(int synchId) {
        try {
            this.fullGraph.newLine();
            if (synchId == 0) {
                this.fullGraph.write("Synchro" + synchId + "[label=\"main\", shape=octagon, style=filled fillcolor=\"#8B0000\" fontcolor=\"#FFFFFF\"];");
            } else {
                this.fullGraph.write("Synchro" + synchId + "[label=\"sync\", shape=octagon, style=filled fillcolor=\"#ff0000\" fontcolor=\"#FFFFFF\"];");
            }
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addBarrierToGraph(int synchId) {
        try {
            this.fullGraph.newLine();
            this.fullGraph.write("Synchro" + synchId + "[label=\"barrier\", shape=octagon, style=filled fillcolor=\"#ff0000\" fontcolor=\"#FFFFFF\"];");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addTaskToGraph(Task task) {
        if (!task.hasCommutativeParams()) {
            this.addTask(task);
        }
    }

    private void addTask(Task task) {
        try {
            this.fullGraph.newLine();
            this.fullGraph.write(task.getDotDescription());
            int taskId = task.getTaskDescription().getCoreElement().getCoreId();
            if (!this.legendTasks.contains(taskId)) {
                this.legendTasks.add(taskId);
                this.legend.write(task.getLegendDescription());
            }
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addCommutativeGroup(String identifier) {
        LinkedList tasks = new LinkedList();
        this.openCommutativeGroups.put(identifier, tasks);
    }

    public void addTaskToCommutativeGroup(Task task, String identifier) {
        List<Task> tasks = this.openCommutativeGroups.get(identifier);
        if (tasks == null) {
            tasks = new LinkedList<Task>();
            this.openCommutativeGroups.put(identifier, tasks);
        }
        tasks.add(task);
    }

    public void closeCommutativeGroup(String identifier) {
        List<Task> tasks = this.openCommutativeGroups.remove(identifier);
        this.printCommutativeGroup(identifier, tasks);
    }

    public void addStreamToGraph(String label) {
        try {
            this.fullGraph.newLine();
            String dotDescription = label + STREAM_DOT_DESCRIPTION;
            this.fullGraph.write(dotDescription);
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void startGroupingEdges() {
        ++this.openCollectivesEdges;
    }

    public void stopGroupingEdges() {
        --this.openCollectivesEdges;
    }

    public void addEdgeToGraph(String src, String tgt, EdgeType edgeType, String label) {
        if (this.openCollectivesEdges == 0) {
            if (this.pendingGroupDependencies.isEmpty()) {
                this.addSingleElementEdgeToGraph(src, tgt, edgeType, label);
            } else {
                this.addSingleElementEdgeToGraph(src, tgt, edgeType, label);
                for (Map.Entry<String, List<String>> entry : this.pendingGroupDependencies.entrySet()) {
                    String srctgt = entry.getKey();
                    try {
                        this.fullGraph.newLine();
                        Boolean first = false;
                        String f = "";
                        String l = "";
                        for (String s : this.pendingGroupDependencies.get(srctgt)) {
                            if (first.booleanValue() && this.pendingGroupDependencies.get(srctgt).size() <= 2) {
                                l = ",d" + s;
                                continue;
                            }
                            if (first.booleanValue() && this.pendingGroupDependencies.get(srctgt).size() > 2) {
                                l = ",...,d" + s;
                                continue;
                            }
                            first = true;
                            f = "d" + s;
                        }
                        if (this.pendingGroupDependencies.get(srctgt).size() <= 2) {
                            this.fullGraph.write(srctgt + " [label=\"[" + f + l + "]\",color=\"#024b30\",penwidth=2];");
                            continue;
                        }
                        this.fullGraph.write(srctgt + " [label=\"[" + f + l + "](" + this.pendingGroupDependencies.get(srctgt).size() + ")\",color=\"#024b30\",penwidth=2];");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.pendingGroupDependencies.clear();
            }
        } else {
            List<String> labels = this.pendingGroupDependencies.get(src + " -> " + tgt);
            if (labels == null) {
                labels = new LinkedList<String>();
            }
            labels.add(label);
            this.pendingGroupDependencies.put(src + " -> " + tgt, labels);
        }
    }

    private void addSingleElementEdgeToGraph(String src, String tgt, EdgeType edgeType, String label) {
        try {
            StringBuilder edgeProperties = new StringBuilder();
            String edgeTypeProps = edgeType.getProperties();
            if (!edgeTypeProps.isEmpty() || !label.isEmpty()) {
                edgeProperties.append(" [");
                if (!edgeTypeProps.isEmpty()) {
                    edgeProperties.append(edgeTypeProps);
                    if (!label.isEmpty()) {
                        edgeProperties.append(", ");
                    }
                }
                if (!label.isEmpty()) {
                    edgeProperties.append("label=\"d").append(label).append("\"");
                }
                edgeProperties.append("]");
            }
            edgeProperties.append(";");
            this.fullGraph.newLine();
            this.fullGraph.write(src + " -> " + tgt + edgeProperties.toString());
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_EDGE, (Throwable)e);
        }
    }

    public void removeTemporaryGraph() {
        if (!new File(this.completeGraphTmpPath).delete()) {
            LOGGER.error("Cannot remove temporary graph file");
        }
        if (!new File(this.completeLegendTmpPath).delete()) {
            LOGGER.error("Cannot remove temporary legend file");
        }
    }

    public void addEdgeToGraphFromGroup(String src, String tgt, String label, String identifier, String clusterType, EdgeType edgeType) {
        try {
            StringBuilder edgeProperties = new StringBuilder();
            String edgeTypeProps = edgeType.getProperties();
            if (!edgeTypeProps.isEmpty() || !label.isEmpty()) {
                edgeProperties.append(" [");
                if (!edgeTypeProps.isEmpty()) {
                    edgeProperties.append(edgeTypeProps);
                    if (!label.isEmpty()) {
                        edgeProperties.append(", ");
                    }
                }
                if (!label.isEmpty()) {
                    edgeProperties.append("label=\"d").append(label).append("\"");
                }
                edgeProperties.append("]");
            }
            edgeProperties.append("[ ltail=\"").append(clusterType).append(identifier).append("\" ]");
            edgeProperties.append(";");
            this.fullGraph.newLine();
            this.fullGraph.write(src + " -> " + tgt + edgeProperties.toString());
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_EDGE, (Throwable)e);
        }
    }

    public void closeCommutativeGroups() {
        for (Map.Entry<String, List<Task>> entry : this.openCommutativeGroups.entrySet()) {
            String identifier = entry.getKey();
            List<Task> tasks = entry.getValue();
            this.printCommutativeGroup(identifier, tasks);
        }
        this.openCommutativeGroups.clear();
    }

    private void printCommutativeGroup(String identifier, List<Task> tasks) {
        try {
            this.fullGraph.newLine();
            StringBuilder msg1 = new StringBuilder();
            msg1.append("subgraph clusterCommutative").append(identifier).append(" {\n");
            this.fullGraph.write(msg1.toString());
            StringBuilder msg2 = new StringBuilder();
            msg2.append("shape=rect;\n");
            msg2.append("node[height=0.75];\n");
            msg2.append("color=\"#A9A9A9\";\n");
            msg2.append("rank=same;\n");
            msg2.append("label=\"CGT").append(identifier).append("\";\n");
            this.fullGraph.write(msg2.toString());
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
        if (tasks != null) {
            for (Task task : tasks) {
                this.addTask(task);
            }
        }
        try {
            this.fullGraph.newLine();
            this.fullGraph.write("}\n");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addReduceTaskToGraph(int identifier) {
        try {
            this.fullGraph.newLine();
            StringBuilder msg1 = new StringBuilder();
            msg1.append("subgraph clusterReduce").append(identifier).append(" {\n");
            this.fullGraph.write(msg1.toString());
            StringBuilder msg2 = new StringBuilder();
            msg2.append("shape=rect;\n");
            msg2.append("node[height=0.75];\n");
            msg2.append("color=\"#A9A9A9\";\n");
            msg2.append("rank=same;\n");
            msg2.append("label=\"RT").append(identifier).append("\";\n");
            this.fullGraph.write(msg2.toString());
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void addTaskGroupToGraph(String identifier) {
        try {
            this.fullGraph.newLine();
            this.fullGraph.write("subgraph clusterTasks" + identifier + " {\n");
            this.fullGraph.write("shape=rect;\nnode[height=0.75];\ncolor=\"#A9A9A9\"; \nlabel=\"" + identifier + "\";\n");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void closeGroupInGraph() {
        try {
            this.fullGraph.newLine();
            this.fullGraph.write("}\n");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    public void createNewSubgraph() {
        try {
            this.fullGraph.newLine();
            this.fullGraph.write("subgraph{\n");
            this.fullGraph.newLine();
            this.fullGraph.write("                node[height=0.75];\n");
        }
        catch (IOException e) {
            LOGGER.error(ERROR_ADDING_DATA, (Throwable)e);
        }
    }

    private void emptyFullGraph() throws IOException {
        this.openFullGraphFile(this.fullGraph);
        this.openDependenceGraph(this.fullGraph);
        this.closeDependenceGraph(this.fullGraph);
        this.openLegend(this.fullGraph);
        this.closeLegend(this.fullGraph);
        this.closeGraphFile(this.fullGraph);
    }

    private void emptyCurrentGraph() throws IOException {
        this.openCurrentGraphFile(this.currentGraph);
        this.openDependenceGraph(this.currentGraph);
        this.closeDependenceGraph(this.currentGraph);
        this.closeGraphFile(this.currentGraph);
    }

    private void openFullGraphFile(BufferedWriter graph) throws IOException {
        graph.write("digraph {");
        graph.newLine();
        graph.write("  newrank=true;");
        graph.newLine();
        graph.write("  rankdir=TB;");
        graph.newLine();
        graph.write("  labeljust=\"l\";");
        graph.newLine();
        graph.write("  compound= true;");
        graph.newLine();
        graph.flush();
    }

    private void openCurrentGraphFile(BufferedWriter graph) throws IOException {
        graph.write("digraph {");
        graph.newLine();
        graph.write("  rankdir=TB;");
        graph.newLine();
        graph.write("  labeljust=\"l\";");
        graph.newLine();
        graph.write("  compound= true;");
        graph.newLine();
        graph.flush();
    }

    private void openDependenceGraph(BufferedWriter graph) throws IOException {
        graph.write("  subgraph dependence_graph {");
        graph.newLine();
        graph.write("    ranksep=0.20;");
        graph.newLine();
        graph.write("    node[height=0.75];");
        graph.newLine();
        graph.flush();
    }

    private void openLegend(BufferedWriter graph) throws IOException {
        graph.write("  subgraph legend {");
        graph.newLine();
        graph.write("    rank=sink;");
        graph.newLine();
        graph.write("    node [shape=plaintext, height=0.75];");
        graph.newLine();
        graph.write("    ranksep=0.20;");
        graph.newLine();
        graph.write("    label = \"Legend\";");
        graph.newLine();
        graph.write("    key [label=<");
        graph.newLine();
        graph.write("      <table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" cellborder=\"1\">");
        graph.newLine();
        graph.flush();
    }

    private void closeGraphFile(BufferedWriter graph) throws IOException {
        graph.write("}");
        graph.newLine();
        graph.flush();
    }

    private void closeDependenceGraph(BufferedWriter graph) throws IOException {
        graph.write("  }");
        graph.newLine();
        graph.flush();
    }

    private void closeLegend(BufferedWriter graph) throws IOException {
        graph.write("      </table>");
        graph.newLine();
        graph.write("    >]");
        graph.newLine();
        graph.write("  }");
        graph.newLine();
        graph.flush();
    }
}

