/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.access;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessid.EngineDataAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.info.DataInfo;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.params.DataParams;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MainAccess<V, D extends DataParams, P extends AccessParams<D>> {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.API");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final Application app;
    private final P parameters;

    protected MainAccess(Application app, P params) {
        this.app = app;
        this.parameters = params;
    }

    public Application getApp() {
        return this.app;
    }

    public final P getParameters() {
        return this.parameters;
    }

    protected abstract boolean resultRemainOnMain();

    public abstract V getUnavailableValueResponse();

    public abstract V fetch(EngineDataAccessId var1);

    public EngineDataAccessId register(RegisterDataAccessRequest rdar) throws ValueUnawareRuntimeException {
        P accessParams = this.parameters;
        if (DEBUG) {
            Long appId = this.getApp().getId();
            LOGGER.debug("Registering access " + accessParams.toString() + " from App " + appId + "'s main code");
        }
        ((AccessParams)accessParams).checkAccessValidity();
        EngineDataAccessId accessId = ((AccessParams)accessParams).register();
        if (accessId == null) {
            if (DEBUG) {
                LOGGER.debug("Accessing a canceled data from main code. Returning null");
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Registered main access {\"source\":{\"app\":" + this.app.getId() + ",},\"access\":" + accessId.toDebugString() + "}");
            }
            if (accessId.isRead()) {
                EngineDataAccessId.ReadingDataAccessId rdaId = (EngineDataAccessId.ReadingDataAccessId)((Object)accessId);
                EngineDataInstanceId rdiID = rdaId.getReadDataInstance();
                Application app = this.getApp();
                app.getCP().mainAccess(rdiID);
                DataInfo di = accessId.getAccessedDataInfo();
                di.mainAccess(rdar, accessId);
            }
        }
        return accessId;
    }

    public abstract boolean isAccessFinishedOnRegistration();

    protected static DataLocation createLocalLocation(SimpleURI targetURI) {
        DataLocation targetLocation = null;
        try {
            targetLocation = DataLocation.createLocation(Comm.getAppHost(), targetURI);
        }
        catch (IOException ioe) {
            ErrorManager.error("ERROR: Invalid location URI " + targetURI, ioe);
        }
        return targetLocation;
    }

    public void finish(EngineDataInstanceId generatedData) {
        EngineDataAccessId daid;
        if (generatedData != null && this.resultRemainOnMain()) {
            generatedData.getVersion().valueOnMain();
        }
        if ((daid = ((AccessParams)this.parameters).getLastRegisteredAccess()) == null) {
            LOGGER.warn(((AccessParams)this.parameters).getDataDescription() + " has not been accessed before");
            return;
        }
        daid.commit();
    }
}

