/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.EngineDataInstanceId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.ObjectAccessParams;
import es.bsc.compss.types.data.info.DataVersion;
import es.bsc.compss.types.data.params.ExternalPSCObjectData;

public class ExternalPSCObjectAccessParams
extends ObjectAccessParams<String, ExternalPSCObjectData> {
    private static final long serialVersionUID = 1L;

    public static final ExternalPSCObjectAccessParams constructEPOAP(Application app, Direction dir, String pscoId, int hashCode) {
        return new ExternalPSCObjectAccessParams(app, dir, pscoId, hashCode);
    }

    private ExternalPSCObjectAccessParams(Application app, Direction dir, String pscoId, int hashCode) {
        super(app, new ExternalPSCObjectData(hashCode), dir, pscoId);
    }

    public String getPSCOId() {
        return (String)this.getValue();
    }

    @Override
    protected void registerValueForVersion(DataVersion dv) {
        if (this.mode != AccessParams.AccessMode.W) {
            EngineDataInstanceId lastDID = dv.getDataInstanceId();
            String renaming = lastDID.getRenaming();
            Comm.registerExternalPSCO(renaming, this.getPSCOId());
        } else {
            dv.invalidate();
        }
    }
}

