/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.accessparams;

import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataParams;
import es.bsc.compss.types.request.exceptions.ValueUnawareRuntimeException;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AccessParams<D extends DataParams>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.DataInfoProvider");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected final D data;
    protected final AccessMode mode;

    private static AccessMode getAccessMode(Direction d) {
        AccessMode am = AccessMode.R;
        switch (d) {
            case IN: 
            case IN_DELETE: {
                am = AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessMode.CV;
            }
        }
        return am;
    }

    protected AccessParams(D data, Direction dir) {
        this.data = data;
        this.mode = AccessParams.getAccessMode(dir);
    }

    public final Application getApp() {
        return ((DataParams)this.data).getApp();
    }

    public D getData() {
        return this.data;
    }

    public final AccessMode getMode() {
        return this.mode;
    }

    public Integer getDataId(DataInfoProvider dip) {
        return ((DataParams)this.data).getDataId(dip);
    }

    public String getDataDescription() {
        return ((DataParams)this.data).getDescription();
    }

    public abstract void checkAccessValidity(DataInfoProvider var1) throws ValueUnawareRuntimeException;

    public abstract void registeredAsFirstVersionForData(DataInfo var1);

    public abstract boolean resultRemainOnMain();

    public abstract void externalRegister();

    public static enum AccessMode {
        R,
        W,
        RW,
        C,
        CV;

    }
}

