/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.allocatableactions;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.types.resources.updates.PendingReduction;
import es.bsc.compss.types.resources.updates.ResourceUpdate;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class StopWorkerAction
extends AllocatableAction {
    private final ResourceScheduler<? extends WorkerResourceDescription> worker;
    private final Implementation impl;
    private final PendingReduction<WorkerResourceDescription> ru;

    public StopWorkerAction(SchedulingInformation schedulingInformation, ResourceScheduler<? extends WorkerResourceDescription> worker, TaskScheduler ts, ResourceUpdate<? extends WorkerResourceDescription> modification) {
        super(schedulingInformation, ts.getOrchestrator());
        this.worker = worker;
        this.ru = (PendingReduction)modification;
        this.impl = worker.getResource().getType() == Resource.Type.WORKER ? new MethodImplementation("", "", null, null, new MethodResourceDescription()) : new ServiceImplementation(null, "", "", "", "");
    }

    @Override
    public boolean isToReserveResources() {
        return false;
    }

    @Override
    public boolean isToReleaseResources() {
        return false;
    }

    @Override
    protected void doAction() {
        new Thread(){

            @Override
            public void run() {
                Worker wResource = StopWorkerAction.this.worker.getResource();
                Thread.currentThread().setName(wResource.getName() + " stopper");
                wResource.retrieveData(true);
                Semaphore sem = new Semaphore(0);
                ShutdownListener sl = new ShutdownListener(sem);
                wResource.stop(sl);
                sl.enable();
                try {
                    sem.acquire();
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: Exception raised on worker shutdown", (Throwable)e);
                    ErrorManager.warn("Exception stopping worker. Check runtime.log for more details", e);
                    StopWorkerAction.this.notifyError();
                }
                StopWorkerAction.this.notifyCompleted();
            }
        }.start();
    }

    @Override
    protected void doCompleted() {
        this.removeResource();
    }

    private void removeResource() {
        Worker<? extends WorkerResourceDescription> w = this.worker.getResource();
        if (w instanceof CloudMethodWorker) {
            CloudMethodWorker cmw = (CloudMethodWorker)w;
            ResourceManager.terminateCloudResource(cmw, (CloudMethodResourceDescription)this.ru.getModification());
        } else {
            ResourceManager.removeWorker(w);
        }
    }

    @Override
    protected void doError() throws FailedActionException {
        throw new FailedActionException();
    }

    @Override
    protected void doFailed() {
        this.removeResource();
    }

    @Override
    public Integer getCoreId() {
        return null;
    }

    public LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> workers = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        workers.add(this.worker);
        return workers;
    }

    @Override
    public Implementation[] getImplementations() {
        Implementation[] impls = new Implementation[]{this.impl};
        return impls;
    }

    @Override
    public <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> r) {
        return r == this.worker.getResource();
    }

    public <T extends WorkerResourceDescription> LinkedList<Implementation> getCompatibleImplementations(ResourceScheduler<T> r) {
        LinkedList<Implementation> impls = new LinkedList<Implementation>();
        if (r == this.worker) {
            impls.add(this.impl);
        }
        return impls;
    }

    @Override
    public <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> targetWorker, Score actionScore) {
        return null;
    }

    @Override
    public void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(this.worker, this.impl);
    }

    @Override
    public void tryToSchedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(actionScore);
    }

    @Override
    public <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(targetWorker, this.impl);
    }

    @Override
    public <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> targetWorker, Implementation impl) throws BlockedActionException, UnassignedActionException {
        if (targetWorker != this.getEnforcedTargetResource()) {
            throw new UnassignedActionException();
        }
        this.assignResource(targetWorker);
        this.assignImplementation(impl);
        targetWorker.scheduleAction(this);
    }

    @Override
    public String toString() {
        return "StopWorkerAction (Worker " + this.worker.getName() + ")";
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

