/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.location;

import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.PrivateLocation;
import es.bsc.compss.types.data.location.SharedLocation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.SharedDiskManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataLocation
implements Comparable<DataLocation> {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    public static final String ERROR_INVALID_LOCATION = "ERROR: Invalid location URI";
    public static final String ERROR_UNSTARTED_NODE = "ERROR: Cannot retrieve URIs from an unstarted node";

    public static DataLocation createLocation(Resource host, SimpleURI uri) throws IOException {
        Protocol protocol = Protocol.getBySchema(uri.getSchema());
        if (protocol == null) {
            LOGGER.warn("WARN: Unrecognised protocol [ " + uri.getSchema() + " ] for createLocation. Switching to " + Protocol.ANY_URI.getSchema());
            protocol = Protocol.ANY_URI;
        }
        DataLocation loc = null;
        switch (protocol) {
            case FILE_URI: {
                String canonicalPath = null;
                try {
                    canonicalPath = new URI(uri.getPath()).normalize().getPath();
                    if ('/' != canonicalPath.charAt(0)) {
                        canonicalPath = new File(uri.getPath()).getCanonicalPath();
                    }
                }
                catch (URISyntaxException e) {
                    canonicalPath = new File(uri.getPath()).getCanonicalPath();
                }
                LOGGER.debug("Creating new FileLocation: " + protocol.getSchema() + host.getName() + "@" + canonicalPath);
                loc = DataLocation.createLocation(Protocol.FILE_URI, host, canonicalPath);
                break;
            }
            case SHARED_URI: {
                int splitIndex = uri.getPath().indexOf(File.separator);
                String diskName = uri.getPath().substring(0, splitIndex);
                String path = uri.getPath().substring(splitIndex + 1);
                LOGGER.debug("Creating new SharedLocation: " + protocol.getSchema() + "@" + diskName + path);
                loc = new SharedLocation(Protocol.SHARED_URI, diskName, path);
                break;
            }
            case OBJECT_URI: {
                String objectName = uri.getPath();
                LOGGER.debug("Creating new ObjectLocation: " + protocol.getSchema() + host.getName() + "@" + objectName);
                loc = DataLocation.createLocation(Protocol.OBJECT_URI, host, objectName);
                break;
            }
            case PERSISTENT_URI: {
                String id = uri.getPath();
                LOGGER.debug("Creating new PersistentLocation: " + id);
                loc = new PersistentLocation(id);
                break;
            }
            case ANY_URI: {
                LOGGER.debug("Creating new AnyLocation: " + Protocol.ANY_URI.getSchema() + host.getName() + "@" + uri.getPath());
                loc = DataLocation.createLocation(Protocol.ANY_URI, host, uri.getPath());
            }
        }
        return loc;
    }

    private static DataLocation createLocation(Protocol protocol, Resource host, String path) {
        String diskName = SharedDiskManager.getSharedName(host, path);
        if (diskName != null) {
            String mountpoint = SharedDiskManager.getMounpoint(host, diskName);
            SharedLocation sharLoc = new SharedLocation(protocol, diskName, path.substring(mountpoint.length()));
            return sharLoc;
        }
        PrivateLocation privLoc = new PrivateLocation(protocol, host, path);
        return privLoc;
    }

    public abstract Type getType();

    public abstract Protocol getProtocol();

    public abstract List<MultiURI> getURIs();

    public abstract String getSharedDisk();

    public abstract List<Resource> getHosts();

    public abstract String getPath();

    public abstract MultiURI getURIInHost(Resource var1);

    public abstract boolean isTarget(DataLocation var1);

    public abstract String getLocationKey();

    public static enum Protocol {
        FILE_URI("file://"),
        SHARED_URI("shared://"),
        OBJECT_URI("object://"),
        PERSISTENT_URI("storage://"),
        ANY_URI("any://");

        private final String schema;

        private Protocol(String schema) {
            this.schema = schema;
        }

        public String getSchema() {
            return this.schema;
        }

        public static Protocol getBySchema(String schema) {
            for (Protocol p : Protocol.values()) {
                if (!p.schema.equals(schema)) continue;
                return p;
            }
            return null;
        }
    }

    public static enum Type {
        PRIVATE,
        SHARED,
        PERSISTENT;

    }
}

