/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.operation;

import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.operation.DataOperation;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultListener
extends EventListener {
    private int operation = 0;
    private int errors = 0;
    private boolean enabled = false;
    private static final Logger logger = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.FileTransferManager");
    private static final boolean debug = logger.isDebugEnabled();
    private Semaphore sem;

    public ResultListener(Semaphore sem) {
        this.sem = sem;
    }

    public synchronized void enable() {
        this.enabled = true;
        if (this.operation == 0) {
            if (this.errors == 0) {
                this.doReady();
            } else {
                this.doFailures();
            }
        }
    }

    public synchronized void addOperation() {
        ++this.operation;
    }

    @Override
    public synchronized void notifyEnd(DataOperation fOp) {
        --this.operation;
        if (this.operation == 0 && this.enabled) {
            if (this.errors == 0) {
                this.doReady();
            } else {
                this.doFailures();
            }
        }
    }

    @Override
    public synchronized void notifyFailure(DataOperation fOp, Exception e) {
        if (debug) {
            logger.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOp.getName() + ", file role is RESULT_FILE" + ", operation end state is FAILED", (Throwable)e);
        } else {
            logger.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOp.getName() + ", file role is RESULT_FILE" + ", operation end state is FAILED");
        }
        --this.operation;
        ++this.errors;
        if (this.enabled && this.operation == 0) {
            this.doFailures();
        }
    }

    private void doReady() {
        this.sem.release();
    }

    private void doFailures() {
        this.sem.release();
    }
}

