/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.FileInfo;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.request.ap.APRequest;
import java.io.File;

public class DeleteFileRequest
extends APRequest {
    private final DataLocation loc;

    public DeleteFileRequest(DataLocation loc) {
        this.loc = loc;
    }

    public DataLocation getLocation() {
        return this.loc;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        FileInfo fileInfo = dip.deleteData(this.loc);
        if (fileInfo == null) {
            String filePath = this.loc.getURIs().get(0).getPath();
            File f = new File(filePath);
            if (f.delete()) {
                LOGGER.info("File " + filePath + "deleted");
            } else {
                LOGGER.error("Error on deleting file " + filePath);
            }
        } else {
            ta.deleteFile(fileInfo);
        }
    }

    @Override
    public APRequest.APRequestType getRequestType() {
        return APRequest.APRequestType.DELETE_FILE;
    }
}

