/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader.total;

import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.loader.LoaderUtils;
import es.bsc.compss.loader.total.ITAppEditor;
import es.bsc.compss.util.ErrorManager;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ITAppModifier {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Loader");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String COMPSS_APP_CONSTANT = LoaderConstants.CLASS_COMPSS_CONSTANTS + ".APP_NAME";
    private static final ClassPool CLASS_POOL = ClassPool.getDefault();
    private static final boolean WRITE_TO_FILE = System.getProperty("compss.to.file") != null && System.getProperty("compss.to.file").equals("true");
    private static final boolean IS_WS_CLASS = System.getProperty("compss.is.ws") != null && System.getProperty("compss.is.ws").equals("true");
    private static final boolean IS_MAIN_CLASS = System.getProperty("compss.is.mainclass") == null || !System.getProperty("compss.is.mainclass").equals("false");

    public Class<?> modify(String appName) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        CLASS_POOL.importPackage("es.bsc.compss");
        CLASS_POOL.importPackage("es.bsc.compss.api");
        CLASS_POOL.importPackage("es.bsc.compss.api.impl");
        CLASS_POOL.importPackage("es.bsc.compss.loader");
        CLASS_POOL.importPackage("es.bsc.compss.loader.total");
        String varName = LoaderUtils.randomName(5, "compss");
        CtClass appClass = CLASS_POOL.get(appName);
        CtClass itApiClass = CLASS_POOL.get(LoaderConstants.CLASS_COMPSSRUNTIME_API);
        String itApiVar = varName + "Api";
        CtField itApiField = new CtField(itApiClass, itApiVar, appClass);
        itApiField.setModifiers(10);
        appClass.addField(itApiField);
        CtClass itSRClass = CLASS_POOL.get(LoaderConstants.CLASS_STREAM_REGISTRY);
        String itSRVar = varName + "SR";
        CtField itSRField = new CtField(itSRClass, itSRVar, appClass);
        itSRField.setModifiers(10);
        appClass.addField(itSRField);
        CtClass itORClass = CLASS_POOL.get(LoaderConstants.CLASS_OBJECT_REGISTRY);
        String itORVar = varName + "OR";
        CtField itORField = new CtField(itORClass, itORVar, appClass);
        itORField.setModifiers(10);
        appClass.addField(itORField);
        CtClass appIdClass = CLASS_POOL.get(LoaderConstants.CLASS_APP_ID);
        String itAppIdVar = varName + "AppId";
        CtField appIdField = new CtField(appIdClass, itAppIdVar, appClass);
        appIdField.setModifiers(10);
        appClass.addField(appIdField);
        this.manageStartAndStop(appClass, itApiVar, itSRVar, itORVar);
        Class<?> annotItf = Class.forName(appName + "Itf");
        Method[] remoteMethods = annotItf.getMethods();
        CtMethod[] instrCandidates = appClass.getDeclaredMethods();
        ITAppEditor itAppEditor = new ITAppEditor(remoteMethods, instrCandidates, itApiVar, itSRVar, itORVar, itAppIdVar, appClass);
        CodeConverter converter = new CodeConverter();
        CtClass arrayWatcher = CLASS_POOL.get(LoaderConstants.CLASS_ARRAY_ACCESS_WATCHER);
        CodeConverter.DefaultArrayAccessReplacementMethodNames names = new CodeConverter.DefaultArrayAccessReplacementMethodNames();
        converter.replaceArrayAccess(arrayWatcher, (CodeConverter.ArrayAccessReplacementMethodNames)names);
        if (DEBUG) {
            LOGGER.debug("Flags: ToFile: " + WRITE_TO_FILE + " isWS: " + IS_WS_CLASS + " isMainClass: " + IS_MAIN_CLASS);
        }
        for (CtMethod ctMethod : instrCandidates) {
            if (LoaderUtils.checkRemote(ctMethod, remoteMethods) != null) continue;
            if (DEBUG) {
                LOGGER.debug("Instrumenting method " + ctMethod.getName());
            }
            StringBuilder toInsertBefore = new StringBuilder();
            StringBuilder toInsertAfter = new StringBuilder();
            ctMethod.addLocalVariable(itAppIdVar, appIdClass);
            toInsertBefore.append(itAppIdVar).append(" = new Long(Thread.currentThread().getId());");
            boolean isMainProgram = LoaderUtils.isMainMethod(ctMethod);
            boolean isOrchestration = LoaderUtils.isOrchestration(ctMethod);
            if (isMainProgram && IS_MAIN_CLASS) {
                LOGGER.debug("Inserting calls at the beginning and at the end of main");
                if (IS_WS_CLASS) {
                    LOGGER.debug("Inserting calls noMoreTasks at the end of main");
                    toInsertAfter.insert(0, itApiVar + ".noMoreTasks(" + itAppIdVar + ");");
                    ctMethod.insertBefore(toInsertBefore.toString());
                    ctMethod.insertAfter(toInsertAfter.toString());
                } else {
                    LOGGER.debug("Inserting calls noMoreTasks and stopIT at the end of main");
                    toInsertBefore.append(appName).append('.').append(itAppIdVar).append(" = new Long(Thread.currentThread().getId());");
                    toInsertAfter.insert(0, itApiVar + ".stopIT(true);");
                    toInsertAfter.insert(0, itApiVar + ".noMoreTasks(" + appName + '.' + itAppIdVar + ");");
                    ctMethod.insertBefore(toInsertBefore.toString());
                    ctMethod.insertAfter(toInsertAfter.toString(), true);
                }
                ctMethod.instrument(converter);
                ctMethod.instrument((ExprEditor)itAppEditor);
                continue;
            }
            if (isOrchestration) {
                if (IS_WS_CLASS) {
                    LOGGER.debug("Inserting calls noMoreTasks and stopIT at the end of orchestration");
                    toInsertAfter.insert(0, itApiVar + ".noMoreTasks(" + itAppIdVar + ");");
                    ctMethod.insertBefore(toInsertBefore.toString());
                    ctMethod.insertAfter(toInsertAfter.toString());
                } else {
                    LOGGER.debug("Inserting only before at the beginning of an orchestration");
                    ctMethod.insertBefore(toInsertBefore.toString());
                }
                ctMethod.instrument(converter);
                ctMethod.instrument((ExprEditor)itAppEditor);
                continue;
            }
            LOGGER.debug("Inserting only before");
            ctMethod.insertBefore(toInsertBefore.toString());
            if (IS_WS_CLASS) {
                if (!Modifier.isPrivate((int)ctMethod.getModifiers())) continue;
                ctMethod.instrument(converter);
                ctMethod.instrument((ExprEditor)itAppEditor);
                continue;
            }
            ctMethod.instrument(converter);
            ctMethod.instrument((ExprEditor)itAppEditor);
        }
        for (CtMethod ctMethod : appClass.getDeclaredConstructors()) {
            if (DEBUG) {
                LOGGER.debug("Instrumenting constructor " + ctMethod.getLongName());
            }
            ctMethod.instrument(converter);
            ctMethod.instrument((ExprEditor)itAppEditor);
        }
        if (WRITE_TO_FILE) {
            try {
                appClass.writeFile();
            }
            catch (Exception e) {
                ErrorManager.fatal((String)"Error writing the instrumented class file");
            }
            return null;
        }
        return appClass.toClass();
    }

    private void manageStartAndStop(CtClass appClass, String itApiVar, String itSRVar, String itORVar) throws CannotCompileException, NotFoundException {
        if (DEBUG) {
            LOGGER.debug("Previous class initializer is " + appClass.getClassInitializer());
        }
        CtConstructor initializer = appClass.makeClassInitializer();
        StringBuilder toInsertBefore = new StringBuilder();
        if (IS_MAIN_CLASS || IS_WS_CLASS) {
            toInsertBefore.append("System.setProperty(" + COMPSS_APP_CONSTANT + ", \"" + appClass.getName() + "\");");
        }
        toInsertBefore.append(itApiVar + " = new " + "COMPSsRuntimeImpl" + "();").append(itApiVar + " = (" + LoaderConstants.CLASS_COMPSSRUNTIME_API + ")" + itApiVar + ";").append(itSRVar + " = new " + LoaderConstants.CLASS_STREAM_REGISTRY + "((" + LoaderConstants.CLASS_LOADERAPI + ") " + itApiVar + " );").append(itORVar + " = new " + LoaderConstants.CLASS_OBJECT_REGISTRY + "((" + LoaderConstants.CLASS_LOADERAPI + ") " + itApiVar + " );").append(itApiVar + ".startIT();");
        initializer.insertBefore(toInsertBefore.toString());
    }
}

