/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader.total;

import es.bsc.compss.loader.LoaderAPI;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Loader");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String EMPTY = "EMPTY";
    private final LoaderAPI itApi;
    private final String serialDir;
    private final Map<Integer, AppEntry> appObjects;
    private final Map<Integer, Object> internalObjects;

    public ObjectRegistry(LoaderAPI api) {
        this.itApi = api;
        this.serialDir = api.getTempDir();
        this.appObjects = new TreeMap<Integer, AppEntry>();
        this.internalObjects = new TreeMap<Integer, Object>();
        this.itApi.setObjectRegistry(this);
    }

    public void newObjectAccess(Long appId, Object o) {
        this.newObjectAccess(appId, o, true);
    }

    public void newObjectAccess(Long appId, Object o, boolean isWriter) {
        Object oUpdated;
        if (o == null) {
            return;
        }
        Integer hashCode = this.getObjectHashCode(appId, o);
        if (hashCode == null) {
            return;
        }
        if (DEBUG) {
            LOGGER.debug("New access to object with hash code " + hashCode + ", for writing: " + isWriter);
        }
        if ((oUpdated = this.itApi.getObject(appId, o, hashCode, this.serialDir)) != null) {
            this.internalObjects.put(hashCode, oUpdated);
        }
    }

    public int newObjectParameter(Long appId, Object obj) {
        if (obj == null) {
            return Integer.MAX_VALUE;
        }
        int finalHashCode = this.assignHashCode(appId, obj);
        if (DEBUG) {
            LOGGER.debug("Object " + obj + " with hash code " + finalHashCode + " registered");
        }
        return finalHashCode;
    }

    private int assignHashCode(Long appId, Object obj) {
        int objHashCode = obj.hashCode();
        AppEntry objEntry = this.appObjects.get(objHashCode);
        while (!(objEntry == null || objEntry.object == EMPTY || objEntry.object == obj && Objects.equals(objEntry.appId, appId))) {
            objEntry = this.appObjects.get(++objHashCode);
        }
        if (objEntry == null || objEntry.object == EMPTY) {
            if (DEBUG) {
                LOGGER.debug("Adding " + obj + " with hash code " + objHashCode + " to object registery");
            }
            AppEntry re = new AppEntry(appId, obj);
            this.appObjects.put(objHashCode, re);
            this.internalObjects.put(objHashCode, obj);
        }
        return objHashCode;
    }

    private Integer getObjectHashCode(Long appId, Object obj) {
        int hashCode = obj.hashCode();
        AppEntry oEntry = this.appObjects.get(hashCode);
        while (oEntry != null) {
            if (oEntry.object == obj && Objects.equals(oEntry.appId, appId)) {
                return hashCode;
            }
            oEntry = this.appObjects.get(++hashCode);
        }
        return null;
    }

    public void serializeLocally(Long appId, Object o) {
        if (o == null) {
            return;
        }
        Integer hashCode = this.getObjectHashCode(appId, o);
        if (hashCode == null) {
            return;
        }
        if (DEBUG) {
            LOGGER.debug("About to serialize locally object with hash code " + hashCode);
        }
        this.itApi.serializeObject(this.internalObjects.get(hashCode), hashCode, this.serialDir);
    }

    public Object getInternalObject(Long appId, Object o) {
        if (o == null) {
            return null;
        }
        Integer hashCode = this.getObjectHashCode(appId, o);
        if (hashCode == null) {
            return null;
        }
        Object internal = this.internalObjects.get(hashCode);
        if (DEBUG) {
            LOGGER.debug("Returning internal object " + internal + " with hash code " + hashCode);
        }
        return internal;
    }

    public boolean delete(Long appId, Object o) {
        if (o == null) {
            return false;
        }
        Integer hashCode = this.getObjectHashCode(appId, o);
        if (hashCode == null) {
            return false;
        }
        if (DEBUG) {
            LOGGER.debug("About to remove object with hash code " + hashCode + " from object registry.");
        }
        this.itApi.removeObject(o, hashCode);
        return this.deleteFromInternal(hashCode) && this.deleteFromApps(hashCode);
    }

    private boolean deleteFromInternal(int hashcode) {
        Object toDelete = this.internalObjects.get(hashcode);
        if (toDelete != null) {
            this.internalObjects.remove(hashcode);
            return true;
        }
        return false;
    }

    private boolean deleteFromApps(int hashcode) {
        AppEntry toDelete = this.appObjects.get(hashcode);
        if (toDelete != null) {
            toDelete.object = EMPTY;
            return true;
        }
        return false;
    }

    private static final class AppEntry {
        Long appId;
        Object object;

        public AppEntry(Long appId, Object object) {
            this.appId = appId;
            this.object = object;
        }
    }
}

