/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader.total;

import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.total.COMPSsFile;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Loader");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final LoaderAPI itApi;
    private final Map<String, StreamList> fileToStreams;
    private final Set<String> taskFiles;
    private final boolean onWindows;

    public StreamRegistry(LoaderAPI api) {
        this.itApi = api;
        this.fileToStreams = new TreeMap<String, StreamList>();
        this.taskFiles = new HashSet<String>();
        this.onWindows = File.separatorChar == '\\';
        this.itApi.setStreamRegistry(this);
    }

    public FileInputStream newFileInputStream(Long appId, File file) throws FileNotFoundException {
        Direction direction = Direction.IN;
        StreamList list = this.obtainList(appId, file, direction);
        FileInputStream fis = new FileInputStream(list.getRenaming());
        list.addStream(fis);
        try {
            list.addFD(fis.getFD());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Loader - Error creating FileInputStream for file " + file + LINE_SEP + e.getMessage());
        }
        return fis;
    }

    public FileInputStream newFileInputStream(Long appId, FileDescriptor fd) {
        StreamList list = this.obtainList(fd);
        FileInputStream fis = new FileInputStream(fd);
        if (list != null) {
            list.addStream(fis);
        }
        return fis;
    }

    public FileInputStream newFileInputStream(Long appId, String fileName) throws FileNotFoundException {
        return this.newFileInputStream(appId, new File(fileName));
    }

    public FileOutputStream newFileOutputStream(Long appId, File file, boolean append) throws FileNotFoundException {
        Direction direction = append ? Direction.INOUT : Direction.OUT;
        StreamList list = this.obtainList(appId, file, direction);
        FileOutputStream fos = new FileOutputStream(list.getRenaming(), append);
        list.addStream(fos);
        try {
            list.addFD(fos.getFD());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Loader - Error creating FileOutputStream for file " + file + LINE_SEP + e.getMessage());
        }
        return fos;
    }

    public FileOutputStream newFileOutputStream(Long appId, FileDescriptor fd) {
        StreamList list = this.obtainList(fd);
        FileOutputStream fos = new FileOutputStream(fd);
        if (list != null) {
            list.addStream(fos);
        }
        return fos;
    }

    public FileOutputStream newFileOutputStream(Long appId, File file) throws FileNotFoundException {
        return this.newFileOutputStream(appId, file, false);
    }

    public FileOutputStream newFileOutputStream(Long appId, String fileName, boolean append) throws FileNotFoundException {
        return this.newFileOutputStream(appId, new File(fileName), append);
    }

    public FileOutputStream newFileOutputStream(Long appId, String fileName) throws FileNotFoundException {
        return this.newFileOutputStream(appId, new File(fileName), false);
    }

    public void newFilterStream(Long appId, Object stream, Object filter) {
        this.replaceStream(stream, filter);
    }

    public RandomAccessFile newRandomAccessFile(Long appId, File file, String mode) throws FileNotFoundException {
        Direction direction = mode.length() == 1 ? Direction.IN : Direction.INOUT;
        StreamList list = this.obtainList(appId, file, direction);
        RandomAccessFile raf = new RandomAccessFile(list.getRenaming(), mode);
        list.addStream(raf);
        try {
            list.addFD(raf.getFD());
        }
        catch (IOException e) {
            throw new FileNotFoundException("Loader - Error creating RandomAccessFile for file " + file + LINE_SEP + e.getMessage());
        }
        return raf;
    }

    public RandomAccessFile newRandomAccessFile(Long appId, String fileName, String mode) throws FileNotFoundException {
        return this.newRandomAccessFile(appId, new File(fileName), mode);
    }

    public FileReader newFileReader(Long appId, File file) throws FileNotFoundException {
        Direction direction = Direction.IN;
        StreamList list = this.obtainList(appId, file, direction);
        FileReader fr = new FileReader(list.getRenaming());
        list.addStream(fr);
        return fr;
    }

    public FileReader newFileReader(Long appId, String fileName) throws FileNotFoundException {
        return this.newFileReader(appId, new File(fileName));
    }

    public FileReader newFileReader(Long appId, FileDescriptor fd) {
        StreamList list = this.obtainList(fd);
        FileReader fr = new FileReader(fd);
        if (list != null) {
            list.addStream(fr);
        }
        return fr;
    }

    public InputStreamReader newInputStreamReader(Long appId, InputStream is) {
        InputStreamReader isr = new InputStreamReader(is);
        this.replaceStream(is, isr);
        return isr;
    }

    public InputStreamReader newInputStreamReader(Long appId, InputStream is, Charset cs) {
        InputStreamReader isr = new InputStreamReader(is, cs);
        this.replaceStream(is, isr);
        return isr;
    }

    public InputStreamReader newInputStreamReader(Long appId, InputStream is, CharsetDecoder dec) {
        InputStreamReader isr = new InputStreamReader(is, dec);
        this.replaceStream(is, isr);
        return isr;
    }

    public InputStreamReader newInputStreamReader(Long appId, InputStream is, String charsetName) throws UnsupportedEncodingException {
        InputStreamReader isr = new InputStreamReader(is, charsetName);
        this.replaceStream(is, isr);
        return isr;
    }

    public BufferedReader newBufferedReader(Long appId, Reader r) {
        BufferedReader br = new BufferedReader(r);
        this.replaceStream(r, br);
        return br;
    }

    public BufferedReader newBufferedReader(Long appId, Reader r, int size) {
        BufferedReader br = new BufferedReader(r, size);
        this.replaceStream(r, br);
        return br;
    }

    public FileWriter newFileWriter(Long appId, File file, boolean append) throws IOException {
        Direction direction = append ? Direction.INOUT : Direction.OUT;
        StreamList list = this.obtainList(appId, file, direction);
        FileWriter fw = new FileWriter(list.getRenaming(), append);
        list.addStream(fw);
        return fw;
    }

    public FileWriter newFileWriter(Long appId, File file) throws IOException {
        return this.newFileWriter(appId, file, false);
    }

    public FileWriter newFileWriter(Long appId, String fileName, boolean append) throws IOException {
        return this.newFileWriter(appId, new File(fileName), append);
    }

    public FileWriter newFileWriter(Long appId, String fileName) throws IOException {
        return this.newFileWriter(appId, new File(fileName), false);
    }

    public FileWriter newFileWriter(Long appId, FileDescriptor fd) {
        StreamList list = this.obtainList(fd);
        FileWriter fw = new FileWriter(fd);
        if (list != null) {
            list.addStream(fw);
        }
        return fw;
    }

    public OutputStreamWriter newOutputStreamWriter(Long appId, OutputStream os) {
        OutputStreamWriter osw = new OutputStreamWriter(os);
        this.replaceStream(os, osw);
        return osw;
    }

    public OutputStreamWriter newOutputStreamWriter(Long appId, OutputStream os, Charset cs) {
        OutputStreamWriter osw = new OutputStreamWriter(os, cs);
        this.replaceStream(os, osw);
        return osw;
    }

    public OutputStreamWriter newOutputStreamWriter(Long appId, OutputStream os, CharsetEncoder dec) {
        OutputStreamWriter osw = new OutputStreamWriter(os, dec);
        this.replaceStream(os, osw);
        return osw;
    }

    public OutputStreamWriter newOutputStreamWriter(Long appId, OutputStream os, String charsetName) throws UnsupportedEncodingException {
        OutputStreamWriter osw = new OutputStreamWriter(os, charsetName);
        this.replaceStream(os, osw);
        return osw;
    }

    public BufferedWriter newBufferedWriter(Long appId, Writer w) {
        BufferedWriter bw = new BufferedWriter(w);
        this.replaceStream(w, bw);
        return bw;
    }

    public BufferedWriter newBufferedWriter(Long appId, Writer w, int size) {
        BufferedWriter bw = new BufferedWriter(w, size);
        this.replaceStream(w, bw);
        return bw;
    }

    public PrintStream newPrintStream(Long appId, File file) throws FileNotFoundException {
        Direction direction = Direction.OUT;
        StreamList list = this.obtainList(appId, file, direction);
        PrintStream ps = new PrintStream(list.getRenaming());
        list.addStream(ps);
        return ps;
    }

    public PrintStream newPrintStream(Long appId, File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        Direction direction = Direction.OUT;
        StreamList list = this.obtainList(appId, file, direction);
        PrintStream ps = new PrintStream(list.getRenaming(), csn);
        list.addStream(ps);
        return ps;
    }

    public PrintStream newPrintStream(Long appId, String fileName) throws FileNotFoundException {
        return this.newPrintStream(appId, new File(fileName));
    }

    public PrintStream newPrintStream(Long appId, String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        return this.newPrintStream(appId, new File(fileName), csn);
    }

    public PrintStream newPrintStream(Long appId, OutputStream os) {
        PrintStream ps = new PrintStream(os);
        this.replaceStream(os, ps);
        return ps;
    }

    public PrintStream newPrintStream(Long appId, OutputStream os, boolean autoFlush) {
        PrintStream ps = new PrintStream(os, autoFlush);
        this.replaceStream(os, ps);
        return ps;
    }

    public PrintStream newPrintStream(Long appId, OutputStream os, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        PrintStream ps = new PrintStream(os, autoFlush, encoding);
        this.replaceStream(os, ps);
        return ps;
    }

    public PrintWriter newPrintWriter(Long appId, File file) throws FileNotFoundException {
        Direction direction = Direction.OUT;
        StreamList list = this.obtainList(appId, file, direction);
        PrintWriter pw = new PrintWriter(list.getRenaming());
        list.addStream(pw);
        return pw;
    }

    public PrintWriter newPrintWriter(Long appId, File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        Direction direction = Direction.OUT;
        StreamList list = this.obtainList(appId, file, direction);
        PrintWriter pw = new PrintWriter(list.getRenaming(), csn);
        list.addStream(pw);
        return pw;
    }

    public PrintWriter newPrintWriter(Long appId, String fileName) throws FileNotFoundException {
        return this.newPrintWriter(appId, new File(fileName));
    }

    public PrintWriter newPrintWriter(Long appId, String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        return this.newPrintWriter(appId, new File(fileName), csn);
    }

    public PrintWriter newPrintWriter(Long appId, OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        this.replaceStream(os, pw);
        return pw;
    }

    public PrintWriter newPrintWriter(Long appId, OutputStream os, boolean autoFlush) {
        PrintWriter pw = new PrintWriter(os, autoFlush);
        this.replaceStream(os, pw);
        return pw;
    }

    public PrintWriter newPrintWriter(Long appId, Writer w) {
        PrintWriter pw = new PrintWriter(w);
        this.replaceStream(w, pw);
        return pw;
    }

    public PrintWriter newPrintWriter(Long appId, Writer w, boolean autoFlush) {
        PrintWriter pw = new PrintWriter(w, autoFlush);
        this.replaceStream(w, pw);
        return pw;
    }

    public File newCOMPSsFile(Long appId, String filename) {
        File f = new File(filename);
        return this.checkAndGetNewFile(appId, f);
    }

    public File newCOMPSsFile(Long appId, String parent, String child) {
        File f = new File(parent, child);
        return this.checkAndGetNewFile(appId, f);
    }

    public File newCOMPSsFile(Long appId, File parent, String child) {
        File f = new File(parent, child);
        return this.checkAndGetNewFile(appId, f);
    }

    public File newCOMPSsFile(Long appId, URI uri) {
        File f = new File(uri);
        return this.checkAndGetNewFile(appId, f);
    }

    private File checkAndGetNewFile(Long appId, File f) {
        if (this.taskFiles.contains(f.getAbsolutePath())) {
            return new COMPSsFile(this.itApi, appId, f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamList obtainList(Long appId, File file, Direction direction) {
        StreamList list;
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            ErrorManager.fatal((String)("Cannot create stream for file " + file.getAbsolutePath() + " with direction " + direction), (Exception)e);
            return null;
        }
        if (this.onWindows) {
            path = path.toLowerCase();
        }
        if ((list = this.fileToStreams.get(path)) == null) {
            if (DEBUG) {
                LOGGER.debug("First stream on the list for file " + path + " with direction " + direction);
            }
            String renaming = null;
            switch (direction) {
                case IN: 
                case CONCURRENT: {
                    renaming = this.itApi.openFile(appId, path, Direction.IN);
                    break;
                }
                case OUT: {
                    renaming = this.itApi.openFile(appId, path, Direction.OUT);
                    break;
                }
                case COMMUTATIVE: 
                case INOUT: {
                    renaming = this.itApi.openFile(appId, path, Direction.INOUT);
                }
            }
            list = new StreamList(renaming, direction);
            Map<String, StreamList> map = this.fileToStreams;
            synchronized (map) {
                this.fileToStreams.put(path, list);
            }
        } else if (direction != Direction.IN || list.written) {
            ErrorManager.error((String)("ERROR: File " + path + " is going to be accessed more than once and one of these accesses is for writting. " + "This can produce and inconsistency"));
        }
        if (direction != Direction.IN) {
            list.setWritten(true);
        }
        if (direction == Direction.INOUT) {
            list.setAppend(true);
        }
        if (DEBUG) {
            LOGGER.debug("New stream for file " + path + " with renaming " + list.getRenaming() + " and direction " + direction);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamList obtainList(FileDescriptor fd) {
        Map<String, StreamList> map = this.fileToStreams;
        synchronized (map) {
            for (StreamList list : this.fileToStreams.values()) {
                if (!list.containsFD(fd)) continue;
                if (DEBUG) {
                    LOGGER.debug("Found list for file descriptor " + fd + ": file " + list.getRenaming());
                }
                return list;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceStream(Object oldStream, Object newStream) {
        Map<String, StreamList> map = this.fileToStreams;
        synchronized (map) {
            for (Map.Entry<String, StreamList> e : this.fileToStreams.entrySet()) {
                StreamList list = e.getValue();
                ListIterator<Object> listIt = list.getIterator();
                while (listIt.hasNext()) {
                    Object listStream = listIt.next();
                    if (!listStream.equals(oldStream)) continue;
                    listIt.set(newStream);
                    if (!DEBUG) continue;
                    LOGGER.debug("Replaced stream of " + oldStream.getClass() + " by another of " + newStream.getClass());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamClosed(Long appId, Object stream) {
        String filePath = null;
        StreamList list = null;
        boolean found = false;
        Map<String, StreamList> map = this.fileToStreams;
        synchronized (map) {
            Iterator<Map.Entry<String, StreamList>> entryIt = this.fileToStreams.entrySet().iterator();
            block6: while (!found && entryIt.hasNext()) {
                Map.Entry<String, StreamList> e = entryIt.next();
                filePath = e.getKey();
                list = e.getValue();
                ListIterator<Object> listIt = list.getIterator();
                while (listIt.hasNext()) {
                    Object listStream = listIt.next();
                    if (!listStream.equals(stream)) continue;
                    listIt.remove();
                    found = true;
                    continue block6;
                }
            }
        }
        if (found) {
            if (DEBUG) {
                LOGGER.debug("Found closed stream of " + stream.getClass());
            }
            if (DEBUG) {
                LOGGER.debug("Empty stream list");
            }
            if (list.isFirstStreamInput() && list.getWritten() && list.getAppend()) {
                this.itApi.closeFile(appId, filePath, Direction.INOUT);
            } else if (list.isFirstStreamInput() && list.getWritten() && !list.getAppend()) {
                this.itApi.closeFile(appId, filePath, Direction.OUT);
            } else if (list.isFirstStreamInput() && !list.getWritten()) {
                this.itApi.closeFile(appId, filePath, Direction.IN);
            }
            if (list.isEmpty()) {
                map = this.fileToStreams;
                synchronized (map) {
                    this.fileToStreams.remove(filePath);
                }
            }
        }
    }

    public boolean isTaskFile(Long appId, String fileName) {
        if (fileName != null) {
            File f = new File(fileName);
            return this.taskFiles.contains(f.getAbsolutePath());
        }
        return false;
    }

    public void addTaskFile(Long appId, String fileName) {
        if (DEBUG) {
            LOGGER.debug("Adding File to the Stream Registry");
        }
        File f = new File(fileName);
        this.taskFiles.add(f.getAbsolutePath());
    }

    public void deleteTaskFile(Long appId, String fileName) {
        if (DEBUG) {
            LOGGER.debug("Adding File to the Stream Registry");
        }
        File f = new File(fileName);
        this.taskFiles.remove(f.getAbsolutePath());
    }

    private class StreamList {
        private String fileRenaming;
        private boolean firstIsInputStream;
        private boolean written;
        private boolean append;
        private List<Object> list;
        private List<FileDescriptor> fds;

        public StreamList(String renaming, Direction direction) {
            this.fileRenaming = renaming;
            this.firstIsInputStream = direction == Direction.IN;
            this.written = false;
            this.append = false;
            this.list = new LinkedList<Object>();
            this.fds = new LinkedList<FileDescriptor>();
        }

        public void addStream(Object stream) {
            this.list.add(stream);
        }

        public void addFD(FileDescriptor fd) {
            this.fds.add(fd);
        }

        public String getRenaming() {
            return this.fileRenaming;
        }

        public boolean isFirstStreamInput() {
            return this.firstIsInputStream;
        }

        public boolean getWritten() {
            return this.written;
        }

        public boolean getAppend() {
            return this.append;
        }

        public ListIterator<Object> getIterator() {
            return (ListIterator)this.list.iterator();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean containsFD(FileDescriptor fd) {
            return this.fds.contains(fd);
        }

        public void setWritten(boolean b) {
            this.written = b;
        }

        public void setAppend(boolean b) {
            this.append = b;
        }
    }
}

