/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader.total;

import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.loader.LoaderUtils;
import es.bsc.compss.loader.total.ITAppEditor;
import es.bsc.compss.util.ErrorManager;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ITAppModifier {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Loader");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String COMPSS_APP_CONSTANT = LoaderConstants.CLASS_COMPSS_CONSTANTS + ".APP_NAME";
    private static final boolean IS_WS_CLASS = System.getProperty("compss.is.ws") != null && System.getProperty("compss.is.ws").equals("true");
    private static final long WALL_CLOCK_LIMIT = Long.parseLong(System.getProperty("compss.wcl", "0"));

    private ITAppModifier() {
    }

    private static CtClass modify(String appName, String originalClassName, Class<?> annotItf, boolean threadIdAsAppId, boolean useNewAppClassName, boolean isMainClass) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        ClassPool classPool = ITAppModifier.getClassPool();
        CtClass appClass = classPool.get(appName);
        appClass.defrost();
        String varName = LoaderUtils.randomName(5, "compss");
        if (useNewAppClassName) {
            appClass.setName(appName + "_" + varName);
        }
        String itApiVar = varName + "Api";
        String itSRVar = varName + "SR";
        String itORVar = varName + "OR";
        String itAppIdVar = varName + "AppId";
        String instrumentationAppId = threadIdAsAppId ? "new Long(Thread.currentThread().getId())" : itAppIdVar;
        ITAppModifier.addVariables(classPool, appClass, itApiVar, itSRVar, itORVar, itAppIdVar);
        ITAppModifier.instrumentClass(classPool, appClass, annotItf, itApiVar, itSRVar, itORVar, instrumentationAppId, originalClassName, isMainClass);
        ITAppModifier.addModifyVariablesMethods(appClass, itApiVar, itSRVar, itORVar, itAppIdVar, instrumentationAppId, isMainClass);
        return appClass;
    }

    public static Class<?> modifyToMemory(String appName, String originalClassName, Class<?> annotItf, boolean threadIdAsAppId, boolean useNewAppClassName, boolean returnOrigClass, boolean isMainClass) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        CtClass appClass = ITAppModifier.modify(appName, originalClassName, annotItf, threadIdAsAppId, useNewAppClassName, isMainClass);
        if (returnOrigClass) {
            Class<?> origClass = Class.forName(appName);
            Class methodClass = appClass.toClass(origClass);
            appClass.defrost();
            return methodClass;
        }
        return appClass.toClass(annotItf);
    }

    public static void modifyToFile(String appName, String originalClassName, Class<?> annotItf, boolean threadIdAsAppId, boolean useNewAppClassName, boolean isMainClass) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        CtClass appClass = ITAppModifier.modify(appName, originalClassName, annotItf, threadIdAsAppId, useNewAppClassName, isMainClass);
        try {
            appClass.writeFile();
        }
        catch (Exception e) {
            ErrorManager.fatal((String)"Error writing the instrumented class file");
        }
    }

    private static ClassPool getClassPool() {
        ClassPool cp = new ClassPool();
        cp.appendSystemPath();
        cp.importPackage("es.bsc.compss");
        cp.importPackage("es.bsc.compss.api");
        cp.importPackage("es.bsc.compss.api.impl");
        cp.importPackage("es.bsc.compss.loader");
        cp.importPackage("es.bsc.compss.loader.total");
        return cp;
    }

    private static void addVariables(ClassPool cp, CtClass appClass, String itApiVar, String itSRVar, String itORVar, String itAppIdVar) throws NotFoundException, CannotCompileException {
        CtClass itApiClass = cp.get(LoaderConstants.CLASS_COMPSSRUNTIME_API);
        CtField itApiField = new CtField(itApiClass, itApiVar, appClass);
        itApiField.setModifiers(10);
        appClass.addField(itApiField);
        CtClass itSRClass = cp.get(LoaderConstants.CLASS_STREAM_REGISTRY);
        CtField itSRField = new CtField(itSRClass, itSRVar, appClass);
        itSRField.setModifiers(10);
        appClass.addField(itSRField);
        CtClass itORClass = cp.get(LoaderConstants.CLASS_OBJECT_REGISTRY);
        CtField itORField = new CtField(itORClass, itORVar, appClass);
        itORField.setModifiers(10);
        appClass.addField(itORField);
        CtClass appIdClass = cp.get(LoaderConstants.CLASS_APP_ID);
        CtField appIdField = new CtField(appIdClass, itAppIdVar, appClass);
        appIdField.setModifiers(10);
        appClass.addField(appIdField);
    }

    private static void instrumentClass(ClassPool cp, CtClass appClass, Class<?> annotItf, String itApiVar, String itSRVar, String itORVar, String itAppIdVar, String originalClassName, boolean isMainClass) throws NotFoundException, CannotCompileException {
        Method[] remoteMethods = annotItf.getMethods();
        CtMethod[] instrCandidates = appClass.getDeclaredMethods();
        ITAppEditor itAppEditor = new ITAppEditor(remoteMethods, instrCandidates, itApiVar, itSRVar, itORVar, itAppIdVar, appClass, originalClassName);
        CodeConverter converter = new CodeConverter();
        CtClass arrayWatcher = cp.get(LoaderConstants.CLASS_ARRAY_ACCESS_WATCHER);
        CodeConverter.DefaultArrayAccessReplacementMethodNames names = new CodeConverter.DefaultArrayAccessReplacementMethodNames();
        converter.replaceArrayAccess(arrayWatcher, (CodeConverter.ArrayAccessReplacementMethodNames)names);
        if (DEBUG) {
            LOGGER.debug("Flags: isWS: " + IS_WS_CLASS + " isMainClass: " + isMainClass);
        }
        for (CtMethod ctMethod : instrCandidates) {
            if (LoaderUtils.checkRemote(ctMethod, remoteMethods, null, null) != null) continue;
            if (DEBUG) {
                LOGGER.debug("Instrumenting method " + ctMethod.getName());
            }
            StringBuilder toInsertAfter = new StringBuilder();
            boolean isMainProgram = LoaderUtils.isMainMethod(ctMethod);
            boolean isOrchestration = LoaderUtils.isOrchestration(ctMethod);
            if (isMainProgram && isMainClass || isOrchestration && IS_WS_CLASS) {
                LOGGER.debug("Inserting calls at the beginning and at the end of main");
                if (!IS_WS_CLASS) {
                    LOGGER.debug("Inserting call stopIT at the end of main");
                    toInsertAfter.insert(0, itApiVar + ".stopIT(true);");
                }
                LOGGER.debug("Inserting call noMoreTasks at the end of main");
                toInsertAfter.insert(0, itApiVar + ".noMoreTasks(" + itAppIdVar + ");");
                if (IS_WS_CLASS) {
                    ctMethod.insertAfter(toInsertAfter.toString());
                } else {
                    ctMethod.insertAfter(toInsertAfter.toString(), true);
                }
            } else if (IS_WS_CLASS && !Modifier.isPrivate((int)ctMethod.getModifiers())) continue;
            ctMethod.instrument(converter);
            ctMethod.instrument((ExprEditor)itAppEditor);
        }
        for (CtMethod ctMethod : appClass.getDeclaredConstructors()) {
            if (DEBUG) {
                LOGGER.debug("Instrumenting constructor " + ctMethod.getLongName());
            }
            ctMethod.instrument(converter);
            ctMethod.instrument((ExprEditor)itAppEditor);
        }
    }

    private static void addModifyVariablesMethods(CtClass appClass, String itApiVar, String itSRVar, String itORVar, String itAppIdVar, String instrumentationAppId, boolean isMainClass) throws CannotCompileException {
        StringBuilder methodBody = new StringBuilder();
        methodBody.append("public static void printCOMPSsVariables() { ");
        methodBody.append("System.out.println(\"Api Var: \" + ").append(itApiVar).append(");");
        methodBody.append("System.out.println(\"SR Var: \" + ").append(itSRVar).append(");");
        methodBody.append("System.out.println(\"OR Var: \" + ").append(itORVar).append(");");
        methodBody.append("System.out.println(\"App Id: \" + ").append(itAppIdVar).append(");");
        methodBody.append("}");
        CtMethod m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = new StringBuilder();
        methodBody.append("public static void setCOMPSsVariables( ").append(LoaderConstants.CLASS_COMPSSRUNTIME_API).append(" runtime, ").append(LoaderConstants.CLASS_LOADERAPI).append(" loader, ").append(LoaderConstants.CLASS_APP_ID).append(" appId) {");
        methodBody.append(itApiVar).append("= runtime;");
        methodBody.append(itSRVar).append("= loader.getStreamRegistry();");
        methodBody.append(itORVar).append("= loader.getObjectRegistry();");
        methodBody.append(itAppIdVar).append("= appId;");
        methodBody.append("}");
        m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = new StringBuilder();
        methodBody.append("public static void setCOMPSsVariables( ").append(LoaderConstants.CLASS_COMPSSRUNTIME_API).append(" runtime, ").append(LoaderConstants.CLASS_STREAM_REGISTRY).append(" streamRegistry, ").append(LoaderConstants.CLASS_OBJECT_REGISTRY).append(" objectRegistry, ").append(LoaderConstants.CLASS_APP_ID).append(" appId) {");
        methodBody.append(itApiVar).append("= runtime;");
        methodBody.append(itSRVar).append("= streamRegistry;");
        methodBody.append(itORVar).append("= objectRegistry;");
        methodBody.append(itAppIdVar).append("= appId;");
        methodBody.append("}");
        m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = new StringBuilder();
        methodBody.append("public static void initCOMPSsVariables() {");
        if (isMainClass || IS_WS_CLASS) {
            methodBody.append("System.setProperty(").append(COMPSS_APP_CONSTANT).append(", \"").append(appClass.getName()).append("\");");
        }
        methodBody.append(itApiVar).append(" = new ").append("COMPSsRuntimeImpl").append("();");
        methodBody.append(itApiVar).append(" = (").append(LoaderConstants.CLASS_COMPSSRUNTIME_API).append(")").append(itApiVar).append(";");
        methodBody.append(itSRVar).append(" = new ").append(LoaderConstants.CLASS_STREAM_REGISTRY).append("((").append(LoaderConstants.CLASS_LOADERAPI).append(") ").append(itApiVar).append(" );");
        methodBody.append(itORVar).append(" = new ").append(LoaderConstants.CLASS_OBJECT_REGISTRY).append("((").append(LoaderConstants.CLASS_LOADERAPI).append(") ").append(itApiVar).append(" );");
        methodBody.append(itApiVar).append(".startIT();");
        if (WALL_CLOCK_LIMIT > 0L) {
            methodBody.append(itApiVar).append(".setWallClockLimit(").append(instrumentationAppId).append(",").append(WALL_CLOCK_LIMIT).append("L, true);");
        }
        methodBody.append("}");
        m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = new StringBuilder();
        methodBody.append("public static ").append(LoaderConstants.CLASS_COMPSSRUNTIME_API).append(" getRuntime() {");
        methodBody.append("return ").append(itApiVar).append(";");
        methodBody.append("}");
        m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = new StringBuilder();
        methodBody.append("public static ").append(LoaderConstants.CLASS_STREAM_REGISTRY).append(" getStreamRegistry() {");
        methodBody.append("return ").append(itSRVar).append(";");
        methodBody.append("}");
        m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = new StringBuilder();
        methodBody.append("public static ").append(LoaderConstants.CLASS_OBJECT_REGISTRY).append(" getObjectRegistry() {");
        methodBody.append("return ").append(itORVar).append(";");
        methodBody.append("}");
        m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
        methodBody = new StringBuilder();
        methodBody.append("public static ").append(LoaderConstants.CLASS_APP_ID).append(" getAppId() {");
        methodBody.append("return ").append(itAppIdVar).append(";");
        methodBody.append("}");
        m = CtNewMethod.make((String)methodBody.toString(), (CtClass)appClass);
        appClass.addMethod(m);
    }
}

