/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.Core;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zul.ListModelList;

public class CoresViewModel {
    private List<Core> cores;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM.TasksVM");

    @Init
    public void init() {
        this.cores = new LinkedList();
    }

    public List<Core> getCores() {
        return new ListModelList((Collection)this.cores);
    }

    @Command
    @NotifyChange(value={"cores"})
    public void update(List<String[]> newCoreData) {
        logger.debug("Updating Tasks ViewModel...");
        this.cores.clear();
        for (String[] dc : newCoreData) {
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("   - CoreElement: ");
                for (String elem : dc) {
                    sb.append(elem).append(" ");
                }
                logger.debug(sb.toString());
            }
            int taskId = Integer.parseInt(dc[0]) + 1;
            int colorId = taskId % 24;
            String color = File.separator + "images" + File.separator + "colors" + File.separator + colorId + ".png";
            Core c = new Core(color, dc);
            this.cores.add(c);
        }
        logger.debug("Tasks ViewModel updated");
    }

    @Command
    @NotifyChange(value={"cores"})
    public void clear() {
        this.cores.clear();
    }
}

