/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.Application;
import es.bsc.compss.ui.Constants;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zul.Filedownload;

public class CurrentGraphViewModel {
    private String graph;
    private String graphLastUpdateTime;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM.GraphVM");

    @Init
    public void init() {
        this.graph = new String();
        this.graphLastUpdateTime = new String();
    }

    public String getGraph() {
        return this.graph;
    }

    @Command
    public void download() {
        try {
            if (this.graph.equals(Constants.GRAPH_NOT_FOUND_PATH) || this.graph.equals(Constants.GRAPH_EXECUTION_DONE_PATH) || this.graph.equals(Constants.UNSELECTED_GRAPH_PATH) || this.graph.equals(Constants.EMPTY_GRAPH_PATH)) {
                Filedownload.save((String)this.graph, null);
            } else {
                Filedownload.save((String)this.graph.substring(0, this.graph.lastIndexOf("?")), null);
            }
        }
        catch (Exception e) {
            logger.error("Cannot download current graph");
        }
    }

    @Command
    @NotifyChange(value={"graph"})
    void update(Application monitoredApp) {
        logger.debug("Updating Graph...");
        String monitorLocation = monitoredApp.getPath() + Constants.MONITOR_CURRENT_DOT_FILE;
        File monitorFile = new File(monitorLocation);
        if (monitorFile.exists()) {
            if (monitorFile.length() > 45L) {
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                String modifiedTime = sdf.format(monitorFile.lastModified());
                if (!modifiedTime.equals(this.graphLastUpdateTime)) {
                    try {
                        String graphSVG = File.separator + "svg" + File.separator + monitoredApp.getName() + "_" + "graph.svg";
                        this.graph = this.loadGraph(monitorLocation, graphSVG);
                        this.graphLastUpdateTime = modifiedTime;
                    }
                    catch (Exception e) {
                        this.graph = Constants.GRAPH_NOT_FOUND_PATH;
                        this.graphLastUpdateTime = "";
                        logger.error("Graph generation error");
                    }
                } else {
                    logger.debug("Graph is already loaded");
                }
            } else {
                this.graph = Constants.GRAPH_EXECUTION_DONE_PATH;
                this.graphLastUpdateTime = "";
            }
        } else {
            this.graph = Constants.GRAPH_NOT_FOUND_PATH;
            this.graphLastUpdateTime = "";
            logger.debug("Graph file not found");
        }
    }

    @Command
    @NotifyChange(value={"graph"})
    public void clear() {
        this.graph = Constants.UNSELECTED_GRAPH_PATH;
        this.graphLastUpdateTime = "";
    }

    private String loadGraph(String location, String target) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading Graph...");
            logger.debug("   - Monitoring source: " + location);
            logger.debug("   - Monitoring target: " + target);
        }
        String[] createSVG = new String[]{"/bin/sh", "-c", "dot -T svg " + location + " > " + System.getProperty("catalina.base") + File.separator + "webapps" + File.separator + "compss-monitor" + File.separator + target};
        Process p1 = Runtime.getRuntime().exec(createSVG);
        try {
            p1.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        logger.debug("Graph loaded");
        return target + "?t=" + System.currentTimeMillis();
    }
}

