/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.ExecutionInformationTask;
import java.util.Collection;
import java.util.List;
import monitoringParsers.RuntimeLogParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zul.ListModelList;

public class ExecutionInformationViewModel {
    private String displayType;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM.ExecutionInformationVM");

    @Init
    public void init() {
        this.displayType = new String("tasks_with_failed_jobs");
    }

    public List<ExecutionInformationTask> getTasks() {
        if (this.displayType.equals("all")) {
            if (RuntimeLogParser.getTasks().size() > 1) {
                return new ListModelList(RuntimeLogParser.getTasks().subList(1, RuntimeLogParser.getTasks().size()));
            }
            return new ListModelList();
        }
        if (this.displayType.equals("current_tasks")) {
            return new ListModelList((Collection)RuntimeLogParser.getTasksCurrent());
        }
        if (this.displayType.equals("failed_tasks")) {
            return new ListModelList((Collection)RuntimeLogParser.getTasksFailed());
        }
        if (this.displayType.equals("tasks_with_failed_jobs")) {
            return new ListModelList((Collection)RuntimeLogParser.getTasksWithFailedJobs());
        }
        return new ListModelList();
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    @Command
    @NotifyChange(value={"tasks"})
    public void update() {
        logger.debug("Updating Execution Information ViewModel...");
        RuntimeLogParser.parse();
        logger.debug("Execution Information ViewModel updated");
    }

    @Command
    @NotifyChange(value={"tasks"})
    public void clear() {
    }
}

