/*
 * Decompiled with CFR 0.152.
 */
package monitoringParsers;

import es.bsc.compss.ui.ExecutionInformationTask;
import es.bsc.compss.ui.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class RuntimeLogParser {
    private static Vector<ExecutionInformationTask> tasks = new Vector();
    private static Vector<ExecutionInformationTask> tasksCurrent = new Vector();
    private static Vector<ExecutionInformationTask> tasksFailed = new Vector();
    private static Vector<ExecutionInformationTask> tasksWithFailedJobs = new Vector();
    private static Vector<Integer> jobsToTasks = new Vector();
    private static Vector<String> resubmitedJobs = new Vector();
    private static String runtimeLogPath = "";
    private static int lastParsedLine = -1;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.Parsers.RuntimeLog");

    public static Vector<ExecutionInformationTask> getTasks() {
        return tasks;
    }

    public static Vector<ExecutionInformationTask> getTasksCurrent() {
        return tasksCurrent;
    }

    public static Vector<ExecutionInformationTask> getTasksFailed() {
        return tasksFailed;
    }

    public static Vector<ExecutionInformationTask> getTasksWithFailedJobs() {
        return tasksWithFailedJobs;
    }

    public static void parse() {
        logger.debug("Parsing runtime.log file...");
        if (!Properties.getBasePath().equals("")) {
            String newPath = Properties.getBasePath() + File.separator + "runtime.log";
            if (!runtimeLogPath.equals(newPath)) {
                RuntimeLogParser.clear();
                runtimeLogPath = newPath;
            }
            try (FileReader fr = new FileReader(runtimeLogPath);
                 BufferedReader br = new BufferedReader(fr);){
                String line = br.readLine();
                int i = 0;
                String lastNewJobId = new String("");
                while (line != null) {
                    if (i > lastParsedLine) {
                        String jobId;
                        String taskId;
                        String[] info;
                        String taskId2;
                        String[] str;
                        if (line.contains("@processTask") && (line.contains("New method task") || line.contains("New service task"))) {
                            logger.debug("* New task");
                            str = line.split(" ");
                            taskId2 = str[str.length - 1];
                            String taskName = line.substring(line.lastIndexOf("task(") + 5, line.lastIndexOf(")"));
                            if (Integer.valueOf(taskId2) >= tasks.size()) {
                                tasks.setSize(Integer.valueOf(taskId2) + 1);
                            }
                            tasks.set(Integer.valueOf(taskId2), new ExecutionInformationTask(taskName, taskId2));
                            if (!tasksCurrent.contains(tasks.get(Integer.valueOf(taskId2)))) {
                                tasksCurrent.add(tasks.get(Integer.valueOf(taskId2)));
                            }
                        } else if (line.contains("@doError") && line.contains("rescheduling task execution")) {
                            logger.debug(" * Rescheduled task");
                            info = line.split(" ");
                            taskId2 = info[info.length - 12];
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId2))).setTaskStatus("Creating");
                        } else if (line.contains("@endTask") && line.contains(" with end status ")) {
                            logger.debug("* Task End");
                            taskId = line.substring(line.lastIndexOf("task ") + 5, line.lastIndexOf(" with end status"));
                            String state = line.substring(line.lastIndexOf(" with end status ") + 17);
                            if (state.equals("FINISHED")) {
                                ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId))).setTaskStatus("Done");
                            } else {
                                ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId))).setTaskStatus("Failed");
                                if (!tasksFailed.contains(tasks.get(Integer.valueOf(taskId)))) {
                                    tasksFailed.add(tasks.get(Integer.valueOf(taskId)));
                                }
                            }
                            tasksCurrent.remove(tasks.get(Integer.valueOf(taskId)));
                        } else if (line.contains("@errorOnAction") && line.contains("Blocked Action")) {
                            logger.debug("* Blocked Action");
                            taskId = line.substring(line.lastIndexOf("Task ") + 5, line.lastIndexOf(", CE name"));
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId))).setTaskStatus("Failed");
                            if (!tasksFailed.contains(tasks.get(Integer.valueOf(taskId)))) {
                                tasksFailed.add(tasks.get(Integer.valueOf(taskId)));
                            }
                            tasksCurrent.remove(tasks.get(Integer.valueOf(taskId)));
                        } else if (line.contains("@doSubmit") && line.contains("New Job")) {
                            logger.debug("* New job");
                            str = line.split(" ");
                            lastNewJobId = str[str.length - 3];
                            taskId2 = str[str.length - 1].substring(0, str[str.length - 1].indexOf(")"));
                            if (Integer.valueOf(lastNewJobId) >= jobsToTasks.size()) {
                                jobsToTasks.setSize(Integer.valueOf(lastNewJobId) + 1);
                            }
                            jobsToTasks.set(Integer.valueOf(lastNewJobId), Integer.valueOf(taskId2));
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId2))).addJob(lastNewJobId, false);
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId2))).setTaskStatus("Running");
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId2))).setJobStatus("Running");
                            if (!tasksCurrent.contains(tasks.get(Integer.valueOf(taskId2)))) {
                                tasksCurrent.add(tasks.get(Integer.valueOf(taskId2)));
                            }
                        } else if (line.contains("@doSubmit") && line.contains("Rescheduled Job")) {
                            logger.debug("* Rescheduled job");
                            str = line.split(" ");
                            lastNewJobId = str[str.length - 3];
                            taskId2 = str[str.length - 1].substring(0, str[str.length - 1].indexOf(")"));
                            if (Integer.valueOf(lastNewJobId) >= jobsToTasks.size()) {
                                jobsToTasks.setSize(Integer.valueOf(lastNewJobId) + 1);
                            }
                            jobsToTasks.set(Integer.valueOf(lastNewJobId), Integer.valueOf(taskId2));
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId2))).addJob(lastNewJobId, false);
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId2))).setTaskStatus("Running");
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId2))).setJobStatus("Running");
                            if (!tasksCurrent.contains(tasks.get(Integer.valueOf(taskId2)))) {
                                tasksCurrent.add(tasks.get(Integer.valueOf(taskId2)));
                            }
                        } else if (line.contains("@doSubmit") && line.contains("* Target host")) {
                            logger.debug("* Add target for last new job");
                            String host = line.substring(line.lastIndexOf(": ") + 1);
                            ((ExecutionInformationTask)tasks.get((Integer)jobsToTasks.get(Integer.valueOf(lastNewJobId)))).setJobHost(lastNewJobId, false, host);
                        } else if (line.contains("@failedJob") && line.contains("with state FAILED")) {
                            logger.debug("* Failed job");
                            info = line.split(" ");
                            jobId = info[info.length - 4];
                            ((ExecutionInformationTask)tasks.get((Integer)jobsToTasks.get(Integer.valueOf(jobId)))).setJobStatus("Failed");
                            if (!tasksWithFailedJobs.contains(tasks.get((Integer)jobsToTasks.get(Integer.valueOf(jobId))))) {
                                tasksWithFailedJobs.add(tasks.get((Integer)jobsToTasks.get(Integer.valueOf(jobId))));
                            }
                        } else if (line.contains("@failedJob") && line.contains("resubmitting task to the same worker")) {
                            logger.debug("* Job Resubmited");
                            info = line.split(" ");
                            jobId = info[info.length - 16];
                            String taskId3 = info[info.length - 12];
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId3))).addJob(jobId, true);
                            ((ExecutionInformationTask)tasks.get(Integer.valueOf(taskId3))).setJobStatus("Running");
                            if (!tasksWithFailedJobs.contains(tasks.get(Integer.valueOf(taskId3)))) {
                                tasksWithFailedJobs.add(tasks.get(Integer.valueOf(taskId3)));
                            }
                            resubmitedJobs.add(jobId);
                        } else if (line.contains("@completedJob") && line.contains("with state OK")) {
                            logger.debug("* Job completed");
                            info = line.split(" ");
                            jobId = info[info.length - 4];
                            ((ExecutionInformationTask)tasks.get((Integer)jobsToTasks.get(Integer.valueOf(jobId)))).setJobStatus("Done");
                        }
                    }
                    ++i;
                    line = br.readLine();
                }
                lastParsedLine = i - 1;
            }
            catch (Exception e) {
                logger.error("Cannot parse runtime.log file: " + runtimeLogPath);
                logger.debug("Error ", (Throwable)e);
                RuntimeLogParser.clear();
            }
        } else {
            RuntimeLogParser.clear();
        }
        logger.debug("runtime.log file parsed");
    }

    private static void clear() {
        tasks.clear();
        tasksCurrent.clear();
        tasksFailed.clear();
        tasksWithFailedJobs.clear();
        runtimeLogPath = "";
        lastParsedLine = -1;
        jobsToTasks.clear();
        resubmitedJobs.clear();
    }
}

