/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui.auth;

import es.bsc.compss.ui.Application;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserCredential {
    private static final Logger LOGGER = LogManager.getLogger((String)"compssMonitor.Authentication");
    private static final String RELATIVE_LOG_LOCATION = File.separator + ".COMPSs" + File.separator;
    private String username;
    private String compssBaseLog;
    private Application monitoredApp;
    private boolean authenticated = false;

    public UserCredential() {
        this.username = "";
        this.compssBaseLog = "";
        this.monitoredApp = new Application();
    }

    public UserCredential(String username) {
        LOGGER.debug("Creating user credentials...");
        if (username != null) {
            if (!username.isEmpty()) {
                this.username = username;
            } else {
                this.loadDefaultOrEnvironmentUser();
                this.compssBaseLog = "";
                this.monitoredApp = new Application();
            }
        } else {
            this.loadDefaultOrEnvironmentUser();
            this.compssBaseLog = "";
            this.monitoredApp = new Application();
        }
        LOGGER.info("User credentails loaded: " + this.username);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setAuthenticated() {
        LOGGER.debug("Verifying user credentials...");
        if (this.username.equals("default")) {
            this.loadDefaultOrEnvironmentLogFolder();
            this.authenticated = true;
            LOGGER.debug("defaultuser credentials loaded");
        } else if (this.username.equals("environment")) {
            this.loadDefaultOrEnvironmentLogFolder();
            this.authenticated = true;
            LOGGER.debug("environmentuser credentials loaded");
        } else if (this.username.startsWith(File.separator)) {
            this.compssBaseLog = this.username.endsWith(".COMPSs") || this.username.endsWith(".COMPSs" + File.separator) ? this.username : this.username + RELATIVE_LOG_LOCATION;
            this.username = "path";
            this.authenticated = true;
            LOGGER.debug("Direct location detected. Path loaded.");
        } else {
            String[] cmd = new String[]{File.separator + "bin" + File.separator + "sh", "-c", "echo ~" + this.username};
            try {
                String userHome = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(cmd).getInputStream())).readLine();
                if (userHome == null) {
                    LOGGER.error("Defined user " + this.username + "is not available.");
                    return false;
                }
                if (userHome.isEmpty()) {
                    LOGGER.error("Defined user " + this.username + "is not available.");
                    return false;
                }
                if (!userHome.startsWith(File.separator)) {
                    LOGGER.error("Defined user " + this.username + "is not available.");
                    return false;
                }
                this.compssBaseLog = userHome + RELATIVE_LOG_LOCATION;
                this.authenticated = true;
                LOGGER.debug(this.username + "user credentials loaded");
            }
            catch (IOException e) {
                LOGGER.error("Defined user " + this.username + "is not available.");
                return false;
            }
        }
        LOGGER.info("User credentails loaded: " + this.username + " " + this.compssBaseLog);
        return true;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCompssBaseLog() {
        return this.compssBaseLog;
    }

    public void setCompssBaseLog(String compssBaseLog) {
        this.compssBaseLog = compssBaseLog;
    }

    public Application getMonitoredApp() {
        return this.monitoredApp;
    }

    public void setMonitoredApp(Application monitoredApp) {
        this.monitoredApp = monitoredApp;
    }

    private void loadDefaultOrEnvironmentUser() {
        if (System.getenv("COMPSS_MONITOR") == null) {
            LOGGER.debug("Loading default user");
            this.username = "default";
        } else {
            LOGGER.debug("Loading environment user");
            this.username = "environment";
        }
    }

    private void loadDefaultOrEnvironmentLogFolder() {
        if (System.getenv("COMPSS_MONITOR") == null) {
            LOGGER.debug("Loading default user");
            this.compssBaseLog = System.getProperty("user.home") + RELATIVE_LOG_LOCATION;
        } else {
            LOGGER.debug("Loading environment user");
            this.compssBaseLog = System.getenv("COMPSS_MONITOR");
        }
    }
}

