/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.StatisticParameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zul.ListModelList;

public class StatisticsViewModel {
    private List<StatisticParameter> statistics;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM.StatisticsVM");

    @Init
    public void init() {
        this.statistics = new LinkedList();
    }

    public List<StatisticParameter> getStatistics() {
        return new ListModelList((Collection)this.statistics);
    }

    @Command
    @NotifyChange(value={"statistics"})
    public void update(HashMap<String, String> statisticsParameters) {
        logger.debug("Updating Statistics ViewModel...");
        this.statistics.clear();
        for (Map.Entry<String, String> entry : statisticsParameters.entrySet()) {
            this.statistics.add(new StatisticParameter(entry.getKey(), entry.getValue()));
        }
        logger.debug("Statistics ViewModel updated");
    }

    @Command
    @NotifyChange(value={"statistics"})
    public void clear() {
        this.statistics.clear();
    }
}

