/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui.auth;

import es.bsc.compss.ui.Application;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserCredential {
    private String username;
    private String COMPSs_BASE_LOG;
    private Application monitoredApp;
    private boolean authenticated = false;
    private static final String RELATIVE_LOG_LOCATION = File.separator + ".COMPSs" + File.separator;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.Authentication");

    public UserCredential() {
        this.username = "";
        this.COMPSs_BASE_LOG = "";
        this.monitoredApp = new Application();
    }

    public UserCredential(String username) {
        logger.debug("Creating user credentials...");
        if (username != null) {
            if (!username.isEmpty()) {
                this.username = username;
            } else {
                this.loadDefaultOrEnvironmentUser();
                this.COMPSs_BASE_LOG = "";
                this.monitoredApp = new Application();
            }
        } else {
            this.loadDefaultOrEnvironmentUser();
            this.COMPSs_BASE_LOG = "";
            this.monitoredApp = new Application();
        }
        logger.info("User credentails loaded: " + this.username);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setAuthenticated() {
        logger.debug("Verifying user credentials...");
        if (this.username.equals("default")) {
            this.loadDefaultOrEnvironmentLogFolder();
            this.authenticated = true;
            logger.debug("defaultuser credentials loaded");
        } else if (this.username.equals("environment")) {
            this.loadDefaultOrEnvironmentLogFolder();
            this.authenticated = true;
            logger.debug("environmentuser credentials loaded");
        } else if (this.username.startsWith(File.separator)) {
            this.COMPSs_BASE_LOG = this.username.endsWith(".COMPSs") || this.username.endsWith(".COMPSs" + File.separator) ? this.username : this.username + RELATIVE_LOG_LOCATION;
            this.username = "path";
            this.authenticated = true;
            logger.debug("Direct location detected. Path loaded.");
        } else {
            String[] cmd = new String[]{File.separator + "bin" + File.separator + "sh", "-c", "echo ~" + this.username};
            try {
                String userHome = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(cmd).getInputStream())).readLine();
                if (userHome == null) {
                    logger.error("Defined user " + this.username + "is not available.");
                    return false;
                }
                if (userHome.isEmpty()) {
                    logger.error("Defined user " + this.username + "is not available.");
                    return false;
                }
                if (!userHome.startsWith(File.separator)) {
                    logger.error("Defined user " + this.username + "is not available.");
                    return false;
                }
                this.COMPSs_BASE_LOG = userHome + RELATIVE_LOG_LOCATION;
                this.authenticated = true;
                logger.debug(this.username + "user credentials loaded");
            }
            catch (IOException e) {
                logger.error("Defined user " + this.username + "is not available.");
                return false;
            }
        }
        logger.info("User credentails loaded: " + this.username + " " + this.COMPSs_BASE_LOG);
        return true;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCOMPSs_BASE_LOG() {
        return this.COMPSs_BASE_LOG;
    }

    public void setCOMPSs_BASE_LOG(String compss_base_log) {
        this.COMPSs_BASE_LOG = compss_base_log;
    }

    public Application getMonitoredApp() {
        return this.monitoredApp;
    }

    public void setMonitoredApp(Application monitoredApp) {
        this.monitoredApp = monitoredApp;
    }

    private void loadDefaultOrEnvironmentUser() {
        if (System.getenv("COMPSS_MONITOR") == null) {
            logger.debug("Loading default user");
            this.username = "default";
        } else {
            logger.debug("Loading environment user");
            this.username = "environment";
        }
    }

    private void loadDefaultOrEnvironmentLogFolder() {
        if (System.getenv("COMPSS_MONITOR") == null) {
            logger.debug("Loading default user");
            this.COMPSs_BASE_LOG = System.getProperty("user.home") + RELATIVE_LOG_LOCATION;
        } else {
            logger.debug("Loading environment user");
            this.COMPSs_BASE_LOG = System.getenv("COMPSS_MONITOR");
        }
    }
}

