/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.Resource;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zul.ListModelList;

public class ResourcesViewModel {
    private List<Resource> resources;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM.ResourcesVM");

    @Init
    public void init() {
        this.resources = new LinkedList();
    }

    public List<Resource> getResources() {
        return new ListModelList((Collection)this.resources);
    }

    @Command
    @NotifyChange(value={"resources"})
    public void update(List<String[]> newResourcesData) {
        logger.debug("Updating Resources ViewModel...");
        this.resources.clear();
        for (String[] dr : newResourcesData) {
            if (dr[5] != null) {
                if (dr[5].startsWith("0.")) {
                    Float memsize = Float.valueOf(Float.parseFloat(dr[5]));
                    dr[5] = String.valueOf(memsize.floatValue() * 1024.0f) + " MB";
                } else {
                    dr[5] = !dr[5].isEmpty() ? dr[5] + " GB" : "-";
                }
            } else {
                dr[5] = "-";
            }
            if (dr[6] != null) {
                if (dr[6].startsWith("0.")) {
                    Float disksize = Float.valueOf(Float.parseFloat(dr[6]));
                    dr[6] = String.valueOf(disksize.floatValue() * 1024.0f) + " MB";
                } else {
                    dr[6] = !dr[6].isEmpty() ? dr[6] + " GB" : "-";
                }
            } else {
                dr[6] = "-";
            }
            Resource r = new Resource(dr);
            this.resources.add(r);
        }
        logger.debug("Resources ViewModel updated");
    }

    @Command
    @NotifyChange(value={"resources"})
    public void clear() {
        this.resources.clear();
    }
}

