/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.Application;
import es.bsc.compss.ui.CompleteGraphViewModel;
import es.bsc.compss.ui.CoresViewModel;
import es.bsc.compss.ui.CurrentGraphViewModel;
import es.bsc.compss.ui.ExecutionInformationViewModel;
import es.bsc.compss.ui.LoadChartViewModel;
import es.bsc.compss.ui.Properties;
import es.bsc.compss.ui.ResourcesViewModel;
import es.bsc.compss.ui.RuntimeLogViewModel;
import es.bsc.compss.ui.StatisticsViewModel;
import es.bsc.compss.ui.auth.UserCredential;
import monitoringParsers.MonitorXmlParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Messagebox;

public class ViewModel {
    private ResourcesViewModel resourcesViewModel;
    private CoresViewModel coresViewModel;
    private CurrentGraphViewModel currentGraphViewModel;
    private CompleteGraphViewModel completeGraphViewModel;
    private LoadChartViewModel loadChartViewModel;
    private RuntimeLogViewModel runtimeLogViewModel;
    private ExecutionInformationViewModel executionInformationViewModel;
    private StatisticsViewModel statisticsViewModel;
    private String selectedTab;
    private static int runtimeLogConfirmation = -1;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM");

    @Init
    public void init() {
        logger.debug("Initializing Resources ViewModel Structure...");
        this.resourcesViewModel = new ResourcesViewModel();
        this.resourcesViewModel.init();
        logger.debug("Initializing Tasks ViewModel Structure...");
        this.coresViewModel = new CoresViewModel();
        this.coresViewModel.init();
        logger.debug("Initializing Current Graph ViewModel Structure...");
        this.currentGraphViewModel = new CurrentGraphViewModel();
        this.currentGraphViewModel.init();
        logger.debug("Initializing Complete Graph ViewModel Structure...");
        this.completeGraphViewModel = new CompleteGraphViewModel();
        this.completeGraphViewModel.init();
        logger.debug("Initializing Resources Load Chart ViewModel Structure...");
        this.loadChartViewModel = new LoadChartViewModel();
        this.loadChartViewModel.init();
        logger.debug("Initializing it.log Structure...");
        this.runtimeLogViewModel = new RuntimeLogViewModel();
        this.runtimeLogViewModel.init();
        logger.debug("Initializing Execution Information Structure...");
        this.executionInformationViewModel = new ExecutionInformationViewModel();
        this.executionInformationViewModel.init();
        logger.debug("Initializing Statistics Structure...");
        this.statisticsViewModel = new StatisticsViewModel();
        this.statisticsViewModel.init();
        logger.debug("Initalizing private structures...");
        this.selectedTab = new String("resourcesInformationTab");
        logger.info("Initialization DONE");
        this.update();
    }

    public ResourcesViewModel getResourcesViewModel() {
        return this.resourcesViewModel;
    }

    public CoresViewModel getCoresViewModel() {
        return this.coresViewModel;
    }

    public CurrentGraphViewModel getCurrentGraphViewModel() {
        return this.currentGraphViewModel;
    }

    public CompleteGraphViewModel getCompleteGraphViewModel() {
        return this.completeGraphViewModel;
    }

    public LoadChartViewModel getLoadChartViewModel() {
        return this.loadChartViewModel;
    }

    public RuntimeLogViewModel getRuntimeLogViewModel() {
        return this.runtimeLogViewModel;
    }

    public ExecutionInformationViewModel getExecutionInformationViewModel() {
        return this.executionInformationViewModel;
    }

    public StatisticsViewModel getStatisticsViewModel() {
        return this.statisticsViewModel;
    }

    public int getRefreshTime() {
        return Properties.getRefreshTime();
    }

    @Command
    @NotifyChange(value={"resourcesViewModel", "coresViewModel", "currentGraphViewModel", "completeGraphViewModel", "loadChartViewModel", "runtimeLogViewModel", "executionInformationViewModel", "statisticsViewModel"})
    public void select(@BindingParam(value="selectedTab") String selectedTab) {
        if (!this.selectedTab.equals(selectedTab)) {
            this.selectedTab = selectedTab;
            if (selectedTab.equals("runtimeLogTab")) {
                logger.debug("Trying to load runtime.log, displaying messagebox");
                runtimeLogConfirmation = -1;
                Messagebox.show((String)"The runtime.log can be huge and you may experience slowness loading this tab. Do you really want to load it?", (String)"Warning", (int)3, (String)"z-messagebox-icon z-messagebox-question", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.update();
                this.updateRuntimeLog();
                this.updateExecutionInformation();
            }
        }
    }

    @Command
    @NotifyChange(value={"resourcesViewModel", "coresViewModel", "currentGraphViewModel", "completeGraphViewModel", "loadChartViewModel", "statisticsViewModel", "runtimeLogViewModel"})
    public void update() {
        UserCredential userCred;
        logger.debug("Loading Monitored Application...");
        Application monitoredApp = new Application();
        Session session = Sessions.getCurrent();
        if (session != null && (userCred = (UserCredential)session.getAttribute("userCredential")) != null) {
            monitoredApp = userCred.getMonitoredApp();
        }
        logger.info("Loaded Monitored Application: " + monitoredApp.getName());
        if (monitoredApp.getName() != "") {
            if (this.selectedTab.equals("resourcesInformationTab")) {
                logger.debug("Updating Resources Information...");
                logger.debug("Parsing Monitor XML File...");
                MonitorXmlParser.parseResources();
                logger.debug("Monitor XML File parsed");
                this.resourcesViewModel.update(MonitorXmlParser.getWorkersDataArray());
                logger.info("Structures updated");
            } else if (this.selectedTab.equals("tasksInformationTab")) {
                logger.debug("Updating Jobs Information...");
                logger.debug("Parsing Monitor XML File...");
                MonitorXmlParser.parseCores();
                logger.debug("Monitor XML File parsed");
                this.coresViewModel.update(MonitorXmlParser.getCoresDataArray());
                logger.info("Structures updated");
            } else if (this.selectedTab.equals("currentTasksGraphTab")) {
                logger.debug("Updating Current Tasks Graph...");
                logger.debug("Parsing Monitor XML File...");
                MonitorXmlParser.parseCores();
                logger.debug("Monitor XML File parsed");
                this.coresViewModel.update(MonitorXmlParser.getCoresDataArray());
                this.currentGraphViewModel.update(monitoredApp);
                logger.info("Structures updated");
            } else if (this.selectedTab.equals("completeTasksGraphTab")) {
                logger.debug("Updating Complete Tasks Graph...");
                logger.debug("Parsing Monitor XML File...");
                MonitorXmlParser.parseCores();
                logger.debug("Monitor XML File parsed");
                this.coresViewModel.update(MonitorXmlParser.getCoresDataArray());
                this.completeGraphViewModel.update(monitoredApp);
                logger.info("Structures updated");
            } else if (this.selectedTab.equals("loadChartTab")) {
                logger.debug("Updating Resouces Load Chart...");
                this.loadChartViewModel.update();
                logger.info("Structures updated");
            } else if (this.selectedTab.equals("statisticsTab")) {
                logger.debug("Updating statistics...");
                logger.debug("Parsing Monitor XML File...");
                MonitorXmlParser.parseStatistics();
                logger.debug("Monitor XML File parsed");
                this.statisticsViewModel.update(MonitorXmlParser.getStatisticsParameters());
                logger.info("Structures updated");
            } else if (this.selectedTab.equals("runtimeLogTab")) {
                if (runtimeLogConfirmation == 0) {
                    logger.debug("Messagebox confirmation received. Loading runtime.log");
                    this.updateRuntimeLog();
                    runtimeLogConfirmation = -1;
                } else if (runtimeLogConfirmation == 1) {
                    logger.debug("Messagebox denied");
                    runtimeLogConfirmation = -1;
                }
            } else if (!this.selectedTab.equals("executionInformationTab")) {
                logger.info("No Information Tab selected");
            }
        } else {
            this.resourcesViewModel.clear();
            this.coresViewModel.clear();
            this.currentGraphViewModel.clear();
            this.completeGraphViewModel.clear();
            this.loadChartViewModel.clear();
            this.statisticsViewModel.clear();
            this.runtimeLogViewModel.clear();
            logger.info("No Application Selected");
        }
    }

    @Command
    @NotifyChange(value={"runtimeLogViewModel"})
    public void updateRuntimeLog() {
        UserCredential userCred;
        logger.debug("Loading Monitored Application...");
        Application monitoredApp = new Application();
        Session session = Sessions.getCurrent();
        if (session != null && (userCred = (UserCredential)session.getAttribute("userCredential")) != null) {
            monitoredApp = userCred.getMonitoredApp();
        }
        logger.debug("Loaded Monitored Application: " + monitoredApp.getName());
        logger.debug("Updating RuntimeLog...");
        if (monitoredApp.getName() != "") {
            if (this.selectedTab.equals("runtimeLogTab")) {
                this.runtimeLogViewModel.update();
            } else {
                this.runtimeLogViewModel.clear();
            }
        } else {
            this.runtimeLogViewModel.clear();
        }
        logger.info("Runtime.log updated");
    }

    @Command
    @NotifyChange(value={"executionInformationViewModel"})
    public void updateExecutionInformation() {
        UserCredential userCred;
        logger.debug("Loading Monitored Application...");
        Application monitoredApp = new Application();
        Session session = Sessions.getCurrent();
        if (session != null && (userCred = (UserCredential)session.getAttribute("userCredential")) != null) {
            monitoredApp = userCred.getMonitoredApp();
        }
        logger.debug("Loaded Monitored Application: " + monitoredApp.getName());
        logger.debug("Updating Execution Information...");
        if (monitoredApp.getName() != "") {
            if (this.selectedTab.equals("executionInformationTab")) {
                this.executionInformationViewModel.update();
            }
        } else {
            this.executionInformationViewModel.clear();
        }
        logger.info("Execution Information updated");
    }

    @Command
    @NotifyChange(value={"loadChartViewModel"})
    public void setDivUUID(@BindingParam(value="divuuid") String divuuid) {
        this.loadChartViewModel.setDivUUID(divuuid);
    }

    @Command
    public void downloadCompleteGraph() {
        this.completeGraphViewModel.download();
    }

    @Command
    public void downloadCurrentGraph() {
        this.currentGraphViewModel.download();
    }

    @GlobalCommand
    @NotifyChange(value={"resourcesViewModel", "coresViewModel", "currentGraphViewModel", "completeGraphViewModel", "loadChartViewModel", "runtimeLogViewModel", "executionInformationViewModel", "statisticsViewModel"})
    public void refresh() {
        this.update();
        this.updateRuntimeLog();
        this.updateExecutionInformation();
    }

    static /* synthetic */ int access$002(int x0) {
        runtimeLogConfirmation = x0;
        return runtimeLogConfirmation;
    }
}

