/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.Application;
import es.bsc.compss.ui.ApplicationsViewModel;
import es.bsc.compss.ui.Properties;
import es.bsc.compss.ui.auth.UserCredential;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zul.ListModelList;

public class ApplicationsViewModel {
    private List<Application> applications;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM.ApplicationsVM");

    @Init
    public void init() {
        this.applications = new LinkedList();
        this.update();
    }

    public List<Application> getApplications() {
        return new ListModelList((Collection)this.applications);
    }

    @Command
    @NotifyChange(value={"applications"})
    public void update() {
        logger.debug("Updating Applications ViewModel...");
        this.applications.clear();
        this.setSelectedApp("");
        String appsLocation = ((UserCredential)Sessions.getCurrent().getAttribute("userCredential")).getCOMPSs_BASE_LOG();
        File COMPSs_LOG_DIR = new File(appsLocation);
        if (COMPSs_LOG_DIR.exists()) {
            for (File f : COMPSs_LOG_DIR.listFiles()) {
                logger.debug("Adding application " + f.getName());
                Application app = new Application(f.getName(), appsLocation + File.separator + f.getName());
                this.applications.add(app);
            }
        }
        if (Properties.isSortApplications()) {
            Collections.sort(this.applications, new ApplicationComparator(this, null));
        }
        logger.debug("Applications ViewModel updated");
    }

    @Command
    public void setSelectedApp(@BindingParam(value="appName") String appName) {
        logger.debug("Updating Selected Application...");
        Application selectedApp = new Application();
        for (Application app : this.applications) {
            if (!app.getName().equals(appName)) continue;
            selectedApp = new Application(app);
            break;
        }
        Properties.setBasePath((String)selectedApp.getPath());
        ((UserCredential)Sessions.getCurrent().getAttribute("userCredential")).setMonitoredApp(selectedApp);
        logger.debug("Selected application updated");
    }
}

