/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.exceptions.EmptyCompleteGraphException;
import es.bsc.compss.ui.Application;
import es.bsc.compss.ui.Constants;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zul.Filedownload;

public class CompleteGraphViewModel {
    private static final long COMPLETE_GRAPH_EMPTY_SIZE = 738L;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM.GraphVM");
    private String completeGraph;
    private String completeGraphLastUpdateTime;

    @Init
    public void init() {
        this.completeGraph = new String();
        this.completeGraphLastUpdateTime = new String();
    }

    public String getCompleteGraph() {
        return this.completeGraph;
    }

    @Command
    public void download() {
        try {
            if (this.completeGraph.equals(Constants.GRAPH_NOT_FOUND_PATH) || this.completeGraph.equals(Constants.GRAPH_EXECUTION_DONE_PATH) || this.completeGraph.equals(Constants.UNSELECTED_GRAPH_PATH) || this.completeGraph.equals(Constants.EMPTY_GRAPH_PATH)) {
                Filedownload.save((String)this.completeGraph, null);
            } else {
                Filedownload.save((String)this.completeGraph.substring(0, this.completeGraph.lastIndexOf("?")), null);
            }
        }
        catch (Exception e) {
            logger.error("Cannot download complete graph");
        }
    }

    @Command
    @NotifyChange(value={"completeGraph"})
    public void update(Application monitoredApp) {
        logger.debug("Updating Complete Graph...");
        String completeMonitorLocation = monitoredApp.getPath() + Constants.MONITOR_COMPLETE_DOT_FILE;
        File completeMonitorFile = new File(completeMonitorLocation);
        if (completeMonitorFile.exists()) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            String modifiedTime = sdf.format(completeMonitorFile.lastModified());
            if (!modifiedTime.equals(this.completeGraphLastUpdateTime)) {
                try {
                    String completeGraphSVG = File.separator + "svg" + File.separator + monitoredApp.getName() + "_" + "completeGraph.svg";
                    this.completeGraph = this.loadGraph(completeMonitorLocation, completeGraphSVG);
                    this.completeGraphLastUpdateTime = modifiedTime;
                }
                catch (EmptyCompleteGraphException ecge) {
                    logger.debug("Empty complete graph");
                    this.completeGraph = Constants.EMPTY_GRAPH_PATH;
                    this.completeGraphLastUpdateTime = modifiedTime;
                }
                catch (Exception e) {
                    this.completeGraph = Constants.GRAPH_NOT_FOUND_PATH;
                    this.completeGraphLastUpdateTime = "";
                    logger.error("Graph generation error", (Throwable)e);
                }
            } else {
                logger.debug("Complete Graph is already loaded");
            }
        } else {
            this.completeGraph = Constants.GRAPH_NOT_FOUND_PATH;
            this.completeGraphLastUpdateTime = "";
            logger.debug("Complete Graph file not found");
        }
    }

    @Command
    @NotifyChange(value={"completeGraph"})
    public void clear() {
        this.completeGraph = Constants.UNSELECTED_GRAPH_PATH;
        this.completeGraphLastUpdateTime = "";
    }

    private String loadGraph(String location, String target) throws EmptyCompleteGraphException, IOException, InterruptedException {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading Graph...");
            logger.debug("   - Monitoring source: " + location);
            logger.debug("   - Monitoring target: " + target);
        }
        String targetFullPath = System.getProperty("catalina.base") + File.separator + "webapps" + File.separator + "compss-monitor" + File.separator + target;
        String[] createSVG = new String[]{"/bin/bash", "-c", "dot -T svg -Gnewrank=true " + location + " > " + targetFullPath};
        Process p1 = Runtime.getRuntime().exec(createSVG);
        p1.waitFor();
        File graphFile = new File(targetFullPath);
        if (!graphFile.exists() || graphFile.length() <= 738L) {
            throw new EmptyCompleteGraphException("Empty complete graph");
        }
        String[] addJSScript = new String[]{"/bin/bash", "-c", "sed -i \"s/\\<g id\\=\\\"graph0/script xlink:href\\=\\\"SVGPan.js\\\"\\/\\>\\n\\<g id\\=\\\"viewport/\" " + targetFullPath};
        Process p2 = Runtime.getRuntime().exec(addJSScript);
        p2.waitFor();
        String[] addJSScript2 = new String[]{"/bin/bash", "-c", "sed -i \"s/\\<g id\\=\\\"graph1/script xlink:href\\=\\\"SVGPan.js\\\"\\/\\>\\n\\<g id\\=\\\"viewport/\" " + targetFullPath};
        Process p3 = Runtime.getRuntime().exec(addJSScript2);
        p3.waitFor();
        String[] createViewBox = new String[]{"/bin/bash", "-c", "sed -i \"s/<svg .*/<svg xmlns\\=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" xmlns:xlink\\=\\\"http:\\/\\/www.w3.org\\/1999\\/xlink\\\"\\>/g\" " + targetFullPath};
        Process p4 = Runtime.getRuntime().exec(createViewBox);
        p4.waitFor();
        logger.debug("Graph loaded");
        return target + "?t=" + System.currentTimeMillis();
    }
}

