/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.Constants;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import monitoringParsers.ResourcesLogParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.util.Clients;

public class LoadChartViewModel {
    private String divUUID;
    private String chartType;
    private boolean noConnection_drawn;
    private boolean chart_drawn;
    private final int TIMEOUT = 3000;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.VM.LoadChartVM");

    @Init
    public void init() {
        this.divUUID = new String("");
        this.chartType = new String("totalLoadChart");
        this.noConnection_drawn = false;
        this.chart_drawn = false;
    }

    @Command
    public void setDivUUID(@BindingParam(value="divuuid") String divuuid) {
        this.divUUID = divuuid;
    }

    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
        this.draw();
    }

    @Command
    public void update() {
        logger.debug("Updating Load Chart View Model...");
        ResourcesLogParser.parse();
        this.draw();
        logger.debug("Load Chart View Model updated");
    }

    @Command
    public void clear() {
        this.chartType = "totalLoadChart";
        ResourcesLogParser.clear();
        this.draw();
    }

    private void draw() {
        if (!this.divUUID.equals("")) {
            if (this.testInet()) {
                logger.debug("Internet connection available. Generating google-chart");
                if (this.noConnection_drawn) {
                    Clients.evalJavaScript((String)("eraseNoConnection('" + this.divUUID + "');"));
                    this.noConnection_drawn = false;
                }
                this.chart_drawn = true;
                if (this.chartType.equals("totalLoadChart")) {
                    Clients.evalJavaScript((String)("drawTotalLoadChart('" + this.divUUID + "'," + ResourcesLogParser.getTotalLoad() + ");"));
                } else if (this.chartType.equals("loadPerCoreChart")) {
                    Clients.evalJavaScript((String)("drawLoadPerCoreChart('" + this.divUUID + "'," + ResourcesLogParser.getLoadPerCore() + ");"));
                } else if (this.chartType.equals("totalRunningChart")) {
                    Clients.evalJavaScript((String)("drawTotalCores('" + this.divUUID + "'," + ResourcesLogParser.getTotalRunningCores() + ");"));
                } else if (this.chartType.equals("runningPerCoreChart")) {
                    Clients.evalJavaScript((String)("drawCoresPerCoreChart('" + this.divUUID + "'," + ResourcesLogParser.getRunningCoresPerCore() + ");"));
                } else if (this.chartType.equals("totalPendingChart")) {
                    Clients.evalJavaScript((String)("drawTotalCores('" + this.divUUID + "'," + ResourcesLogParser.getTotalPendingCores() + ");"));
                } else if (this.chartType.equals("pendingPerCoreChart")) {
                    Clients.evalJavaScript((String)("drawCoresPerCoreChart('" + this.divUUID + "'," + ResourcesLogParser.getPendingCoresPerCore() + ");"));
                } else if (this.chartType.equals("totalResourcesStatusChart")) {
                    Clients.evalJavaScript((String)("drawTotalResourcesStatusChart('" + this.divUUID + "'," + ResourcesLogParser.getResourcesStatus() + ");"));
                } else {
                    logger.warn("WARNING: Invalid chart type. Rendering empty graph");
                    Clients.evalJavaScript((String)("drawEmpty('" + this.divUUID + "');"));
                }
            } else {
                logger.info("No internet connection. Rendering warning image");
                if (this.chart_drawn) {
                    Clients.evalJavaScript((String)("eraseChart('" + this.divUUID + "');"));
                    this.chart_drawn = false;
                }
                if (!this.noConnection_drawn) {
                    Clients.evalJavaScript((String)("drawNoConnection('" + this.divUUID + "','" + Constants.NO_CONNECTION_IMG_PATH + "');"));
                    this.noConnection_drawn = true;
                }
            }
        } else {
            logger.debug("DivUUID not found. Cannot render chart.");
            this.noConnection_drawn = false;
            this.chart_drawn = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testInet() {
        Socket sock = new Socket();
        InetSocketAddress addr = new InetSocketAddress("google.com", 80);
        try {
            sock.connect(addr, 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                sock.close();
            }
            catch (IOException e) {
                logger.warn("WARNING: Cannot close Inet connection");
            }
        }
    }
}

