/*
 * Decompiled with CFR 0.152.
 */
package monitoringParsers;

import es.bsc.compss.ui.Properties;
import es.bsc.compss.ui.StateData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourcesLogParser {
    private static Vector<StateData> states = new Vector();
    private static String resourcesLogPath = "";
    private static int lastParsedLine = -1;
    private static long referenceTimestamp = 0L;
    private static long lastSeenTimestamp = 0L;
    private static int scaleTimeStamp = 0;
    private static boolean processInformation = false;
    private static final Logger logger = LogManager.getLogger((String)"compssMonitor.Parsers.ResourcesLog");

    public static String getTotalLoad() {
        StringBuilder result = new StringBuilder("'");
        for (int i = 0; i < states.size(); ++i) {
            if (i != 0) {
                result.append(" ");
            }
            result.append(((StateData)states.get(i)).getTimestamp()).append(":").append(((StateData)states.get(i)).getTotalLoad()).append(":").append(((StateData)states.get(i)).getTotalResources());
        }
        result.append("'");
        logger.debug("TotalLoadPoints: " + result.toString());
        return result.toString();
    }

    public static String getLoadPerCore() {
        int maxCores = 0;
        for (int i = 0; i < states.size(); ++i) {
            maxCores = Math.max(maxCores, ((StateData)states.get(i)).getMeanTime().size());
        }
        StringBuilder coreData = new StringBuilder("'");
        for (int i = 0; i < states.size(); ++i) {
            if (i != 0) {
                coreData.append(" ");
            }
            coreData.append(((StateData)states.get(i)).getTimestamp());
            for (Float coreLoad : ((StateData)states.get(i)).getMeanTime()) {
                if (coreLoad != null) {
                    coreData.append(":").append(coreLoad);
                    continue;
                }
                coreData.append(":").append(0.0);
            }
            for (int j = ((StateData)states.get(i)).getMeanTime().size(); j < maxCores; ++j) {
                coreData.append(":").append(0.0);
            }
            coreData.append(":").append(((StateData)states.get(i)).getTotalResources());
        }
        coreData.append("'");
        logger.debug("LoadPerCorePoints: " + coreData.toString());
        logger.debug("LoadPerCorePointsMAXCORES: " + maxCores);
        return "'" + String.valueOf(maxCores) + "'," + coreData.toString();
    }

    public static String getTotalRunningCores() {
        StringBuilder result = new StringBuilder("'");
        for (int i = 0; i < states.size(); ++i) {
            if (i != 0) {
                result.append(" ");
            }
            result.append(((StateData)states.get(i)).getTimestamp()).append(":").append(((StateData)states.get(i)).getTotalCoresRunning()).append(":").append(((StateData)states.get(i)).getTotalResources());
        }
        result.append("'");
        logger.debug("TotalRunningCoresPoints: " + result.toString());
        return result.toString();
    }

    public static String getRunningCoresPerCore() {
        int maxCores = 0;
        for (int i = 0; i < states.size(); ++i) {
            maxCores = Math.max(maxCores, ((StateData)states.get(i)).getMeanTime().size());
        }
        StringBuilder coreData = new StringBuilder("'");
        for (int i = 0; i < states.size(); ++i) {
            if (i != 0) {
                coreData.append(" ");
            }
            coreData.append(((StateData)states.get(i)).getTimestamp());
            for (Integer numRunning : ((StateData)states.get(i)).getRunningCores()) {
                if (numRunning != null) {
                    coreData.append(":").append(numRunning);
                    continue;
                }
                coreData.append(":").append(0);
            }
            for (int j = ((StateData)states.get(i)).getRunningCores().size(); j < maxCores; ++j) {
                coreData.append(":").append(0);
            }
            coreData.append(":").append(((StateData)states.get(i)).getTotalResources());
        }
        coreData.append("'");
        logger.debug("RunningCoresPerCorePoints: " + coreData.toString());
        logger.debug("RunningCoresPerCorePointsMAXCORES: " + maxCores);
        return "'" + String.valueOf(maxCores) + "'," + coreData.toString();
    }

    public static String getTotalPendingCores() {
        StringBuilder result = new StringBuilder("'");
        for (int i = 0; i < states.size(); ++i) {
            if (i != 0) {
                result.append(" ");
            }
            result.append(((StateData)states.get(i)).getTimestamp()).append(":").append(((StateData)states.get(i)).getTotalCoresPending()).append(":").append(((StateData)states.get(i)).getTotalResources());
        }
        result.append("'");
        logger.debug("TotalPendingCoresPoints: " + result.toString());
        return result.toString();
    }

    public static String getPendingCoresPerCore() {
        int maxCores = 0;
        for (int i = 0; i < states.size(); ++i) {
            maxCores = Math.max(maxCores, ((StateData)states.get(i)).getMeanTime().size());
        }
        StringBuilder coreData = new StringBuilder("'");
        for (int i = 0; i < states.size(); ++i) {
            if (i != 0) {
                coreData.append(" ");
            }
            coreData.append(((StateData)states.get(i)).getTimestamp());
            for (Integer numPending : ((StateData)states.get(i)).getPendingCores()) {
                if (numPending != null) {
                    coreData.append(":").append(numPending);
                    continue;
                }
                coreData.append(":").append(0);
            }
            for (int j = ((StateData)states.get(i)).getPendingCores().size(); j < maxCores; ++j) {
                coreData.append(":").append(0);
            }
            coreData.append(":").append(((StateData)states.get(i)).getTotalResources());
        }
        coreData.append("'");
        logger.debug("PendingCoresPerCorePoints: " + coreData.toString());
        logger.debug("PendingCoresPerCorePointsMAXCORES: " + maxCores);
        return "'" + String.valueOf(maxCores) + "'," + coreData.toString();
    }

    public static String getResourcesStatus() {
        StringBuilder result = new StringBuilder("'");
        result.append(((StateData)states.lastElement()).getTimestamp()).append(":");
        result.append(((StateData)states.lastElement()).getTotalCPUConsumption()).append(":");
        result.append(((StateData)states.lastElement()).getTotalMemoryConsumption());
        result.append("'");
        if (logger.isDebugEnabled()) {
            logger.debug("ResourcesStatusPoints: " + result.toString());
        }
        return result.toString();
    }

    public static void parse() {
        logger.debug("Parsing resources.log file...");
        if (!Properties.getBasePath().equals("")) {
            String newPath = Properties.getBasePath() + File.separator + "resources.log";
            if (!resourcesLogPath.equals(newPath)) {
                ResourcesLogParser.clear();
                resourcesLogPath = newPath;
            }
            try (FileReader fr = new FileReader(resourcesLogPath);
                 BufferedReader br = new BufferedReader(fr);){
                String line = br.readLine();
                int i = 0;
                while (line != null) {
                    if (i > lastParsedLine) {
                        if (line.contains("TIMESTAMP = ")) {
                            logger.debug("* Timestamp flag");
                            if (++scaleTimeStamp >= Properties.getxScaleForLoadGraph()) {
                                processInformation = true;
                                scaleTimeStamp = 0;
                                lastSeenTimestamp = Long.valueOf(line.substring(line.lastIndexOf("=") + 2));
                                if (states.isEmpty()) {
                                    referenceTimestamp = lastSeenTimestamp;
                                    states.add(new StateData(0));
                                } else {
                                    states.add(new StateData((StateData)states.lastElement()));
                                    ((StateData)states.lastElement()).setTimestamp((int)(lastSeenTimestamp - referenceTimestamp) / 1000);
                                }
                            } else {
                                processInformation = false;
                            }
                        }
                        if (processInformation) {
                            String resourceName;
                            if (line.contains("INFO_MSG = [New resource available in the pool")) {
                                logger.debug("* New resource available flag");
                            } else if (line.contains("INFO_MSG = [New service available")) {
                                logger.debug("* New service available flag");
                            } else if (line.contains("INFO_MSG = [Resource removed from the pool")) {
                                logger.debug("* Resource removed flag");
                                resourceName = line.substring(line.lastIndexOf("=") + 2);
                                ((StateData)states.lastElement()).removeResource(resourceName);
                            } else if (line.contains("LOAD_INFO = [")) {
                                logger.debug("* Load Information flag");
                                ((StateData)states.lastElement()).purgeLoadValues();
                                line = br.readLine();
                                ++i;
                                while (line != null && line.contains("CORE_INFO = [")) {
                                    line = br.readLine();
                                    ++i;
                                    int id = Integer.valueOf(line.substring(line.lastIndexOf("=") + 2));
                                    line = br.readLine();
                                    ++i;
                                    int no_resource = Integer.valueOf(line.substring(line.lastIndexOf("=") + 2));
                                    line = br.readLine();
                                    ++i;
                                    int ready = Integer.valueOf(line.substring(line.lastIndexOf("=") + 2));
                                    line = br.readLine();
                                    ++i;
                                    int running = Integer.valueOf(line.substring(line.lastIndexOf("=") + 2));
                                    line = br.readLine();
                                    ++i;
                                    line = br.readLine();
                                    ++i;
                                    int mean = Integer.valueOf(line.substring(line.lastIndexOf("=") + 2));
                                    line = br.readLine();
                                    ++i;
                                    line = br.readLine();
                                    ++i;
                                    int meanExec = Integer.valueOf(line.substring(line.lastIndexOf("=") + 2));
                                    line = br.readLine();
                                    ++i;
                                    float pendingLoad = Float.valueOf((no_resource + ready) * mean).floatValue();
                                    float remainingTime = Math.max(mean - meanExec, 0);
                                    float runningLoad = Float.valueOf((float)running * remainingTime).floatValue();
                                    float load = (pendingLoad + runningLoad) / Float.valueOf(1000.0f).floatValue();
                                    ((StateData)states.lastElement()).addCoreLoad(id, load);
                                    ((StateData)states.lastElement()).addCorePending(id, no_resource + ready);
                                    ((StateData)states.lastElement()).addCoreRunning(id, running);
                                    line = br.readLine();
                                    ++i;
                                }
                            } else if (line.contains("RESOURCES_INFO = [")) {
                                logger.debug("* Resources Information flag");
                                ((StateData)states.lastElement()).purgeResourcesValues();
                                line = br.readLine();
                                ++i;
                                while (line != null && line.contains("RESOURCE = [")) {
                                    line = br.readLine();
                                    ++i;
                                    resourceName = line.substring(line.lastIndexOf("=") + 2);
                                    line = br.readLine();
                                    ++i;
                                    String type = line.substring(line.lastIndexOf("=") + 2);
                                    line = br.readLine();
                                    ++i;
                                    int cpus = Integer.valueOf(line.substring(line.lastIndexOf("=") + 2));
                                    line = br.readLine();
                                    ++i;
                                    float memory = Float.valueOf(line.substring(line.lastIndexOf("=") + 2)).floatValue();
                                    ((StateData)states.lastElement()).addResource(resourceName, type, cpus, memory);
                                    line = br.readLine();
                                    ++i;
                                    line = br.readLine();
                                    ++i;
                                    while (line != null && line.contains("CORE = [")) {
                                        line = br.readLine();
                                        ++i;
                                        line = br.readLine();
                                        ++i;
                                        line = br.readLine();
                                        ++i;
                                        line = br.readLine();
                                        ++i;
                                    }
                                    line = br.readLine();
                                    ++i;
                                    line = br.readLine();
                                    ++i;
                                }
                            } else if (line.contains("CLOUD_INFO = [")) {
                                logger.debug("* Cloud info flag");
                            } else if (line.contains("INFO_MSG = [Stopping all workers]")) {
                                logger.debug("* Stop all workers flag");
                                ((StateData)states.lastElement()).purgeValues();
                            }
                        }
                    }
                    line = br.readLine();
                    ++i;
                }
                lastParsedLine = i - 1;
            }
            catch (Exception e) {
                ResourcesLogParser.clear();
                logger.error("Cannot parse resrouces.log file: " + resourcesLogPath);
            }
        } else {
            ResourcesLogParser.clear();
        }
        logger.debug("resources.log file parsed");
    }

    public static void clear() {
        resourcesLogPath = "";
        lastParsedLine = -1;
        referenceTimestamp = 0L;
        lastSeenTimestamp = 0L;
        scaleTimeStamp = 0;
        processInformation = false;
        states.clear();
    }
}

