/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.monitoringparsers;

import es.bsc.compss.ui.Constants;
import es.bsc.compss.ui.Properties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class MonitorXmlParser {
    private static final Logger LOGGER = LogManager.getLogger((String)"compssMonitor.Parsers.COMPSsStateXML");
    private static List<String[]> workersDataArray;
    private static List<String[]> coresDataArray;
    private static HashMap<String, String> statisticParameters;

    public static List<String[]> getWorkersDataArray() {
        LOGGER.debug("Granting access to resources data");
        return workersDataArray;
    }

    public static List<String[]> getCoresDataArray() {
        LOGGER.debug("Granting access to cores data");
        return coresDataArray;
    }

    public static HashMap<String, String> getStatisticsParameters() {
        return statisticParameters;
    }

    public static void parseResources() {
        String monitorLocation = Properties.getBasePath() + Constants.MONITOR_XML_FILE;
        LOGGER.debug("Parsing XML file...");
        workersDataArray = new ArrayList();
        LOGGER.debug("Monitor Location : " + monitorLocation);
        try {
            int i;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            Document resourcesDoc = docFactory.newDocumentBuilder().parse(monitorLocation);
            NodeList nl = resourcesDoc.getChildNodes();
            Node compss = null;
            for (i = 0; i < nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equals("COMPSsState")) continue;
                compss = nl.item(i);
                break;
            }
            if (compss == null) {
                return;
            }
            nl = compss.getChildNodes();
            for (i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!n.getNodeName().equals("ResourceInfo")) continue;
                workersDataArray = MonitorXmlParser.parseResourceInfoNode((Node)n);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot load monitor xml files", (Throwable)e);
            return;
        }
        LOGGER.debug("Success: Parse finished");
    }

    public static void parseCores() {
        String monitorLocation = Properties.getBasePath() + Constants.MONITOR_XML_FILE;
        LOGGER.debug("Parsing XML file...");
        coresDataArray = new ArrayList();
        LOGGER.debug("Monitor Location : " + monitorLocation);
        try {
            int i;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            Document resourcesDoc = docFactory.newDocumentBuilder().parse(monitorLocation);
            NodeList nl = resourcesDoc.getChildNodes();
            Node compss = null;
            for (i = 0; i < nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equals("COMPSsState")) continue;
                compss = nl.item(i);
                break;
            }
            if (compss == null) {
                return;
            }
            nl = compss.getChildNodes();
            for (i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!n.getNodeName().equals("CoresInfo")) continue;
                coresDataArray = MonitorXmlParser.parseCoresInfoNode((Node)n);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot load monitor xml files", (Throwable)e);
            return;
        }
        LOGGER.debug("Success: Parse finished");
    }

    public static void parseStatistics() {
        String monitorLocation = Properties.getBasePath() + Constants.MONITOR_XML_FILE;
        LOGGER.debug("Parsing XML file for statistics...");
        statisticParameters = new HashMap();
        LOGGER.debug("Monitor Location : " + monitorLocation);
        try {
            int i;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            Document resourcesDoc = docFactory.newDocumentBuilder().parse(monitorLocation);
            NodeList nl = resourcesDoc.getChildNodes();
            Node compss = null;
            for (i = 0; i < nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equals("COMPSsState")) continue;
                compss = nl.item(i);
                break;
            }
            if (compss == null) {
                return;
            }
            nl = compss.getChildNodes();
            for (i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!n.getNodeName().equals("Statistics")) continue;
                statisticParameters = MonitorXmlParser.parseStatisticsNode((Node)n);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot load monitor xml files", (Throwable)e);
            return;
        }
        LOGGER.debug("Success: Parse finished");
    }

    private static List<String[]> parseResourceInfoNode(Node resourceInfo) throws Exception {
        LOGGER.debug("Parsing resources nodes...");
        ArrayList<String[]> datas = new ArrayList<String[]>();
        NodeList nl = resourceInfo.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals("Resource")) continue;
            datas.add(MonitorXmlParser.parseResourceNode((Node)n));
        }
        return datas;
    }

    private static String[] parseResourceNode(Node resource) throws Exception {
        String workerName = resource.getAttributes().getNamedItem("id").getTextContent();
        LOGGER.debug("Parse ResourceNode " + workerName);
        int maxParams = 11;
        String[] data = new String[11];
        for (int i = 0; i < data.length; ++i) {
            data[i] = "-";
        }
        data[0] = workerName;
        NodeList nl = resource.getChildNodes();
        block27: for (int i = 0; i < nl.getLength(); ++i) {
            Node field = nl.item(i);
            LOGGER.debug("Parsing item: " + field.getNodeName());
            switch (field.getNodeName()) {
                case "TotalCPUComputingUnits": {
                    String content = field.getTextContent();
                    if (content == null || content.isEmpty() || Integer.valueOf(content) <= 0) continue block27;
                    data[1] = content;
                    continue block27;
                }
                case "TotalGPUComputingUnits": {
                    String content = field.getTextContent();
                    if (content == null || content.isEmpty() || Integer.valueOf(content) <= 0) continue block27;
                    data[2] = content;
                    continue block27;
                }
                case "TotalFPGAComputingUnits": {
                    String content = field.getTextContent();
                    if (content == null || content.isEmpty() || Integer.valueOf(content) <= 0) continue block27;
                    data[3] = content;
                    continue block27;
                }
                case "TotalOTHERComputingUnits": {
                    String content = field.getTextContent();
                    if (content == null || content.isEmpty() || Integer.valueOf(content) <= 0) continue block27;
                    data[4] = content;
                    continue block27;
                }
                case "Memory": {
                    String content = field.getTextContent();
                    if (content == null || content.isEmpty() || !(Float.valueOf(content).floatValue() > 0.0f)) continue block27;
                    data[5] = content;
                    continue block27;
                }
                case "Disk": {
                    String content = field.getTextContent();
                    if (content == null || content.isEmpty() || !(Float.valueOf(content).floatValue() > 0.0f)) continue block27;
                    data[6] = content;
                    continue block27;
                }
                case "Status": {
                    data[7] = field.getTextContent();
                    continue block27;
                }
                case "Provider": {
                    data[8] = field.getTextContent();
                    continue block27;
                }
                case "Image": {
                    data[9] = field.getTextContent();
                    continue block27;
                }
                case "Actions": {
                    data[10] = MonitorXmlParser.parseActions((Node)field);
                    continue block27;
                }
                case "#text": {
                    continue block27;
                }
                default: {
                    LOGGER.error("Unrecognised field on ResourceNode " + field.getNodeName());
                }
            }
        }
        return data;
    }

    private static String parseActions(Node actions) {
        StringBuilder taskIds = new StringBuilder();
        NodeList nl = actions.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            String actionType;
            Node n = nl.item(i);
            if (!n.getNodeName().equals("Action")) continue;
            String[] actionInfo = n.getTextContent().split(" ");
            switch (actionType = actionInfo[2]) {
                case "Task": {
                    String taskId = actionInfo[3];
                    taskId = taskId.substring(0, taskId.length() - 1);
                    taskIds.append(taskId).append(" ");
                    continue block8;
                }
                case "Worker": {
                    String workerName = actionInfo[3];
                    workerName = workerName.substring(0, workerName.length() - 1);
                    taskIds.append("Starting worker ").append(workerName).append(" ");
                    continue block8;
                }
            }
        }
        return taskIds.toString();
    }

    private static List<String[]> parseCoresInfoNode(Node coresInfo) throws Exception {
        LOGGER.debug("Parsing cores nodes...");
        ArrayList<String[]> datas = new ArrayList<String[]>();
        NodeList nl = coresInfo.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals("Core")) continue;
            datas.addAll(MonitorXmlParser.parseCoreNode((Node)n));
        }
        return datas;
    }

    private static List<String[]> parseCoreNode(Node cores) throws Exception {
        String coreId = cores.getAttributes().getNamedItem("id").getTextContent();
        LOGGER.debug("  - Parsing coreId " + coreId);
        NodeList impls = cores.getChildNodes();
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (int i = 0; i < impls.getLength(); ++i) {
            Node impl = impls.item(i);
            if (!impl.getNodeName().equals("Impl")) continue;
            data.add(MonitorXmlParser.parseImplNode((Node)impl, (String)coreId));
        }
        return data;
    }

    private static String[] parseImplNode(Node impl, String coreId) {
        String implId = impl.getAttributes().getNamedItem("id").getTextContent();
        LOGGER.debug("     - Parsing implId " + implId);
        int maxParams = 7;
        String[] data = new String[7];
        for (int i = 0; i < data.length; ++i) {
            data[i] = "-";
        }
        data[0] = coreId;
        data[1] = implId;
        NodeList nl = impl.getChildNodes();
        block17: for (int i = 0; i < nl.getLength(); ++i) {
            Node field = nl.item(i);
            switch (field.getNodeName()) {
                case "Signature": {
                    data[2] = field.getTextContent();
                    continue block17;
                }
                case "MeanExecutionTime": {
                    Long ms = Long.valueOf(field.getTextContent());
                    data[3] = String.valueOf((float)ms.longValue() / 1000.0f);
                    continue block17;
                }
                case "MinExecutionTime": {
                    Long ms = Long.valueOf(field.getTextContent());
                    data[4] = String.valueOf((float)ms.longValue() / 1000.0f);
                    continue block17;
                }
                case "MaxExecutionTime": {
                    Long ms = Long.valueOf(field.getTextContent());
                    data[5] = String.valueOf((float)ms.longValue() / 1000.0f);
                    continue block17;
                }
                case "ExecutedCount": {
                    int execCount = Integer.valueOf(field.getTextContent());
                    if (execCount == 0) {
                        data[3] = "-";
                        data[4] = "-";
                        data[5] = "-";
                    }
                    data[6] = String.valueOf(execCount);
                    continue block17;
                }
                case "#text": {
                    continue block17;
                }
                default: {
                    LOGGER.error("Unrecognised field on ImplNode " + field.getNodeName());
                }
            }
        }
        return data;
    }

    private static HashMap<String, String> parseStatisticsNode(Node statistics) throws Exception {
        LOGGER.debug("  - Parsing statistics");
        NodeList statisticValues = statistics.getChildNodes();
        HashMap<String, String> data = new HashMap<String, String>();
        for (int i = 0; i < statisticValues.getLength(); ++i) {
            Node statisticNode = statisticValues.item(i);
            if (!statisticNode.getNodeName().equals("Statistic")) continue;
            String[] statisticKeyValue = MonitorXmlParser.parseStatisticNode((Node)statisticNode);
            data.put(statisticKeyValue[0], statisticKeyValue[1]);
        }
        return data;
    }

    private static String[] parseStatisticNode(Node statistic) {
        int maxParams = 2;
        String[] entry = new String[2];
        NodeList nl = statistic.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node field = nl.item(i);
            switch (field.getNodeName()) {
                case "Key": {
                    entry[0] = field.getTextContent();
                    continue block10;
                }
                case "Value": {
                    entry[1] = field.getTextContent();
                    continue block10;
                }
                case "#text": {
                    continue block10;
                }
                default: {
                    LOGGER.error("Unrecognised field on StatisticNode " + field.getNodeName());
                }
            }
        }
        return entry;
    }
}

