/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.StateData;
import java.util.Random;
import java.util.Vector;

public class StateData {
    private int timestamp;
    private float totalLoad;
    private int totalCoresRunning;
    private int totalCoresPending;
    private int totalCPU;
    private float totalMemory;
    private Vector<Float> meanTime;
    private Vector<Integer> runningCores;
    private Vector<Integer> pendingCores;
    private Vector<ResourceInfo> resourcesInformation;

    public StateData() {
        this.timestamp = 0;
        this.totalLoad = Float.valueOf(0.0f).floatValue();
        this.totalCoresRunning = 0;
        this.totalCoresPending = 0;
        this.totalCPU = 0;
        this.totalMemory = 0.0f;
        this.meanTime = new Vector();
        this.runningCores = new Vector();
        this.pendingCores = new Vector();
        this.resourcesInformation = new Vector();
    }

    public StateData(int timestamp) {
        this.timestamp = timestamp;
        this.totalLoad = Float.valueOf(0.0f).floatValue();
        this.totalCoresRunning = 0;
        this.totalCoresPending = 0;
        this.totalCPU = 0;
        this.totalMemory = 0.0f;
        this.meanTime = new Vector();
        this.runningCores = new Vector();
        this.pendingCores = new Vector();
        this.resourcesInformation = new Vector();
    }

    public StateData(StateData d) {
        this.timestamp = d.getTimestamp();
        this.totalLoad = d.getTotalLoad();
        this.totalCoresRunning = d.getTotalCoresRunning();
        this.totalCoresPending = d.getTotalCoresPending();
        this.totalCPU = d.getTotalCPU();
        this.totalMemory = d.getTotalMemory();
        this.meanTime = d.getMeanTime();
        this.runningCores = d.getRunningCores();
        this.pendingCores = d.getPendingCores();
        this.resourcesInformation = d.getResourcesInformation();
    }

    public void purgeValues() {
        this.totalLoad = Float.valueOf(0.0f).floatValue();
        this.totalCoresRunning = 0;
        this.totalCoresPending = 0;
        this.totalCPU = 0;
        this.totalMemory = 0.0f;
        this.meanTime = new Vector();
        this.runningCores = new Vector();
        this.pendingCores = new Vector();
        this.resourcesInformation = new Vector();
    }

    public void purgeLoadValues() {
        this.totalLoad = Float.valueOf(0.0f).floatValue();
        this.totalCoresRunning = 0;
        this.totalCoresPending = 0;
        this.meanTime = new Vector();
        this.runningCores = new Vector();
        this.pendingCores = new Vector();
    }

    public void purgeResourcesValues() {
        this.totalCPU = 0;
        this.totalMemory = 0.0f;
        this.resourcesInformation = new Vector();
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public float getTotalLoad() {
        return this.totalLoad;
    }

    public int getTotalCoresRunning() {
        return this.totalCoresRunning;
    }

    public int getTotalCoresPending() {
        return this.totalCoresPending;
    }

    public int getTotalCPU() {
        return this.totalCPU;
    }

    public float getTotalMemory() {
        return this.totalMemory;
    }

    public Vector<Float> getMeanTime() {
        return this.meanTime;
    }

    public Vector<Integer> getRunningCores() {
        return this.runningCores;
    }

    public Vector<Integer> getPendingCores() {
        return this.pendingCores;
    }

    public int getTotalResources() {
        return this.resourcesInformation.size();
    }

    public Vector<ResourceInfo> getResourcesInformation() {
        return this.resourcesInformation;
    }

    public int getTotalCPUConsumption() {
        float op1 = new Random().nextFloat() * Float.valueOf(this.totalCPU).floatValue();
        float op2 = Float.valueOf(this.totalCPU).floatValue();
        if (op2 == Float.valueOf(0.0f).floatValue()) {
            return 0;
        }
        float result = op1 / op2 * Float.valueOf(100.0f).floatValue();
        return (int)result;
    }

    public float getTotalMemoryConsumption() {
        float op1 = new Random().nextFloat() * this.totalMemory;
        if (this.totalMemory == Float.valueOf(0.0f).floatValue()) {
            return Float.valueOf(0.0f).floatValue();
        }
        float result = op1 / this.totalMemory * Float.valueOf(100.0f).floatValue();
        return result;
    }

    public Vector<String> getCPUConsumption() {
        Vector<String> result = new Vector<String>();
        for (ResourceInfo resource : this.resourcesInformation) {
            result.add(resource.getName() + ":" + String.valueOf(resource.getCPUConsumption()));
        }
        return result;
    }

    public Vector<String> getMemoryConsumption() {
        Vector<String> result = new Vector<String>();
        for (ResourceInfo resource : this.resourcesInformation) {
            result.add(resource.getName() + ":" + String.valueOf(resource.getMemoryConsumption()));
        }
        return result;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public void addCoreLoad(int id, float load) {
        if (id >= this.meanTime.size()) {
            this.meanTime.setSize(id + 1);
        }
        this.totalLoad += load;
        this.meanTime.set(id, Float.valueOf(load));
    }

    public void addResource(String resourceName, String type) {
        this.addResource(resourceName, type, 0, 0.0f);
    }

    public void addResource(String resourceName, String type, int cpus, float memory) {
        this.resourcesInformation.add(new ResourceInfo(this, resourceName, type, cpus, memory));
        this.totalCPU += cpus;
        this.totalMemory += memory;
    }

    public void removeResource(String resourceName) {
        boolean found = false;
        for (int i = 0; i < this.resourcesInformation.size() && !found; ++i) {
            if (!((ResourceInfo)this.resourcesInformation.get(i)).getName().equals(resourceName)) continue;
            this.resourcesInformation.remove(i);
            found = true;
        }
    }

    public void addCoreRunning(int coreId, int running) {
        this.totalCoresRunning += running;
        if (coreId >= this.runningCores.size()) {
            this.runningCores.setSize(coreId + 1);
        }
        this.runningCores.set(coreId, running);
    }

    public void addCorePending(int coreId, int newPending) {
        this.totalCoresPending += newPending;
        if (coreId >= this.pendingCores.size()) {
            this.pendingCores.setSize(coreId + 1);
        }
        this.pendingCores.set(coreId, newPending);
    }
}

