/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.monitoringparsers.ResourcesLogParser;
import es.bsc.compss.ui.Constants;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.util.Clients;

public class LoadChartViewModel {
    private static final Logger LOGGER = LogManager.getLogger((String)"compssMonitor.VM.LoadChartVM");
    private static final int TIMEOUT = 3000;
    private String divUuid;
    private String chartType;
    private boolean drawnNoConnection;
    private boolean dranChart;

    @Init
    public void init() {
        this.divUuid = new String("");
        this.chartType = new String("totalLoadChart");
        this.drawnNoConnection = false;
        this.dranChart = false;
    }

    @Command
    public void setDivUuid(@BindingParam(value="divuuid") String divuuid) {
        this.divUuid = divuuid;
    }

    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
        this.draw();
    }

    @Command
    public void update() {
        LOGGER.debug("Updating Load Chart View Model...");
        ResourcesLogParser.parse();
        this.draw();
        LOGGER.debug("Load Chart View Model updated");
    }

    @Command
    public void clear() {
        this.chartType = "totalLoadChart";
        ResourcesLogParser.clear();
        this.draw();
    }

    private void draw() {
        if (!this.divUuid.equals("")) {
            if (this.testInet()) {
                LOGGER.debug("Internet connection available. Generating google-chart");
                if (this.drawnNoConnection) {
                    Clients.evalJavaScript((String)("eraseNoConnection('" + this.divUuid + "');"));
                    this.drawnNoConnection = false;
                }
                this.dranChart = true;
                if (this.chartType.equals("totalLoadChart")) {
                    Clients.evalJavaScript((String)("drawTotalLoadChart('" + this.divUuid + "'," + ResourcesLogParser.getTotalLoad() + ");"));
                } else if (this.chartType.equals("loadPerCoreChart")) {
                    Clients.evalJavaScript((String)("drawLoadPerCoreChart('" + this.divUuid + "'," + ResourcesLogParser.getLoadPerCore() + ");"));
                } else if (this.chartType.equals("totalRunningChart")) {
                    Clients.evalJavaScript((String)("drawTotalCores('" + this.divUuid + "'," + ResourcesLogParser.getTotalRunningCores() + ");"));
                } else if (this.chartType.equals("runningPerCoreChart")) {
                    Clients.evalJavaScript((String)("drawCoresPerCoreChart('" + this.divUuid + "'," + ResourcesLogParser.getRunningCoresPerCore() + ");"));
                } else if (this.chartType.equals("totalPendingChart")) {
                    Clients.evalJavaScript((String)("drawTotalCores('" + this.divUuid + "'," + ResourcesLogParser.getTotalPendingCores() + ");"));
                } else if (this.chartType.equals("pendingPerCoreChart")) {
                    Clients.evalJavaScript((String)("drawCoresPerCoreChart('" + this.divUuid + "'," + ResourcesLogParser.getPendingCoresPerCore() + ");"));
                } else if (this.chartType.equals("totalResourcesStatusChart")) {
                    Clients.evalJavaScript((String)("drawTotalResourcesStatusChart('" + this.divUuid + "'," + ResourcesLogParser.getResourcesStatus() + ");"));
                } else {
                    LOGGER.warn("WARNING: Invalid chart type. Rendering empty graph");
                    Clients.evalJavaScript((String)("drawEmpty('" + this.divUuid + "');"));
                }
            } else {
                LOGGER.info("No internet connection. Rendering warning image");
                if (this.dranChart) {
                    Clients.evalJavaScript((String)("eraseChart('" + this.divUuid + "');"));
                    this.dranChart = false;
                }
                if (!this.drawnNoConnection) {
                    Clients.evalJavaScript((String)("drawNoConnection('" + this.divUuid + "','" + Constants.NO_CONNECTION_IMG_PATH + "');"));
                    this.drawnNoConnection = true;
                }
            }
        } else {
            LOGGER.debug("DivUUID not found. Cannot render chart.");
            this.drawnNoConnection = false;
            this.dranChart = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testInet() {
        Socket sock = new Socket();
        InetSocketAddress addr = new InetSocketAddress("google.com", 80);
        try {
            sock.connect(addr, 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                sock.close();
            }
            catch (IOException e) {
                LOGGER.warn("WARNING: Cannot close Inet connection");
            }
        }
    }
}

