/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.Constants;
import es.bsc.compss.ui.ExecutionInformationTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.zkoss.zul.ListModelList;

public class ExecutionInformationTask {
    private static final String STATE_IMAGES_RELATIVE_PATH = File.separator + "images" + File.separator + "state" + File.separator;
    private static final String STATE_IMAGES_EXTENSION = ".jpg";
    private static final String JOBS_RELATIVE_PATH = Constants.JOBS_SUB_PATH + "job";
    private String color;
    private String name;
    private String taskId;
    private String status;
    private ArrayList<Job> jobs;

    public ExecutionInformationTask(String name, String taskId) {
        this.setName(name);
        this.setTaskId(taskId);
        this.setTaskStatus("Creating");
        this.jobs = new ArrayList();
    }

    public String getStatus() {
        return this.status;
    }

    public void setTaskStatus(String status) {
        if (status.equals("Creating")) {
            this.status = status;
            this.setColor(STATE_IMAGES_RELATIVE_PATH + "yellow" + STATE_IMAGES_EXTENSION);
        } else if (status.equals("Running")) {
            this.status = status;
            this.setColor(STATE_IMAGES_RELATIVE_PATH + "blue" + STATE_IMAGES_EXTENSION);
        } else if (status.equals("Done")) {
            this.status = status;
            this.setColor(STATE_IMAGES_RELATIVE_PATH + "green" + STATE_IMAGES_EXTENSION);
        } else if (status.equals("Failed")) {
            this.status = status;
            this.setColor(STATE_IMAGES_RELATIVE_PATH + "red" + STATE_IMAGES_EXTENSION);
        } else {
            this.status = "Failed";
            this.setColor(STATE_IMAGES_RELATIVE_PATH + "red" + STATE_IMAGES_EXTENSION);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public List<Job> getJobs() {
        return new ListModelList((Collection)this.jobs);
    }

    public void addJob(String jobId, boolean resubmited) {
        Job job;
        if (!resubmited) {
            job = new Job(this, jobId);
        } else {
            String host = "";
            String executable = "";
            String args = "";
            boolean found = false;
            for (int i = this.jobs.size() - 1; i >= 0 && !found; --i) {
                Job jNormal = (Job)this.jobs.get(i);
                if (!jNormal.getId().equals(jobId)) continue;
                host = jNormal.getHost();
                executable = jNormal.getExecutable();
                args = jNormal.getArguments();
                found = true;
            }
            String newJobId = jobId + "R";
            job = new Job(this, newJobId, resubmited, host, executable, args);
        }
        if (!this.jobs.contains(job)) {
            this.jobs.add(job);
        }
    }

    public void setJobStatus(String status) {
        ((Job)this.jobs.get(this.jobs.size() - 1)).setStatus(status);
    }

    public void setJobHost(String jobId, boolean resubmited, String host) {
        if (resubmited) {
            jobId = jobId + "R";
        }
        for (Job j : this.jobs) {
            if (!j.getId().equals(jobId)) continue;
            j.setHost(host);
        }
    }

    static /* synthetic */ String access$000() {
        return STATE_IMAGES_RELATIVE_PATH;
    }

    static /* synthetic */ String access$100() {
        return JOBS_RELATIVE_PATH;
    }
}

