/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;

public class RuntimeLogViewModel {
    private static final Logger LOGGER = LogManager.getLogger((String)"compssMonitor.VM.RuntimeLogVM");
    private static final String RUNTIME_LOG_NOT_SELECTED = "Application's runtime.log file not selected";
    private String runtimeLogPath;
    private int lastParsedLine;
    private String content;
    private String filter;

    @Init
    public void init() {
        this.runtimeLogPath = new String("");
        this.lastParsedLine = 0;
        this.content = new String(RUNTIME_LOG_NOT_SELECTED);
        this.filter = new String("");
    }

    public String getRuntimeLog() {
        return this.content;
    }

    public String getFilter() {
        return this.filter;
    }

    @Command
    @NotifyChange(value={"runtimeLog", "filter"})
    public void setFilter(@BindingParam(value="filter") String filter) {
        this.filter = filter;
        this.lastParsedLine = 0;
        this.content = "";
    }

    @Command
    @NotifyChange(value={"runtimeLog", "filter"})
    public void update() {
        if (!Properties.getBasePath().equals("")) {
            String newPath = Properties.getBasePath() + File.separator + "runtime.log";
            if (!this.runtimeLogPath.equals(newPath)) {
                this.runtimeLogPath = newPath;
                this.lastParsedLine = 0;
                this.content = "";
                this.filter = "";
            }
            LOGGER.debug("Parsing runtime.log file...");
            try (BufferedReader br = new BufferedReader(new FileReader(this.runtimeLogPath));){
                StringBuilder sb = new StringBuilder("");
                String line = br.readLine();
                int i = 0;
                while (line != null) {
                    if (i > this.lastParsedLine && line.contains(this.filter)) {
                        sb.append(line).append("\n");
                    }
                    ++i;
                    line = br.readLine();
                }
                this.content = this.content + sb.toString();
                this.lastParsedLine = i - 1;
            }
            catch (IOException ioe) {
                LOGGER.error("Cannot parse runtime.log file: " + this.runtimeLogPath, (Throwable)ioe);
            }
        } else {
            this.clear();
        }
    }

    @Command
    @NotifyChange(value={"runtimeLog"})
    public void clear() {
        this.runtimeLogPath = "";
        this.lastParsedLine = 0;
        this.content = RUNTIME_LOG_NOT_SELECTED;
        this.filter = "";
    }
}

