/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.ui;

import es.bsc.compss.ui.ConfigParam;
import es.bsc.compss.ui.ConfigurationViewModel;
import es.bsc.compss.ui.Properties;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zul.ListModelList;

public class ConfigurationViewModel {
    private static final Logger LOGGER = LogManager.getLogger((String)"compssMonitor.VM.ConfigurationVM");
    private List<ConfigParam> configurations;

    @Init
    public void init() {
        LOGGER.debug("Loading configurable parameters...");
        this.configurations = new LinkedList();
        RefreshTime rt = new RefreshTime(this, "Refresh Time (s)", String.valueOf(Properties.getRefreshTime() / 1000), false);
        this.configurations.add(rt);
        SortApplications sa = new SortApplications(this, "Sort applications (true/false)", String.valueOf(Properties.isSortApplications()), false);
        this.configurations.add(sa);
        LoadGraphXScale lgxs = new LoadGraphXScale(this, "Load Graph's X-Scale factor (int >= 1)", String.valueOf(Properties.getxScaleForLoadGraph()), false);
        this.configurations.add(lgxs);
        LOGGER.debug("Configurable parameters loaded");
    }

    public List<ConfigParam> getConfigurations() {
        return new ListModelList((Collection)this.configurations);
    }

    @Command
    public void changeEditableStatus(@BindingParam(value="ConfigParam") ConfigParam cp) {
        cp.setEditingStatus(!cp.getEditingStatus());
        this.refreshRowTemplate(cp);
    }

    @Command
    public void confirm(@BindingParam(value="ConfigParam") ConfigParam cp) {
        cp.update();
        this.changeEditableStatus(cp);
        this.refreshRowTemplate(cp);
    }

    public void refreshRowTemplate(ConfigParam cp) {
        BindUtils.postNotifyChange(null, null, (Object)cp, (String)"editingStatus");
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

