/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.project;

import integratedtoolkit.types.project.ProjectFile;
import integratedtoolkit.types.project.exceptions.InvalidElementException;
import integratedtoolkit.types.project.exceptions.ProjectFileValidationException;
import integratedtoolkit.types.project.jaxb.AdaptorType;
import integratedtoolkit.types.project.jaxb.AdaptorsListType;
import integratedtoolkit.types.project.jaxb.ApplicationType;
import integratedtoolkit.types.project.jaxb.AttachedDiskType;
import integratedtoolkit.types.project.jaxb.AttachedDisksListType;
import integratedtoolkit.types.project.jaxb.BatchType;
import integratedtoolkit.types.project.jaxb.CloudPropertiesType;
import integratedtoolkit.types.project.jaxb.CloudPropertyType;
import integratedtoolkit.types.project.jaxb.CloudProviderType;
import integratedtoolkit.types.project.jaxb.CloudType;
import integratedtoolkit.types.project.jaxb.ComputeNodeType;
import integratedtoolkit.types.project.jaxb.DataNodeType;
import integratedtoolkit.types.project.jaxb.ExternalAdaptorProperties;
import integratedtoolkit.types.project.jaxb.ImageType;
import integratedtoolkit.types.project.jaxb.ImagesType;
import integratedtoolkit.types.project.jaxb.InstanceTypeType;
import integratedtoolkit.types.project.jaxb.InstanceTypesType;
import integratedtoolkit.types.project.jaxb.InteractiveType;
import integratedtoolkit.types.project.jaxb.MasterNodeType;
import integratedtoolkit.types.project.jaxb.NIOAdaptorProperties;
import integratedtoolkit.types.project.jaxb.PackageType;
import integratedtoolkit.types.project.jaxb.PriceType;
import integratedtoolkit.types.project.jaxb.ServiceType;
import integratedtoolkit.types.project.jaxb.SoftwareListType;
import integratedtoolkit.types.project.jaxb.SubmissionSystemType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.Logger;

public class Validator {
    private ProjectFile pf;
    private Logger logger;

    public Validator(ProjectFile pf, Logger logger) {
        this.logger = logger;
        this.pf = pf;
    }

    public void validate() throws ProjectFileValidationException {
        block12: {
            this.logger.info("Validating <Project> tag");
            List<Object> objList = this.pf.getProject().getMasterNodeOrComputeNodeOrDataNode();
            if (objList != null) {
                boolean masterNodeTagFound = false;
                boolean minimumUsableElementFound = false;
                for (Object obj : this.pf.getProject().getMasterNodeOrComputeNodeOrDataNode()) {
                    if (obj instanceof MasterNodeType) {
                        if (masterNodeTagFound) {
                            throw new InvalidElementException("Project", "Attribute MasterNode", "Appears more than once");
                        }
                        masterNodeTagFound = true;
                        this.validateMasterNode((MasterNodeType)obj);
                        continue;
                    }
                    if (obj instanceof ComputeNodeType) {
                        minimumUsableElementFound = true;
                        this.validateComputeNode((ComputeNodeType)obj);
                        continue;
                    }
                    if (obj instanceof DataNodeType) {
                        this.validateDataNode((DataNodeType)obj);
                        continue;
                    }
                    if (obj instanceof ServiceType) {
                        minimumUsableElementFound = true;
                        this.validateService((ServiceType)obj);
                        continue;
                    }
                    if (obj instanceof CloudType) {
                        minimumUsableElementFound = true;
                        this.validateCloud((CloudType)obj);
                        continue;
                    }
                    throw new InvalidElementException("Project", "Attribute" + obj.getClass(), "Incorrect attribute");
                }
                if (!masterNodeTagFound) {
                    throw new InvalidElementException("Project", "Attribute MasterNode", "Doesn't appear");
                }
                if (!minimumUsableElementFound) {
                    throw new InvalidElementException("Resources", "", "Any computational (computeNode, service or cloud) resources found");
                }
                break block12;
            }
            throw new ProjectFileValidationException("Empty project file");
        }
        this.logger.info("Validation finished");
    }

    public void validateMasterNode(MasterNodeType mn) throws InvalidElementException {
        if (mn != null) {
            List<Object> innerElements = mn.getSharedDisksOrPrice();
            if (innerElements != null) {
                boolean sharedDisksTagFound = false;
                boolean priceTagFound = false;
                for (Object obj : innerElements) {
                    if (obj instanceof AttachedDisksListType) {
                        if (sharedDisksTagFound) {
                            throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Appears more than once");
                        }
                        sharedDisksTagFound = true;
                        this.validateAttachedDisksList((AttachedDisksListType)obj);
                        continue;
                    }
                    if (obj instanceof PriceType) {
                        if (priceTagFound) {
                            throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Appears more than once");
                        }
                        priceTagFound = true;
                        this.validatePrice((PriceType)obj);
                        continue;
                    }
                    throw new InvalidElementException("MasterNode", "Attribute " + obj.getClass(), "Incorrect attribute");
                }
            }
        } else {
            throw new InvalidElementException("Project", "Attribute MasterNode", "is null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateComputeNode(ComputeNodeType cn) throws InvalidElementException {
        if (cn == null) throw new InvalidElementException("Project", "Attribute ComputeNode", "is null");
        List<JAXBElement<?>> innerElements = cn.getInstallDirOrWorkingDirOrUser();
        if (innerElements == null) throw new InvalidElementException("Project", "Attribute ComputeNode " + cn.getName(), "has no inner fields");
        boolean installDirTagFound = false;
        boolean workingDirTagFound = false;
        boolean userTagFound = false;
        boolean appTagFound = false;
        boolean lotTagFound = false;
        boolean adaptorsTagFound = false;
        for (JAXBElement<?> element : innerElements) {
            if (element.getName().equals(new QName("InstallDir"))) {
                if (installDirTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                installDirTagFound = true;
                this.validateInstallDir((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("WorkingDir"))) {
                if (workingDirTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                workingDirTagFound = true;
                this.validateWorkingDir((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("User"))) {
                if (userTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                userTagFound = true;
                this.validateUser((String)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("Application"))) {
                if (appTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                appTagFound = true;
                this.validateApplication((ApplicationType)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("LimitOfTasks"))) {
                if (lotTagFound) {
                    throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
                }
                lotTagFound = true;
                this.validateLimitOfTasks((Integer)element.getValue());
                continue;
            }
            if (!element.getName().equals(new QName("Adaptors"))) throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Incorrect attribute");
            if (adaptorsTagFound) {
                throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute " + element.getName(), "Appears more than once");
            }
            adaptorsTagFound = true;
            this.validateAdaptors((AdaptorsListType)element.getValue());
        }
        if (!installDirTagFound) {
            throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute InstallDir", "Doesn't appear");
        }
        if (workingDirTagFound) return;
        throw new InvalidElementException("ComputeNode " + cn.getName(), "Attribute WorkingDir", "Doesn't appear");
    }

    public void validateDataNode(DataNodeType dn) throws InvalidElementException {
        if (dn != null) {
            List<AdaptorsListType> innerElements = dn.getAdaptors();
            if (innerElements != null) {
                boolean adaptorsTagFound = false;
                for (AdaptorsListType adaptors : innerElements) {
                    if (adaptorsTagFound) {
                        throw new InvalidElementException("ComputeNode " + dn.getName(), "Attribute Adaptors", "Appears more than once");
                    }
                    adaptorsTagFound = true;
                    this.validateAdaptors(adaptors);
                }
            }
        } else {
            throw new InvalidElementException("Project", "Attribute DataNode", "is null");
        }
    }

    public void validateService(ServiceType s) throws InvalidElementException {
        if (s == null) {
            throw new InvalidElementException("Project", "Attribute Service", "is null");
        }
        this.validateLimitOfTasks(s.getLimitOfTasks());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateCloud(CloudType c) throws InvalidElementException {
        if (c == null) throw new InvalidElementException("Project", "Attribute ComputeNode", "is null");
        List<JAXBElement<?>> innerElements = c.getCloudProviderOrInitialVMsOrMinimumVMs();
        if (innerElements == null) throw new InvalidElementException("Project", "Attribute Cloud", "has no inner fields");
        boolean cpTagFound = false;
        boolean initialVMsTagFound = false;
        boolean minVMsTagFound = false;
        boolean maxVMsTagFound = false;
        JAXBElement<?> initialVMs = null;
        int minVMs = -1;
        int maxVMs = -1;
        for (JAXBElement<?> element : innerElements) {
            if (element.getName().equals(new QName("CloudProvider"))) {
                cpTagFound = true;
                this.validateCloudProvider((CloudProviderType)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("InitialVMs"))) {
                if (initialVMsTagFound) {
                    throw new InvalidElementException("Cloud", "Attribute " + element.getName(), "Appears more than once");
                }
                initialVMsTagFound = true;
                initialVMs = element;
                this.validateInitialVMs((Integer)element.getValue());
                continue;
            }
            if (element.getName().equals(new QName("MinimumVMs"))) {
                if (minVMsTagFound) {
                    throw new InvalidElementException("Cloud", "Attribute " + element.getName(), "Appears more than once");
                }
                minVMsTagFound = true;
                minVMs = (Integer)element.getValue();
                this.validateMinimumVMs((Integer)element.getValue());
                continue;
            }
            if (!element.getName().equals(new QName("MaximumVMs"))) throw new InvalidElementException("Cloud", "Attribute " + element.getName(), "Incorrect attribute");
            if (maxVMsTagFound) {
                throw new InvalidElementException("Cloud", "Attribute " + element.getName(), "Appears more than once");
            }
            maxVMsTagFound = true;
            maxVMs = (Integer)element.getValue();
            this.validateMaximumVMs((Integer)element.getValue());
        }
        if (!cpTagFound) {
            throw new InvalidElementException("Cloud", "Attribute CloudProvider", "Doesn't appear");
        }
        this.checkInitialMinMaxVMsCoherence(initialVMs, minVMs, maxVMs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateCloudProvider(CloudProviderType cp) throws InvalidElementException {
        if (cp == null) throw new InvalidElementException("Cloud", "Attribute CloudProvider", "is null");
        List<Object> innerElements = cp.getImagesOrInstanceTypesOrLimitOfVMs();
        if (innerElements == null) throw new InvalidElementException("Cloud", "Attribute CloudProvider", "has no inner fields");
        boolean imagesTagFound = false;
        boolean instancesTagFound = false;
        boolean lovTagFound = false;
        boolean propertiesTagFound = false;
        for (Object obj : innerElements) {
            if (obj instanceof ImagesType) {
                if (imagesTagFound) {
                    throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Appears more than once");
                }
                imagesTagFound = true;
                this.validateImages((ImagesType)obj);
                continue;
            }
            if (obj instanceof InstanceTypesType) {
                if (instancesTagFound) {
                    throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Appears more than once");
                }
                instancesTagFound = true;
                this.validateInstanceTypes((InstanceTypesType)obj);
                continue;
            }
            if (obj instanceof Integer) {
                if (lovTagFound) {
                    throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Appears more than once");
                }
                lovTagFound = true;
                this.validateLimitOfVMs((Integer)obj);
                continue;
            }
            if (!(obj instanceof CloudPropertiesType)) throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Incorrect attribute");
            if (propertiesTagFound) {
                throw new InvalidElementException("CloudProvider", "Attribute " + obj.getClass(), "Appears more than once");
            }
            propertiesTagFound = true;
            this.validateCloudProperties((CloudPropertiesType)obj);
        }
        if (!imagesTagFound) {
            throw new InvalidElementException("CloudProvider", "Attribute Images", "Doesn't appear");
        }
        if (instancesTagFound) return;
        throw new InvalidElementException("CloudProvider", "Attribute Instances", "Doesn't appear");
    }

    private void validateAttachedDisksList(AttachedDisksListType disks) throws InvalidElementException {
        List<AttachedDiskType> innerElements = disks.getAttachedDisk();
        if (innerElements != null) {
            for (AttachedDiskType disk : innerElements) {
                this.validateAttachedDisk(disk);
            }
        } else {
            throw new InvalidElementException("AttachedDisksList", "", "Content is empty");
        }
    }

    private void validateAttachedDisk(AttachedDiskType disk) throws InvalidElementException {
        if (disk.getName() == null || disk.getName().isEmpty()) {
            throw new InvalidElementException("AttachedDisk ", "Attribute Name", "Doesn't appear");
        }
        if (disk.getMountPoint() == null || disk.getMountPoint().isEmpty()) {
            throw new InvalidElementException("AttachedDisk" + disk.getName(), "Attribute MountPoint", "Doesn't appear");
        }
    }

    private void validatePrice(PriceType price) throws InvalidElementException {
        if (price.getTimeUnit() <= 0) {
            throw new InvalidElementException("Price", "Attribute TimeUnit", "Invalid value");
        }
        if (price.getPricePerUnit() < 0.0f) {
            throw new InvalidElementException("Price", "Attribute PricePerUnit", "Invalid value");
        }
    }

    private void validateInstallDir(String installDir) throws InvalidElementException {
        if (installDir == null) {
            throw new InvalidElementException("ComputeNode", "Attribute installDir", "Is null");
        }
        if (installDir.isEmpty()) {
            throw new InvalidElementException("ComputeNode", "Attribute installDir", "Is empty");
        }
    }

    private void validateWorkingDir(String workingDir) throws InvalidElementException {
        if (workingDir == null) {
            throw new InvalidElementException("ComputeNode", "Attribute workingDir", "Is null");
        }
        if (workingDir.isEmpty()) {
            throw new InvalidElementException("ComputeNode", "Attribute workingDir", "Is empty");
        }
    }

    private void validateApplication(ApplicationType app) throws InvalidElementException {
    }

    private void validateLimitOfTasks(Integer lot) throws InvalidElementException {
        if (lot != null) {
            if (lot < 0) {
                throw new InvalidElementException("ComputeNode", "Attribute LimitOfTasks", "has an invalid value");
            }
            if (lot == 0) {
                this.logger.warn("ComputeNode has LimitOfTasks = 0, no task will be scheduled to this resource");
            }
        }
    }

    private void validateInitialVMs(Integer initialVMs) throws InvalidElementException {
        if (initialVMs == null) {
            throw new InvalidElementException("Cloud", "Attribute initialVMs", "Is null");
        }
        if (initialVMs < 0) {
            throw new InvalidElementException("ComputeNode", "Attribute initialVMs", "has an invalid value");
        }
    }

    private void validateMinimumVMs(Integer minimumVMs) throws InvalidElementException {
        if (minimumVMs == null) {
            throw new InvalidElementException("Cloud", "Attribute minimumVMs", "Is null");
        }
        if (minimumVMs < 0) {
            throw new InvalidElementException("ComputeNode", "Attribute minimumVMs", "has an invalid value");
        }
    }

    private void validateMaximumVMs(Integer maximumVMs) throws InvalidElementException {
        if (maximumVMs == null) {
            throw new InvalidElementException("Cloud", "Attribute maximumVMs", "Is null");
        }
        if (maximumVMs < 0) {
            throw new InvalidElementException("ComputeNode", "Attribute maximumVMs", "has an invalid value");
        }
    }

    private void checkInitialMinMaxVMsCoherence(JAXBElement<Integer> initialVMs, int minVMs, int maxVMs) throws InvalidElementException {
        int initial = -1;
        if (initialVMs != null) {
            initial = (Integer)initialVMs.getValue();
        }
        if (minVMs >= 0 && maxVMs >= 0 && minVMs > maxVMs) {
            throw new InvalidElementException("Project", "Attributes minVMs/maxVMs", "define empty range");
        }
        if (minVMs >= 0 && initial >= 0 && initial < minVMs) {
            initialVMs.setValue((Object)minVMs);
            this.logger.warn("InitialVMs value was " + initial + " but it is set to " + minVMs + " because it is the minimumVMs value");
        }
        if (maxVMs >= 0 && initial >= 0 && initial > maxVMs) {
            initialVMs.setValue((Object)maxVMs);
            this.logger.warn("InitialVMs value was " + initial + " but it is set to " + maxVMs + " because it is the maximumVMs value");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAdaptors(AdaptorsListType adaptors) throws InvalidElementException {
        if (adaptors == null) throw new InvalidElementException("Adaptors", "", "Tag not present");
        List<AdaptorType> adaptors_list = adaptors.getAdaptor();
        if (adaptors_list == null) throw new InvalidElementException("Adaptors", "", "Content is empty");
        for (AdaptorType adaptor : adaptors_list) {
            this.validateAdaptor(adaptor);
        }
    }

    private void validateAdaptor(AdaptorType adaptor) throws InvalidElementException {
        List<JAXBElement<?>> innerElements = adaptor.getSubmissionSystemOrPortsOrBrokerAdaptor();
        if (innerElements != null) {
            boolean subsysTagFound = false;
            boolean portsTagFound = false;
            boolean brokerAdaptorTagFound = false;
            boolean propertiesTagFound = false;
            boolean userTagFound = false;
            for (JAXBElement<?> obj : innerElements) {
                if (obj.getName().equals(new QName("SubmissionSystem"))) {
                    if (subsysTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    subsysTagFound = true;
                    this.validateSubmissionSystem((SubmissionSystemType)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("Ports"))) {
                    if (portsTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    if (brokerAdaptorTagFound || propertiesTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "An adaptor property (GAT or External) was already defined");
                    }
                    portsTagFound = true;
                    this.validateNIOAdaptorProperties((NIOAdaptorProperties)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("BrokerAdaptor"))) {
                    if (brokerAdaptorTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    if (portsTagFound || propertiesTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "An adaptor property (NIO or External) was already defined");
                    }
                    brokerAdaptorTagFound = true;
                    this.validateGATAdaptorProperties((String)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("Properties"))) {
                    if (propertiesTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    if (portsTagFound || brokerAdaptorTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "An adaptor property (NIO or GAT) was already defined");
                    }
                    propertiesTagFound = true;
                    this.validateExternalAdaptorProperties((ExternalAdaptorProperties)obj.getValue());
                    continue;
                }
                if (obj.getName().equals(new QName("User"))) {
                    if (userTagFound) {
                        throw new InvalidElementException("Adaptor", "Attribute " + obj.getName(), "Appears more than once");
                    }
                    userTagFound = true;
                    continue;
                }
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute" + obj.getName(), "Incorrect attribute");
            }
            if (!subsysTagFound) {
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute SubmissionSystem", "Doesn't appear");
            }
            if (!(portsTagFound || brokerAdaptorTagFound || propertiesTagFound)) {
                throw new InvalidElementException("Adaptor " + adaptor.getName(), "Attribute Adaptor properties (NIO, GAT or External)", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Adaptor", "", "Content is empty");
        }
    }

    private void validateSubmissionSystem(SubmissionSystemType subSys) throws InvalidElementException {
        List<Object> innerElements = subSys.getBatchOrInteractive();
        if (innerElements != null) {
            boolean batchTagFound = false;
            boolean interactiveTagFound = false;
            for (Object obj : innerElements) {
                if (obj instanceof BatchType) {
                    if (batchTagFound) {
                        throw new InvalidElementException("SubmissionSystem", "Attribute Batch", "Appears more than once");
                    }
                    batchTagFound = true;
                    this.validateBatch((BatchType)obj);
                    continue;
                }
                if (obj instanceof InteractiveType) {
                    if (interactiveTagFound) {
                        throw new InvalidElementException("SubmissionSystem", "Attribute Interactive", "Appears more than once");
                    }
                    interactiveTagFound = true;
                    this.validateInteractive((InteractiveType)obj);
                    continue;
                }
                throw new InvalidElementException("SubmissionSystem", "Attribute " + obj.getClass(), "Invalid type");
            }
            if (!batchTagFound && !interactiveTagFound) {
                throw new InvalidElementException("SubmissionSystem", "Interactive/Batch", "At least 1 submission system must be defined");
            }
        } else {
            throw new InvalidElementException("SubmissionSystem", "", "Content is empty");
        }
    }

    private void validateBatch(BatchType batch) throws InvalidElementException {
    }

    private void validateInteractive(InteractiveType interactive) throws InvalidElementException {
    }

    private void validateNIOAdaptorProperties(NIOAdaptorProperties props) throws InvalidElementException {
        if (props.getMaxPort() < 0) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MaxPort", "Invalid value");
        }
        if (props.getMinPort() < 0) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MinPort", "Invalid value");
        }
        if (props.getMaxPort() <= props.getMinPort()) {
            throw new InvalidElementException("Properties of NIO Adaptor", "Attribute MinPort-MaxPort", "Invalid range");
        }
    }

    private void validateGATAdaptorProperties(String broker) throws InvalidElementException {
        if (broker == null || broker.isEmpty()) {
            throw new InvalidElementException("GATAdaptor", "Attribute BrokerAdaptor", "Doesn't appear");
        }
    }

    private void validateExternalAdaptorProperties(ExternalAdaptorProperties props) throws InvalidElementException {
    }

    private void validateImages(ImagesType images) throws InvalidElementException {
        ArrayList<String> imageNames = new ArrayList<String>();
        List<ImageType> images_list = images.getImage();
        if (images_list != null) {
            for (ImageType im : images_list) {
                if (imageNames.contains(im.getName())) {
                    throw new InvalidElementException("Images", "Attribute Image " + im.getName(), "Name already used");
                }
                imageNames.add(im.getName());
                this.validateImage(im);
            }
        } else {
            throw new InvalidElementException("Images", "", "Content is empty");
        }
    }

    private void validateImage(ImageType image) throws InvalidElementException {
        List<JAXBElement<?>> innerElements = image.getInstallDirOrWorkingDirOrUser();
        if (innerElements != null) {
            boolean installDirTagFound = false;
            boolean workingDirTagFound = false;
            boolean userTagFound = false;
            boolean appTagFound = false;
            boolean lotTagFound = false;
            boolean adaptorsTagFound = false;
            for (JAXBElement<?> element : innerElements) {
                if (element.getName().equals(new QName("InstallDir"))) {
                    if (installDirTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    installDirTagFound = true;
                    this.validateInstallDir((String)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("WorkingDir"))) {
                    if (workingDirTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    workingDirTagFound = true;
                    this.validateWorkingDir((String)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("User"))) {
                    if (userTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    userTagFound = true;
                    this.validateUser((String)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("Application"))) {
                    if (appTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    appTagFound = true;
                    this.validateApplication((ApplicationType)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("LimitOfTasks"))) {
                    if (lotTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    lotTagFound = true;
                    this.validateLimitOfTasks((Integer)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("Package"))) {
                    this.validatePackage((PackageType)element.getValue());
                    continue;
                }
                if (element.getName().equals(new QName("Adaptors"))) {
                    if (adaptorsTagFound) {
                        throw new InvalidElementException("Image", "Attribute " + element.getName(), "Appears more than once");
                    }
                    adaptorsTagFound = true;
                    this.validateAdaptors((AdaptorsListType)element.getValue());
                    continue;
                }
                throw new InvalidElementException("Image", "Attribute " + element.getName(), "Incorrect attribute");
            }
            if (!installDirTagFound) {
                throw new InvalidElementException("Image ", "Attribute installDir", "Doesn't appear");
            }
            if (!workingDirTagFound) {
                throw new InvalidElementException("Image ", "Attribute workingDir", "Doesn't appear");
            }
        } else {
            throw new InvalidElementException("Image", "", "Content is empty");
        }
    }

    private void validateUser(String username) throws InvalidElementException {
    }

    private void validatePackage(PackageType pack) throws InvalidElementException {
        if (pack != null) {
            if (pack.getSource() == null) {
                throw new InvalidElementException("Package", "Attribute source", "Is null");
            }
            if (pack.getSource().isEmpty()) {
                throw new InvalidElementException("Package", "Attribute source", "Is empty");
            }
            if (pack.getTarget() == null) {
                throw new InvalidElementException("Package", "Attribute source", "Is null");
            }
            if (pack.getTarget().isEmpty()) {
                throw new InvalidElementException("Package", "Attribute source", "Is empty");
            }
            if (pack.getIncludedSoftware() != null) {
                this.validateSoftwareList(pack.getIncludedSoftware());
            }
        } else {
            throw new InvalidElementException("Image", "Attribute Package", "is null");
        }
    }

    private void validateSoftwareList(SoftwareListType softwares) throws InvalidElementException {
        if (softwares != null) {
            List<String> innerElements = softwares.getApplication();
            for (String app : innerElements) {
                this.validateApplication(app);
            }
        } else {
            throw new InvalidElementException("Package", "Attribute SoftwareList", "is null");
        }
    }

    private void validateApplication(String app) throws InvalidElementException {
    }

    private void validateInstanceTypes(InstanceTypesType instances) throws InvalidElementException {
        ArrayList<String> instanceNames = new ArrayList<String>();
        List<InstanceTypeType> instances_list = instances.getInstanceType();
        if (instances_list != null) {
            for (InstanceTypeType i : instances.getInstanceType()) {
                if (instanceNames.contains(i.getName())) {
                    throw new InvalidElementException("Instances", "Attribute Instance " + i.getName(), "Name already used");
                }
                instanceNames.add(i.getName());
                this.validateInstance(i);
            }
        } else {
            throw new InvalidElementException("InstanceTypes", "", "Content is empty");
        }
    }

    private void validateInstance(InstanceTypeType instance) throws InvalidElementException {
    }

    private void validateCloudProperties(CloudPropertiesType properties) throws InvalidElementException {
        if (properties != null) {
            List<CloudPropertyType> innerElements = properties.getProperty();
            if (innerElements != null) {
                for (CloudPropertyType prop : innerElements) {
                    this.validateCloudProperty(prop);
                }
            }
        } else {
            throw new InvalidElementException("Cloud", "Attribute Properties", "is null");
        }
    }

    private void validateCloudProperty(CloudPropertyType prop) throws InvalidElementException {
        if (prop != null) {
            if (prop.getName() == null) {
                throw new InvalidElementException("Package", "Attribute source", "Is null");
            }
            if (prop.getName().isEmpty()) {
                throw new InvalidElementException("Package", "Attribute source", "Is empty");
            }
            if (prop.getValue() == null) {
                throw new InvalidElementException("Package", "Attribute source", "Is null");
            }
            if (prop.getValue().isEmpty()) {
                // empty if block
            }
        } else {
            throw new InvalidElementException("Cloud Properties", "Attribute Property", "is null");
        }
    }

    private void validateLimitOfVMs(Integer lovms) throws InvalidElementException {
        if (lovms == null) {
            throw new InvalidElementException("CloudProvider", "Attribute LimitOfVMs", "Is null");
        }
        if (lovms < 0) {
            throw new InvalidElementException("CloudProvider", "Attribute LimitOfVMs", "has an invalid value");
        }
        if (lovms == 0) {
            this.logger.warn("CloudProvider has LimitOfVMs = 0, no task will be scheduled to this resource");
        }
    }
}

