/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.ResourceUser;
import es.bsc.compss.connectors.ConnectorException;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.NoResourceAvailableException;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.project.exceptions.ProjectFileValidationException;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.MethodWorker;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.types.resources.exceptions.ResourcesFileValidationException;
import es.bsc.compss.types.resources.updates.PendingReduction;
import es.bsc.compss.types.resources.updates.PerformedIncrease;
import es.bsc.compss.util.CloudManager;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceLoader;
import es.bsc.compss.util.WorkerPool;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManager {
    private static final String RESOURCES_XML = System.getProperty("compss.resources.file");
    private static final String RESOURCES_XSD = System.getProperty("compss.resources.schema");
    private static final String PROJECT_XML = System.getProperty("compss.project.file");
    private static final String PROJECT_XSD = System.getProperty("compss.project.schema");
    private static final String ERROR_RESOURCES_XML = "ERROR: Cannot parse resources.xml file";
    private static final String ERROR_PROJECT_XML = "ERROR: Cannot parse project.xml file";
    private static final String ERROR_NO_RES = "ERROR: No computational resource available (ComputeNode, service or CloudProvider)";
    protected static final String ERROR_UNKNOWN_HOST = "ERROR: Cannot determine the IP address of the local host";
    private static final String DEL_VM_ERR = "ERROR: Canot delete VMs";
    private static CloudManager cloudManager;
    private static WorkerPool pool;
    private static int[] poolCoreMaxConcurrentTasks;
    private static ResourceUser resourceUser;
    private static final Logger RESOURCES_LOGGER;
    private static final Logger RUNTIME_LOGGER;

    public static void load(ResourceUser resUser) {
        resourceUser = resUser;
        pool = new WorkerPool();
        poolCoreMaxConcurrentTasks = new int[CoreManager.getCoreCount()];
        cloudManager = new CloudManager();
        try {
            ResourceLoader.load(RESOURCES_XML, RESOURCES_XSD, PROJECT_XML, PROJECT_XSD);
        }
        catch (ResourcesFileValidationException e) {
            ErrorManager.fatal(ERROR_RESOURCES_XML, e);
        }
        catch (ProjectFileValidationException e) {
            ErrorManager.fatal(ERROR_PROJECT_XML, e);
        }
        catch (NoResourceAvailableException e) {
            ErrorManager.fatal(ERROR_NO_RES, e);
        }
    }

    public static void clear(ResourceUser resUser) {
        resourceUser = resUser;
        pool = new WorkerPool();
        poolCoreMaxConcurrentTasks = new int[CoreManager.getCoreCount()];
        cloudManager = new CloudManager();
    }

    public static void updateMasterConfiguration(Map<String, String> sharedDisks) {
        Comm.getAppHost().updateSharedDisk(sharedDisks);
        try {
            Comm.getAppHost().start();
        }
        catch (InitNodeException e) {
            ErrorManager.error("Error updating master configuration", e);
        }
    }

    public static void stopNodes() {
        RESOURCES_LOGGER.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        RESOURCES_LOGGER.info("INFO_MSG = [Stopping all workers]");
        RUNTIME_LOGGER.info("Stopping all workers");
        if (cloudManager.isUseCloud()) {
            RESOURCES_LOGGER.debug("DEBUG_MSG = [Terminating cloud instances...]");
            try {
                cloudManager.terminateALL();
                RESOURCES_LOGGER.info("TOTAL_EXEC_COST = " + cloudManager.getTotalCost());
            }
            catch (Exception e) {
                RESOURCES_LOGGER.error("Task Scheduler: ERROR: Canot delete VMs", (Throwable)e);
            }
            RESOURCES_LOGGER.info("INFO_MSG = [Cloud instances terminated]");
        }
        if (pool != null && !pool.getStaticResources().isEmpty()) {
            RESOURCES_LOGGER.debug("DEBUG_MSG = [Resource Manager retrieving data from workers...]");
            for (Worker<? extends WorkerResourceDescription> r : pool.getStaticResources()) {
                r.retrieveData(false);
            }
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            RESOURCES_LOGGER.debug("DEBUG_MSG = [Resource Manager stopping workers...]");
            for (Worker<? extends WorkerResourceDescription> r : pool.getStaticResources()) {
                r.stop(sl);
            }
            RESOURCES_LOGGER.debug("DEBUG_MSG = [Waiting for workers to shutdown...]");
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e) {
                RESOURCES_LOGGER.error("ERROR_MSG= [ERROR: Exception raised on worker shutdown]");
            }
            RESOURCES_LOGGER.info("INFO_MSG = [Workers stopped]");
        }
    }

    public static Worker<? extends WorkerResourceDescription> getWorker(String name) {
        return pool.getResource(name);
    }

    public static List<Worker<? extends WorkerResourceDescription>> getAllWorkers() {
        return pool.findAllResources();
    }

    public static int getTotalNumberOfWorkers() {
        return pool.findAllResources().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends WorkerResourceDescription> void addStaticResource(Worker<T> worker) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            worker.updatedFeatures();
            pool.addStaticResource(worker);
            pool.defineCriticalSet();
            int[] maxTaskCount = worker.getSimultaneousTasks();
            for (int coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] + maxTaskCount[coreId];
            }
        }
        RESOURCES_LOGGER.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        RESOURCES_LOGGER.info("INFO_MSG = [New resource available in the pool. Name = " + worker.getName() + "]");
        RUNTIME_LOGGER.info("New " + (worker.getType() == Resource.Type.SERVICE ? "service" : "computeNode") + " available in the pool. Name = " + worker.getName());
    }

    public static void removeWorker(Worker<? extends WorkerResourceDescription> r) {
        pool.delete(r);
        int[] maxTaskCount = r.getSimultaneousTasks();
        for (int coreId = 0; coreId < maxTaskCount.length; ++coreId) {
            int n = coreId;
            poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] - maxTaskCount[coreId];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void coreElementUpdates(List<Integer> updatedCores) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            pool.coreElementUpdates(updatedCores);
            cloudManager.newCoreElementsDetected(updatedCores);
            ResourceManager.updateMaxConcurrentTasks(updatedCores);
        }
    }

    private static void updateMaxConcurrentTasks(List<Integer> updatedCores) {
        poolCoreMaxConcurrentTasks = Arrays.copyOf(poolCoreMaxConcurrentTasks, CoreManager.getCoreCount());
        List<Worker<? extends WorkerResourceDescription>> workers = pool.findAllResources();
        for (Integer coreId : updatedCores) {
            int total = 0;
            for (Worker<? extends WorkerResourceDescription> w : workers) {
                int[] maxTaskCount = w.getSimultaneousTasks();
                total += maxTaskCount[coreId];
            }
            ResourceManager.poolCoreMaxConcurrentTasks[coreId.intValue()] = total;
        }
    }

    public static void setCloudVMsBoundaries(Integer minVMs, Integer initialVMs, Integer maxVMs) {
        cloudManager.setInitialVMs(initialVMs);
        cloudManager.setMinVMs(minVMs);
        cloudManager.setMaxVMs(maxVMs);
    }

    public static CloudProvider registerCloudProvider(String providerName, Integer limitOfVMs, String runtimeConnectorClass, String connectorJarPath, String connectorMainClass, Map<String, String> connectorProperties) throws ConnectorException {
        return cloudManager.registerCloudProvider(providerName, limitOfVMs, runtimeConnectorClass, connectorJarPath, connectorMainClass, connectorProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCloudWorker(ResourceCreationRequest origin, CloudMethodWorker worker, CloudMethodResourceDescription granted) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            CloudProvider cloudProvider = origin.getProvider();
            cloudProvider.confirmedCreation(origin, worker, granted);
            worker.updatedFeatures();
            pool.addDynamicResource(worker);
            pool.defineCriticalSet();
            int[] maxTaskCount = worker.getSimultaneousTasks();
            for (int coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] + maxTaskCount[coreId];
            }
        }
        PerformedIncrease<CloudMethodResourceDescription> ru = new PerformedIncrease<CloudMethodResourceDescription>(worker.getDescription());
        resourceUser.updatedResource(worker, ru);
        RESOURCES_LOGGER.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        RESOURCES_LOGGER.info("INFO_MSG = [New resource available in the pool. Name = " + worker.getName() + "]");
        RUNTIME_LOGGER.info("New resource available in the pool. Name = " + worker.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increasedCloudWorker(ResourceCreationRequest origin, CloudMethodWorker worker, CloudMethodResourceDescription extension) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            int coreId;
            CloudProvider cloudProvider = origin.getProvider();
            cloudProvider.confirmedCreation(origin, worker, extension);
            int[] maxTaskCount = worker.getSimultaneousTasks();
            for (coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] - maxTaskCount[coreId];
            }
            worker.increaseFeatures(extension);
            maxTaskCount = worker.getSimultaneousTasks();
            for (coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] + maxTaskCount[coreId];
            }
            pool.defineCriticalSet();
        }
        PerformedIncrease<CloudMethodResourceDescription> ru = new PerformedIncrease<CloudMethodResourceDescription>(extension);
        resourceUser.updatedResource(worker, ru);
        RESOURCES_LOGGER.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        RESOURCES_LOGGER.info("INFO_MSG = [Resource modified. Name = " + worker.getName() + "]");
        RUNTIME_LOGGER.info("Resource modified. Name = " + worker.getName());
    }

    public static void reduceCloudWorker(CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        PendingReduction<CloudMethodResourceDescription> modification = new PendingReduction<CloudMethodResourceDescription>(reduction);
        resourceUser.updatedResource(worker, modification);
    }

    public static void reduceWholeWorker(MethodWorker worker) {
        PendingReduction modification = new PendingReduction(worker.getDescription());
        resourceUser.updatedResource(worker, modification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends WorkerResourceDescription> void reduceResource(CloudMethodWorker worker, PendingReduction<R> modification) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            int coreId;
            int[] maxTaskCount = worker.getSimultaneousTasks();
            for (coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] - maxTaskCount[coreId];
            }
            worker.applyReduction(modification);
            maxTaskCount = worker.getSimultaneousTasks();
            for (coreId = 0; coreId < maxTaskCount.length; ++coreId) {
                int n = coreId;
                poolCoreMaxConcurrentTasks[n] = poolCoreMaxConcurrentTasks[n] + maxTaskCount[coreId];
            }
            pool.defineCriticalSet();
            RESOURCES_LOGGER.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
            RESOURCES_LOGGER.info("INFO_MSG = [Resource modified. Name = " + worker.getName() + "]");
            RUNTIME_LOGGER.info("Resource modified. Name = " + worker.getName());
        }
    }

    public static void terminateCloudResource(CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        if (worker.getDescription().getTypeComposition().isEmpty()) {
            pool.delete(worker);
            RESOURCES_LOGGER.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
            RESOURCES_LOGGER.info("INFO_MSG = [Resource removed from the pool. Name = " + worker.getName() + "]");
            RUNTIME_LOGGER.info("Resource removed from the pool. Name = " + worker.getName());
        }
        CloudProvider cp = worker.getProvider();
        cp.requestResourceReduction(worker, reduction);
    }

    public static boolean useCloud() {
        return cloudManager.isUseCloud();
    }

    public static Long getCreationTime() throws Exception {
        try {
            return cloudManager.getNextCreationTime();
        }
        catch (ConnectorException e) {
            throw new Exception(e);
        }
    }

    public static float getCurrentCostPerHour() {
        return cloudManager.currentCostPerHour();
    }

    public static float getTotalCost() {
        return cloudManager.getTotalCost();
    }

    public static int getMaxCloudVMs() {
        return cloudManager.getMaxVMs();
    }

    public static int getInitialCloudVMs() {
        return cloudManager.getInitialVMs();
    }

    public static int getMinCloudVMs() {
        return cloudManager.getMinVMs();
    }

    public static int getCurrentVMCount() {
        return cloudManager.getCurrentVMCount();
    }

    public static long getNextCreationTime() throws Exception {
        return cloudManager.getNextCreationTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getTotalSlots() {
        int[] counts = new int[CoreManager.getCoreCount()];
        if (CoreManager.getCoreCount() > 0) {
            int[] cloudCount = cloudManager.getPendingCoreCounts();
            WorkerPool workerPool = pool;
            synchronized (workerPool) {
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = i < cloudCount.length ? poolCoreMaxConcurrentTasks[i] + cloudCount[i] : poolCoreMaxConcurrentTasks[i];
                }
            }
        }
        return counts;
    }

    public static int[] getAvailableSlots() {
        return poolCoreMaxConcurrentTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Worker<? extends WorkerResourceDescription>> getStaticResources() {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getStaticResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CloudMethodWorker> getDynamicResources() {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getDynamicResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<CloudMethodWorker> getCriticalDynamicResources() {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getCriticalResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<CloudMethodWorker> getNonCriticalDynamicResources() {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getNonCriticalResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudMethodWorker getDynamicResource(String name) {
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            return pool.getDynamicResource(name);
        }
    }

    public static Collection<CloudProvider> getAvailableCloudProviders() {
        return cloudManager.getProviders();
    }

    public static CloudProvider getCloudProvider(String name) {
        return cloudManager.getProvider(name);
    }

    public static List<ResourceCreationRequest> getPendingCreationRequests() {
        return cloudManager.getPendingRequests();
    }

    public static String getPendingRequestsMonitorData(String prefix) {
        StringBuilder sb = new StringBuilder();
        for (ResourceCreationRequest r : cloudManager.getPendingRequests()) {
            sb.append(prefix).append("<Resource id=\"requested new VM\">").append("\n");
            sb.append(prefix).append("\t").append("<CPUComputingUnits>").append(0).append("</CPUComputingUnits>").append("\n");
            sb.append(prefix).append("\t").append("<GPUComputingUnits>").append(0).append("</GPUComputingUnits>").append("\n");
            sb.append(prefix).append("\t").append("<FPGAComputingUnits>").append(0).append("</FPGAComputingUnits>").append("\n");
            sb.append(prefix).append("\t").append("<OTHERComputingUnits>").append(0).append("</OTHERComputingUnits>").append("\n");
            sb.append(prefix).append("\t").append("<Memory>").append(0).append("</Memory>").append("\n");
            sb.append(prefix).append("\t").append("<Disk>").append(0).append("</Disk>").append("\n");
            sb.append(prefix).append("\t").append("<Provider>").append(r.getProvider()).append("</Provider>").append("\n");
            sb.append(prefix).append("\t").append("<Image>").append(r.getRequested().getImage().getImageName()).append("</Image>").append("\n");
            sb.append(prefix).append("\t").append("<Status>").append("Creating").append("</Status>").append("\n");
            sb.append(prefix).append("\t").append("<Tasks>").append("</Tasks>").append("\n");
            sb.append(prefix).append("</Resource>").append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printResourcesState() {
        RESOURCES_LOGGER.info("TIMESTAMP = " + String.valueOf(System.currentTimeMillis()));
        StringBuilder resourceState = new StringBuilder();
        resourceState.append("RESOURCES_INFO = [").append("\n");
        WorkerPool workerPool = pool;
        synchronized (workerPool) {
            for (Worker<? extends WorkerResourceDescription> resource : pool.findAllResources()) {
                resourceState.append("\t").append("RESOURCE = [").append("\n");
                resourceState.append("\t\t").append("NAME = ").append(resource.getName()).append("\n");
                resourceState.append("\t\t").append("TYPE = ").append(resource.getType().toString()).append("\n");
                if (resource.getType() == Resource.Type.SERVICE) {
                    resourceState.append("\t\t").append("CPUS = 0\n");
                    resourceState.append("\t\t").append("MEMORY = 0\n");
                } else {
                    MethodResourceDescription mrd = (MethodResourceDescription)resource.getDescription();
                    resourceState.append("\t\t").append("CPUS = ").append(mrd.getTotalCPUComputingUnits()).append("\n");
                    resourceState.append("\t\t").append("MEMORY = ").append(mrd.getMemorySize()).append("\n");
                }
                int[] coreSlots = resource.getSimultaneousTasks();
                resourceState.append("\t\t").append("CAN_RUN = [").append("\n");
                for (int i = 0; i < coreSlots.length; ++i) {
                    resourceState.append("\t\t\t").append("CORE = [").append("\n");
                    resourceState.append("\t\t\t").append("\t").append("COREID = ").append(i).append("\n");
                    resourceState.append("\t\t\t").append("\t").append("NUM_SLOTS = ").append(coreSlots[i]).append("\n");
                    resourceState.append("\t\t\t").append("]").append("\n");
                }
                resourceState.append("\t\t").append("]").append("\n");
                resourceState.append("\t").append("]\n");
            }
        }
        resourceState.append("]").append("\n");
        resourceState.append("CLOUD_INFO = [").append("\n");
        if (cloudManager.isUseCloud()) {
            resourceState.append("\t").append("CURRENT_CLOUD_VM_COUNT = ").append(cloudManager.getCurrentVMCount()).append("\n");
            try {
                resourceState.append("\t").append("CREATION_TIME = ").append(Long.toString(cloudManager.getNextCreationTime())).append("\n");
            }
            catch (Exception ex) {
                resourceState.append("\t").append("CREATION_TIME = ").append(120000L).append("\n");
            }
            resourceState.append("\t").append("PENDING_RESOURCES = [").append("\n");
            for (ResourceCreationRequest rcr : cloudManager.getPendingRequests()) {
                resourceState.append("\t\t").append("RESOURCE = [").append("\n");
                CloudMethodResourceDescription cmrd = rcr.getRequested();
                resourceState.append("\t\t\t").append("NAME = ").append(cmrd.getName()).append("\n");
                resourceState.append("\t\t\t").append("TYPE = ").append(Resource.Type.WORKER.toString()).append("\n");
                resourceState.append("\t\t\t").append("CPUS = ").append(cmrd.getTotalCPUComputingUnits()).append("\n");
                resourceState.append("\t\t\t").append("MEMORY = ").append(cmrd.getMemorySize()).append("\n");
                resourceState.append("\t\t\t").append("CAN_RUN = [").append("\n");
                int[][] simTasks = rcr.requestedSimultaneousTaskCount();
                for (int coreId = 0; coreId < simTasks.length; ++coreId) {
                    int coreSlots = 0;
                    for (int implId = 0; implId < simTasks[coreId].length; ++implId) {
                        coreSlots = Math.max(coreSlots, simTasks[coreId][implId]);
                    }
                    resourceState.append("\t\t\t\t").append("CORE = [").append("\n");
                    resourceState.append("\t\t\t\t\t").append("COREID = ").append(coreId).append("\n");
                    resourceState.append("\t\t\t\t\t").append("NUM_SLOTS = ").append(coreSlots).append("\n");
                    resourceState.append("\t\t\t\t").append("]").append("\n");
                }
                resourceState.append("\t\t\t").append("]").append("\n");
                resourceState.append("\t\t").append("]").append("\n");
            }
            resourceState.append("\t").append("]").append("\n");
        }
        resourceState.append("]");
        RESOURCES_LOGGER.info(resourceState.toString());
    }

    public static String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("TIMESTAMP = ").append(String.valueOf(System.currentTimeMillis())).append("\n");
        sb.append(pool.getCurrentState(prefix)).append("\n");
        sb.append(cloudManager.getCurrentState(prefix));
        return sb.toString();
    }

    static {
        RESOURCES_LOGGER = LogManager.getLogger("es.bsc.compss.Resources");
        RUNTIME_LOGGER = LogManager.getLogger("es.bsc.compss.Components.ResourceManager");
    }
}

