/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import java.util.Map;

public class MethodWorker
extends Worker<MethodResourceDescription> {
    private String name;
    protected final MethodResourceDescription available;
    private int usedCPUTaskCount = 0;
    private final int maxCPUTaskCount;
    private int usedGPUTaskCount = 0;
    private final int maxGPUTaskCount;
    private int usedFPGATaskCount = 0;
    private final int maxFPGATaskCount;
    private int usedOthersTaskCount = 0;
    private final int maxOthersTaskCount;

    public MethodWorker(String name, MethodResourceDescription description, COMPSsWorker worker, int limitOfTasks, int limitGPUTasks, int limitFPGATasks, int limitOTHERTasks, Map<String, String> sharedDisks) {
        super(name, description, worker, limitOfTasks, sharedDisks);
        this.name = name;
        this.available = new MethodResourceDescription(description);
        this.maxCPUTaskCount = limitOfTasks;
        this.maxGPUTaskCount = limitGPUTasks;
        this.maxFPGATaskCount = limitFPGATasks;
        this.maxOthersTaskCount = limitOTHERTasks;
    }

    public MethodWorker(String name, MethodResourceDescription description, MethodConfiguration conf, Map<String, String> sharedDisks) {
        super(name, description, conf, sharedDisks);
        this.name = name;
        this.available = new MethodResourceDescription(description);
        this.maxCPUTaskCount = conf.getLimitOfTasks();
        this.maxGPUTaskCount = conf.getLimitOfGPUTasks();
        this.maxFPGATaskCount = conf.getLimitOfFPGATasks();
        this.maxOthersTaskCount = conf.getLimitOfOTHERSTasks();
    }

    public MethodWorker(MethodWorker mw) {
        super(mw);
        this.available = mw.available.copy();
        this.maxCPUTaskCount = mw.maxCPUTaskCount;
        this.usedCPUTaskCount = mw.usedCPUTaskCount;
        this.maxGPUTaskCount = mw.maxGPUTaskCount;
        this.usedGPUTaskCount = mw.usedGPUTaskCount;
        this.maxFPGATaskCount = mw.maxFPGATaskCount;
        this.usedFPGATaskCount = mw.usedFPGATaskCount;
        this.maxOthersTaskCount = mw.maxOthersTaskCount;
        this.usedOthersTaskCount = mw.usedOthersTaskCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected int limitIdealSimultaneousTasks(int ideal) {
        return Math.min(this.getMaxCPUTaskCount(), ideal);
    }

    public MethodResourceDescription getAvailable() {
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodResourceDescription reserveResource(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            if (this.hasAvailable(consumption)) {
                return (MethodResourceDescription)this.available.reduceDynamic(consumption);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResource(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.increaseDynamic(consumption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAllResources() {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            super.resetUsedTaskCounts();
            this.available.reduceDynamic(this.available);
            this.available.increaseDynamic(this.description);
        }
    }

    @Override
    public Integer fitCount(Implementation impl) {
        if (impl.getTaskType() == Implementation.TaskType.SERVICE) {
            return null;
        }
        MethodResourceDescription ctrs = (MethodResourceDescription)impl.getRequirements();
        return ((MethodResourceDescription)this.description).canHostSimultaneously(ctrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            return this.available.containsDynamic(consumption);
        }
    }

    @Override
    public boolean hasAvailableSlots() {
        return this.usedCPUTaskCount < this.maxCPUTaskCount || this.usedGPUTaskCount < this.maxGPUTaskCount || this.usedFPGATaskCount < this.maxFPGATaskCount || this.usedOthersTaskCount < this.maxOthersTaskCount;
    }

    public int getMaxCPUTaskCount() {
        return this.maxCPUTaskCount;
    }

    public int getUsedCPUTaskCount() {
        return this.usedCPUTaskCount;
    }

    public int getMaxGPUTaskCount() {
        return this.maxGPUTaskCount;
    }

    public int getUsedGPUTaskCount() {
        return this.usedGPUTaskCount;
    }

    public int getMaxFPGATaskCount() {
        return this.maxFPGATaskCount;
    }

    public int getUsedFPGATaskCount() {
        return this.usedFPGATaskCount;
    }

    public int getMaxOthersTaskCount() {
        return this.maxOthersTaskCount;
    }

    public int getUsedOthersTaskCount() {
        return this.usedOthersTaskCount;
    }

    private void decreaseUsedCPUTaskCount() {
        --this.usedCPUTaskCount;
    }

    private void increaseUsedCPUTaskCount() {
        ++this.usedCPUTaskCount;
    }

    private void decreaseUsedGPUTaskCount() {
        --this.usedGPUTaskCount;
    }

    private void increaseUsedGPUTaskCount() {
        ++this.usedGPUTaskCount;
    }

    private void decreaseUsedFPGATaskCount() {
        --this.usedFPGATaskCount;
    }

    private void increaseUsedFPGATaskCount() {
        ++this.usedFPGATaskCount;
    }

    private void decreaseUsedOthersTaskCount() {
        --this.usedOthersTaskCount;
    }

    private void increaseUsedOthersTaskCount() {
        ++this.usedOthersTaskCount;
    }

    @Override
    public void resetUsedTaskCounts() {
        super.resetUsedTaskCounts();
        this.usedCPUTaskCount = 0;
        this.usedGPUTaskCount = 0;
        this.usedFPGATaskCount = 0;
        this.usedOthersTaskCount = 0;
    }

    @Override
    public Integer simultaneousCapacity(Implementation impl) {
        return Math.min(super.simultaneousCapacity(impl), this.getMaxCPUTaskCount());
    }

    @Override
    public Resource.Type getType() {
        return Resource.Type.WORKER;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<TotalCPUComputingUnits>").append(((MethodResourceDescription)this.description).getTotalCPUComputingUnits()).append("</TotalCPUComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalGPUComputingUnits>").append(((MethodResourceDescription)this.description).getTotalGPUComputingUnits()).append("</TotalGPUComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalFPGAComputingUnits>").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("</TotalFPGAComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalOTHERComputingUnits>").append(((MethodResourceDescription)this.description).getTotalOTHERComputingUnits()).append("</TotalOTHERComputingUnits>").append("\n");
        sb.append(prefix).append("<Memory>").append(((MethodResourceDescription)this.description).getMemorySize()).append("</Memory>").append("\n");
        sb.append(prefix).append("<Disk>").append(((MethodResourceDescription)this.description).getStorageSize()).append("</Disk>").append("\n");
        return sb.toString();
    }

    private Float getValue() {
        return ((MethodResourceDescription)this.description).value;
    }

    @Override
    public int compareTo(Resource t) {
        if (t == null) {
            throw new NullPointerException();
        }
        switch (t.getType()) {
            case SERVICE: {
                return 1;
            }
            case WORKER: {
                MethodWorker w = (MethodWorker)t;
                if (((MethodResourceDescription)this.description).getValue() == null) {
                    if (w.getValue() == null) {
                        return w.getName().compareTo(this.getName());
                    }
                    return 1;
                }
                if (w.getValue() == null) {
                    return -1;
                }
                float dif = w.getValue().floatValue() - ((MethodResourceDescription)this.description).getValue().floatValue();
                if (dif > 0.0f) {
                    return -1;
                }
                if (dif < 0.0f) {
                    return 1;
                }
                return this.getName().compareTo(w.getName());
            }
            case MASTER: {
                return -1;
            }
        }
        return this.getName().compareTo(t.getName());
    }

    @Override
    public boolean canRun(Implementation implementation) {
        switch (implementation.getTaskType()) {
            case METHOD: {
                MethodResourceDescription ctrs = (MethodResourceDescription)implementation.getRequirements();
                return ((MethodResourceDescription)this.description).contains(ctrs);
            }
        }
        return false;
    }

    @Override
    public boolean canRunNow(MethodResourceDescription consumption) {
        boolean canRun = super.canRunNow(consumption);
        canRun = canRun && this.getUsedCPUTaskCount() < this.getMaxCPUTaskCount() || !consumption.containsCPU();
        canRun = canRun && (this.getUsedGPUTaskCount() < this.getMaxGPUTaskCount() || !consumption.containsGPU());
        canRun = canRun && (this.getUsedFPGATaskCount() < this.getMaxFPGATaskCount() || !consumption.containsFPGA());
        canRun = canRun && (this.getUsedOthersTaskCount() < this.getMaxOthersTaskCount() || !consumption.containsOthers());
        canRun = canRun && this.hasAvailable(consumption);
        return canRun;
    }

    @Override
    public void endTask(MethodResourceDescription consumption) {
        if (DEBUG) {
            LOGGER.debug("End task received. Releasing resource " + this.getName());
        }
        if (consumption.containsCPU()) {
            this.decreaseUsedCPUTaskCount();
        }
        if (consumption.containsGPU()) {
            this.decreaseUsedGPUTaskCount();
        }
        if (consumption.containsFPGA()) {
            this.decreaseUsedFPGATaskCount();
        }
        if (consumption.containsOthers()) {
            this.decreaseUsedOthersTaskCount();
        }
        super.endTask(consumption);
    }

    @Override
    public MethodResourceDescription runTask(MethodResourceDescription consumption) {
        MethodResourceDescription reserved = super.runTask(consumption);
        if (reserved != null) {
            if (consumption.containsCPU()) {
                this.increaseUsedCPUTaskCount();
            }
            if (consumption.containsGPU()) {
                this.increaseUsedGPUTaskCount();
            }
            if (consumption.containsFPGA()) {
                this.increaseUsedFPGATaskCount();
            }
            if (consumption.containsOthers()) {
                this.increaseUsedOthersTaskCount();
            }
            return reserved;
        }
        return reserved;
    }

    @Override
    public String getResourceLinks(String prefix) {
        StringBuilder sb = new StringBuilder(super.getResourceLinks(prefix));
        sb.append(prefix).append("TYPE = WORKER").append("\n");
        sb.append(prefix).append("CPU_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalCPUComputingUnits()).append("\n");
        sb.append(prefix).append("GPU_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalGPUComputingUnits()).append("\n");
        sb.append(prefix).append("FPGA_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("\n");
        sb.append(prefix).append("OTHER_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("\n");
        sb.append(prefix).append("MEMORY = ").append(((MethodResourceDescription)this.description).getMemorySize()).append("\n");
        return sb.toString();
    }

    public MethodWorker getSchedulingCopy() {
        return new MethodWorker(this);
    }

    @Override
    public String toString() {
        return "Worker " + this.description + " with usedTaskCount = " + this.usedCPUTaskCount + " and maxTaskCount = " + this.maxCPUTaskCount + " with the following description " + this.description;
    }
}

