/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources.description;

import es.bsc.compss.types.ApplicationPackage;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CloudImageDescription {
    private final String imageName;
    private final Map<String, String> properties;
    private String operatingSystemType = "[unassigned]";
    private String operatingSystemDistribution = "[unassigned]";
    private String operatingSystemVersion = "[unassigned]";
    private List<String> appSoftware;
    private List<ApplicationPackage> packages;
    private Map<String, String> sharedDisks;
    private int creationTime = -1;
    private int priceTimeUnit = -1;
    private float pricePerUnit = -1.0f;
    private List<String> queues;
    private MethodConfiguration config;

    public CloudImageDescription(String imageName, Map<String, String> providerProperties) {
        this.imageName = imageName;
        this.appSoftware = new LinkedList<String>();
        this.packages = new LinkedList<ApplicationPackage>();
        this.sharedDisks = new HashMap<String, String>();
        this.queues = new LinkedList<String>();
        this.properties = new HashMap<String, String>();
        this.properties.putAll(providerProperties);
    }

    public String getOperatingSystemType() {
        return this.operatingSystemType;
    }

    public void setOperatingSystemType(String operatingSystemType) {
        if (operatingSystemType != null && !operatingSystemType.isEmpty()) {
            this.operatingSystemType = operatingSystemType;
        }
    }

    public String getOperatingSystemDistribution() {
        return this.operatingSystemDistribution;
    }

    public void setOperatingSystemDistribution(String operatingSystemDistribution) {
        if (operatingSystemDistribution != null && !operatingSystemDistribution.isEmpty()) {
            this.operatingSystemDistribution = operatingSystemDistribution;
        }
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        if (operatingSystemVersion != null && !operatingSystemVersion.isEmpty()) {
            this.operatingSystemVersion = operatingSystemVersion;
        }
    }

    public List<String> getAppSoftware() {
        return this.appSoftware;
    }

    public void setAppSoftware(List<String> appSoftware) {
        if (appSoftware != null) {
            this.appSoftware = appSoftware;
        }
    }

    public void addApplication(String app) {
        this.appSoftware.add(app);
    }

    public void addAllApplications(List<String> apps) {
        this.appSoftware.addAll(apps);
    }

    public List<String[]> getPackagesList() {
        LinkedList<String[]> packs = new LinkedList<String[]>();
        for (ApplicationPackage p : this.packages) {
            String[] str_pack = new String[]{p.getSource(), p.getTarget()};
            packs.add(str_pack);
        }
        return packs;
    }

    public List<ApplicationPackage> getPackages() {
        return this.packages;
    }

    public void setPackages(List<ApplicationPackage> packages) {
        if (packages != null) {
            this.packages = new ArrayList<ApplicationPackage>(packages);
        }
    }

    public void addPackage(String source, String target) {
        ApplicationPackage p = new ApplicationPackage(source, target);
        this.packages.add(p);
    }

    public Map<String, String> getSharedDisks() {
        return this.sharedDisks;
    }

    public void setSharedDisks(Map<String, String> sharedDisks) {
        if (sharedDisks != null && !sharedDisks.isEmpty()) {
            this.sharedDisks = new HashMap<String, String>(sharedDisks);
        }
    }

    public int getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(int creationTime) {
        this.creationTime = creationTime;
    }

    public int getPriceTimeUnit() {
        return this.priceTimeUnit;
    }

    public void setPriceTimeUnit(int priceTimeUnit) {
        this.priceTimeUnit = priceTimeUnit;
    }

    public float getPricePerUnit() {
        return this.pricePerUnit;
    }

    public void setPricePerUnit(float pricePerUnit) {
        this.pricePerUnit = pricePerUnit;
    }

    public List<String> getQueues() {
        return this.queues;
    }

    public void setQueues(List<String> queues) {
        if (queues != null) {
            this.queues = new LinkedList<String>(queues);
        }
    }

    public void addQueue(String queue) {
        this.queues.add(queue);
    }

    public MethodConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(MethodConfiguration config) {
        this.config = config.copy();
        String maxPort = "-1";
        String minPort = "-1";
        if (this.config != null) {
            maxPort = String.valueOf(this.config.getMaxPort());
            minPort = String.valueOf(this.config.getMinPort());
        }
        this.properties.put("adaptor-max-port", maxPort);
        this.properties.put("adaptor-min-port", minPort);
    }

    public String getImageName() {
        return this.imageName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("IMAGE = [").append("\n");
        sb.append(prefix).append("\t").append("NAME = ").append(this.imageName).append("\n");
        sb.append(prefix).append("\t").append("OS_TYPE = ").append(this.getOperatingSystemType()).append("\n");
        sb.append(prefix).append("\t").append("OS_DISTR = ").append(this.getOperatingSystemDistribution()).append("\n");
        sb.append(prefix).append("\t").append("OS_VERSION = ").append(this.getOperatingSystemVersion()).append("\n");
        sb.append(prefix).append("\t").append("INSTALL_DIR = ").append(this.getConfig().getInstallDir()).append("\n");
        sb.append(prefix).append("\t").append("WORKING_DIR = ").append(this.getConfig().getWorkingDir()).append("\n");
        sb.append(prefix).append("\t").append("APP_DIR = ").append(this.getConfig().getAppDir()).append("\n");
        sb.append(prefix).append("\t").append("LIBRARY_PATH = ").append(this.getConfig().getLibraryPath()).append("\n");
        sb.append(prefix).append("\t").append("CLASSPATH = ").append(this.getConfig().getClasspath()).append("\n");
        sb.append(prefix).append("\t").append("PYTHONPATH = ").append(this.getConfig().getPythonpath()).append("\n");
        sb.append(prefix).append("\t").append("USER = ").append(this.getConfig().getUser()).append("\n");
        sb.append(prefix).append("\t").append("PASSWORD = ").append(this.getProperties().get("Password")).append("\n");
        sb.append(prefix).append("\t").append("SHARED_DISKS = [").append("\n");
        for (Map.Entry<String, String> entry : this.sharedDisks.entrySet()) {
            sb.append(prefix).append("\t").append("\t").append("SHARED_DISK = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("DISK_NAME = ").append(entry.getKey()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("MOUNT_POINT = ").append(entry.getValue()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("\t").append("PACKAGES = [").append("\n");
        for (ApplicationPackage pack : this.packages) {
            sb.append(prefix).append("\t").append("\t").append("PACKAGE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("SOURCE = ").append(pack.getSource()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("TARGET = ").append(pack.getTarget()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("\t").append("SOFTWARE = [").append("\n");
        for (String app : this.appSoftware) {
            sb.append(prefix).append("\t").append("\t").append("APPLICATION = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("NAME = ").append(app).append("\n");
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

