/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.utils;

import es.bsc.compss.invokers.external.ExternalCommand;
import es.bsc.compss.invokers.external.piped.PipeCommand;
import es.bsc.compss.invokers.external.piped.commands.EndTaskPipeCommand;
import es.bsc.compss.invokers.external.piped.commands.ErrorTaskPipeCommand;
import es.bsc.compss.invokers.external.piped.commands.QuitPipeCommand;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PipePair {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private static final String ERROR_PIPE_CLOSE = "Error on closing pipe ";
    private static final String ERROR_PIPE_QUIT = "Error finishing readPipeFile ";
    private static final String ERROR_PIPE_NOT_FOUND = "Pipe cannot be found";
    private static final String ERROR_PIPE_NOT_READ = "Pipe cannot be read";
    protected static final String TOKEN_NEW_LINE = "\n";
    protected static final String TOKEN_SEP = " ";
    private static final int MAX_WRITE_PIPE_RETRIES = 3;
    private final String pipePath;

    public PipePair(String basePipePath, String id) {
        this.pipePath = basePipePath + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(PipeCommand command) {
        boolean done = false;
        int retries = 0;
        String taskCMD = command.getAsString();
        String writePipe = this.pipePath + ".outbound";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EXECUTOR COMMAND: " + taskCMD + " @ " + writePipe);
        }
        taskCMD = taskCMD + TOKEN_NEW_LINE;
        while (!done && retries < 3) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(writePipe, true);
                ((OutputStream)output).write(taskCMD.getBytes());
                output.flush();
                done = true;
            }
            catch (Exception e) {
                LOGGER.debug("Error on pipe write. Retry");
                ++retries;
            }
            finally {
                if (output == null) continue;
                try {
                    ((OutputStream)output).close();
                }
                catch (Exception e) {
                    ErrorManager.error(ERROR_PIPE_CLOSE + writePipe, e);
                }
            }
        }
        return done;
    }

    public String toString() {
        return "READ pipe: " + this.pipePath + ".inbound  WRITE pipe:" + this.pipePath + ".outbound";
    }

    public PipeCommand read() {
        PipeCommand readCommand = null;
        try {
            FileInputStream input = new FileInputStream(this.pipePath + ".inbound");
            String line = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                line = reader.readLine();
            }
            if (line != null) {
                String[] result = line.split(TOKEN_SEP);
                if (result.length < 1) {
                    LOGGER.warn("Skipping line: " + line);
                    return null;
                }
                ExternalCommand.CommandType commandType = ExternalCommand.CommandType.valueOf(result[0].toUpperCase());
                switch (commandType) {
                    case QUIT: {
                        LOGGER.debug("Received quit message");
                        break;
                    }
                    case END_TASK: {
                        LOGGER.debug("Received endTask message: " + line);
                        if (result.length < 3) {
                            LOGGER.warn("WARN: Skipping endTask line because is malformed");
                            break;
                        }
                        readCommand = new EndTaskPipeCommand(result);
                        break;
                    }
                    case ERROR_TASK: {
                        LOGGER.debug("Received errorTask message: " + line);
                        readCommand = new ErrorTaskPipeCommand(result);
                        break;
                    }
                    default: {
                        LOGGER.warn("Unrecognised tag on PipedMirror: " + result[0] + ". Skipping message");
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug("Pipe cannot be found " + this.pipePath + ".inbound");
        }
        catch (IOException ioe) {
            LOGGER.error(ERROR_PIPE_NOT_READ);
        }
        return readCommand;
    }

    public void close() {
        boolean done;
        String writePipe = this.pipePath + ".outbound";
        if (new File(writePipe).exists() && !(done = this.send(new QuitPipeCommand()))) {
            ErrorManager.error(ERROR_PIPE_QUIT + writePipe);
        }
    }
}

