/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ServiceResourceDescription
extends WorkerResourceDescription {
    private final String serviceName;
    private final String namespace;
    private final String port;
    private int connections;

    public ServiceResourceDescription(String serviceName, String namespace, String port, int connections) {
        this.serviceName = serviceName;
        this.namespace = namespace;
        this.port = port;
        this.connections = connections;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPort() {
        return this.port;
    }

    @Override
    public boolean canHost(Implementation impl) {
        if (impl.getTaskType() == Implementation.TaskType.SERVICE) {
            ServiceResourceDescription s = (ServiceResourceDescription)impl.getRequirements();
            return s.serviceName.compareTo(this.serviceName) == 0 && s.namespace.compareTo(this.namespace) == 0 && s.port.compareTo(this.port) == 0 && s.connections < this.connections;
        }
        return false;
    }

    @Override
    public boolean canHostDynamic(Implementation impl) {
        int conRequired = ((ServiceResourceDescription)impl.getRequirements()).connections;
        return conRequired <= this.connections;
    }

    @Override
    public void mimic(ResourceDescription rd) {
    }

    @Override
    public void increase(ResourceDescription rd) {
        ServiceResourceDescription srd = (ServiceResourceDescription)rd;
        this.connections += srd.connections;
    }

    @Override
    public void increaseDynamic(ResourceDescription rd) {
        ServiceResourceDescription srd = (ServiceResourceDescription)rd;
        this.connections += srd.connections;
    }

    @Override
    public void reduce(ResourceDescription rd) {
        ServiceResourceDescription srd = (ServiceResourceDescription)rd;
        this.connections -= srd.connections;
    }

    @Override
    public ResourceDescription reduceDynamic(ResourceDescription rd) {
        ServiceResourceDescription srd = (ServiceResourceDescription)rd;
        this.connections -= srd.connections;
        return new ServiceResourceDescription("", "", "", srd.connections);
    }

    @Override
    public ResourceDescription getDynamicCommons(ResourceDescription constraints) {
        ServiceResourceDescription sConstraints = (ServiceResourceDescription)constraints;
        int conCommons = Math.min(sConstraints.connections, this.connections);
        return new ServiceResourceDescription("", "", "", conCommons);
    }

    @Override
    public boolean isDynamicUseless() {
        return this.connections == 0;
    }

    @Override
    public boolean isDynamicConsuming() {
        return this.connections > 0;
    }

    public String toString() {
        return "[SERVICE NAMESPACE=" + this.namespace + " " + "SERVICE_NAME=" + this.getServiceName() + " " + "PORT=" + this.port + " " + "CONNECTIONS=" + this.connections + "]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public ServiceResourceDescription copy() {
        return new ServiceResourceDescription(this.serviceName, this.namespace, this.port, this.connections);
    }

    @Override
    public String getDynamicDescription() {
        return "Connections:" + this.connections;
    }
}

