/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.piped;

import es.bsc.compss.executor.external.ExternalExecutorException;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.commands.CompssExceptionPipeCommand;
import es.bsc.compss.executor.external.piped.commands.EndTaskPipeCommand;
import es.bsc.compss.executor.external.piped.commands.PipeCommand;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.types.ExternalTaskStatus;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.worker.COMPSsException;
import java.io.File;

public abstract class PipedInvoker
extends ExternalInvoker {
    private final PipePair pipes;

    public PipedInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources, PipePair pipes) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        this.pipes = pipes;
    }

    @Override
    public void invokeMethod() throws JobExecutionException, COMPSsException {
        if (!this.pipes.sendCommand((PipeCommand)((Object)this.command))) {
            int jobId = this.invocation.getJobId();
            LOGGER.error("ERROR: Could not execute job " + jobId + " because cannot write in pipe");
            throw new JobExecutionException("Job " + jobId + " has failed. Cannot write in pipe");
        }
        try {
            while (true) {
                PipeCommand rcvdCommand;
                if ((rcvdCommand = this.pipes.readCommand()) == null) {
                    continue;
                }
                switch (rcvdCommand.getType()) {
                    case END_TASK: {
                        ExternalTaskStatus taskStatus = ((EndTaskPipeCommand)rcvdCommand).getTaskStatus();
                        Integer exitValue = taskStatus.getExitValue();
                        if (exitValue != 0) {
                            throw new JobExecutionException("Exit values is " + exitValue);
                        }
                        LOGGER.debug("Updating parameters for job " + this.invocation.getJobId());
                        int parIdx = 0;
                        for (InvocationParam invocationParam : this.invocation.getParams()) {
                            this.updateParam(invocationParam, taskStatus, parIdx);
                            ++parIdx;
                        }
                        InvocationParam target = this.invocation.getTarget();
                        if (target != null) {
                            this.updateParam(target, taskStatus, parIdx);
                            ++parIdx;
                        }
                        for (InvocationParam invocationParam : this.invocation.getResults()) {
                            this.updateParam(invocationParam, taskStatus, parIdx);
                            ++parIdx;
                        }
                        return;
                    }
                    case COMPSS_EXCEPTION: {
                        throw new COMPSsException(((CompssExceptionPipeCommand)rcvdCommand).getMessage());
                    }
                }
                LOGGER.warn("Unexpected tag on PipedInvoker: " + rcvdCommand + ". Skipping message");
            }
        }
        catch (ExternalExecutorException e) {
            throw new JobExecutionException("Notification pipe closed", e);
        }
    }

    private void updateParam(InvocationParam param, ExternalTaskStatus taskStatus, int parIdx) {
        DataType paramType = taskStatus.getParameterType(parIdx);
        if (paramType != null && paramType.equals((Object)DataType.EXTERNAL_PSCO_T)) {
            param.setType(paramType);
            String value = taskStatus.getParameterValue(parIdx);
            param.setValue(value);
            if (value != null) {
                param.setValueClass(value.getClass());
            }
        }
    }
}

