/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.ConstructConfigurationException;
import es.bsc.compss.exceptions.NoResourceAvailableException;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.project.ProjectFile;
import es.bsc.compss.types.project.exceptions.ProjectFileValidationException;
import es.bsc.compss.types.project.jaxb.ApplicationType;
import es.bsc.compss.types.project.jaxb.AttachedDiskType;
import es.bsc.compss.types.project.jaxb.AttachedDisksListType;
import es.bsc.compss.types.project.jaxb.CloudPropertiesType;
import es.bsc.compss.types.project.jaxb.CloudPropertyType;
import es.bsc.compss.types.project.jaxb.CloudType;
import es.bsc.compss.types.project.jaxb.DataNodeType;
import es.bsc.compss.types.project.jaxb.ImagesType;
import es.bsc.compss.types.project.jaxb.InstanceTypeType;
import es.bsc.compss.types.project.jaxb.InstanceTypesType;
import es.bsc.compss.types.project.jaxb.MasterNodeType;
import es.bsc.compss.types.project.jaxb.MemoryType;
import es.bsc.compss.types.project.jaxb.OSType;
import es.bsc.compss.types.project.jaxb.PackageType;
import es.bsc.compss.types.project.jaxb.ProcessorPropertyType;
import es.bsc.compss.types.project.jaxb.ProcessorType;
import es.bsc.compss.types.project.jaxb.SoftwareListType;
import es.bsc.compss.types.project.jaxb.StorageType;
import es.bsc.compss.types.resources.DataResourceDescription;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.MethodWorker;
import es.bsc.compss.types.resources.ResourcesFile;
import es.bsc.compss.types.resources.ServiceResourceDescription;
import es.bsc.compss.types.resources.ServiceWorker;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.resources.configuration.ServiceConfiguration;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.exceptions.ResourcesFileValidationException;
import es.bsc.compss.types.resources.jaxb.CloudProviderType;
import es.bsc.compss.types.resources.jaxb.ComputeNodeType;
import es.bsc.compss.types.resources.jaxb.EndpointType;
import es.bsc.compss.types.resources.jaxb.ImageType;
import es.bsc.compss.types.resources.jaxb.PriceType;
import es.bsc.compss.types.resources.jaxb.ServiceType;
import es.bsc.compss.types.resources.jaxb.SharedDiskType;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.SharedDiskManager;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class ResourceLoader {
    private static String resources_XML;
    private static String resources_XSD;
    private static String project_XML;
    private static String project_XSD;
    private static ResourcesFile resources;
    private static ProjectFile project;
    private static final Logger LOGGER;

    public static void load(String resources_XML, String resources_XSD, String project_XML, String project_XSD) throws ResourcesFileValidationException, ProjectFileValidationException, NoResourceAvailableException {
        ResourceLoader.init(resources_XML, resources_XSD, project_XML, project_XSD);
        if (ResourceLoader.resources_XML != null && ResourceLoader.project_XML != null) {
            ResourceLoader.loadFiles();
            ResourceLoader.loadRuntime();
        } else {
            LOGGER.warn("No resource/project file detected. Starting runtime without computing resources.");
        }
    }

    private static void init(String resources_XML, String resources_XSD, String project_XML, String project_XSD) {
        LOGGER.info("ResourceLoader init");
        ResourceLoader.resources_XML = resources_XML;
        ResourceLoader.resources_XSD = resources_XSD;
        ResourceLoader.project_XML = project_XML;
        ResourceLoader.project_XSD = project_XSD;
    }

    private static void loadFiles() throws ResourcesFileValidationException, ProjectFileValidationException {
        LOGGER.info("ResourceLoader loading files");
        try {
            LOGGER.debug("ResourceLoader loading resources.xml");
            resources = new ResourcesFile(new File(resources_XML), resources_XSD, LOGGER);
        }
        catch (JAXBException | SAXException e) {
            throw new ResourcesFileValidationException(e);
        }
        try {
            LOGGER.debug("ResourceLoader loading project.xml");
            project = new ProjectFile(new File(project_XML), project_XSD, LOGGER);
        }
        catch (JAXBException | SAXException e) {
            throw new ProjectFileValidationException(e);
        }
    }

    private static void loadRuntime() throws NoResourceAvailableException {
        CloudType cloudType;
        List<DataNodeType> list;
        List<es.bsc.compss.types.project.jaxb.ServiceType> services;
        LOGGER.info("ResourceLoader loading Runtime");
        boolean computeNodeExist = false;
        boolean serviceExist = false;
        boolean cloudProviderExist = false;
        MasterNodeType master = project.getMasterNode();
        boolean exist = ResourceLoader.loadMaster(master);
        computeNodeExist = computeNodeExist || exist;
        List<es.bsc.compss.types.project.jaxb.ComputeNodeType> computeNodes = project.getComputeNodes_list();
        if (computeNodes != null) {
            for (es.bsc.compss.types.project.jaxb.ComputeNodeType computeNodeType : computeNodes) {
                ComputeNodeType computeNodeType2 = resources.getComputeNode(computeNodeType.getName());
                if (computeNodeType2 != null) {
                    exist = ResourceLoader.loadComputeNode(computeNodeType, computeNodeType2);
                    computeNodeExist = computeNodeExist || exist;
                    continue;
                }
                ErrorManager.warn("ComputeNode " + computeNodeType.getName() + " not defined in the resources file");
            }
        }
        if ((services = project.getServices_list()) != null) {
            for (es.bsc.compss.types.project.jaxb.ServiceType serviceType : services) {
                ServiceType s_resources = resources.getService(serviceType.getWsdl());
                if (s_resources != null) {
                    exist = ResourceLoader.loadService(serviceType, s_resources);
                    serviceExist = serviceExist || exist;
                    continue;
                }
                ErrorManager.warn("Service " + serviceType.getWsdl() + " not defined in the resources file");
            }
        }
        if ((list = project.getDataNodes_list()) != null) {
            for (DataNodeType dn_project : list) {
                es.bsc.compss.types.resources.jaxb.DataNodeType dn_resources = resources.getDataNode(dn_project.getName());
                if (dn_resources != null) {
                    ResourceLoader.loadDataNode(dn_project, dn_resources);
                    continue;
                }
                ErrorManager.warn("DataNode " + dn_project.getName() + " not defined in the resources file");
            }
        }
        if ((cloudType = project.getCloud()) != null) {
            cloudProviderExist = ResourceLoader.loadCloud(cloudType);
        }
        if (!(computeNodeExist || serviceExist || cloudProviderExist)) {
            throw new NoResourceAvailableException();
        }
    }

    private static boolean loadMaster(MasterNodeType master) {
        HashMap<String, String> sharedDisks = new HashMap<String, String>();
        List<Object> masterInformation = master.getProcessorOrMemoryOrStorage();
        MethodResourceDescription mrd = new MethodResourceDescription();
        if (masterInformation != null) {
            for (Object object : masterInformation) {
                if (object instanceof ProcessorType) {
                    ProcessorType procNode = (ProcessorType)object;
                    String procName = procNode.getName();
                    int computingUnits = project.getProcessorComputingUnits(procNode);
                    String architecture = project.getProcessorArchitecture(procNode);
                    float speed = project.getProcessorSpeed(procNode);
                    String type = project.getProcessorType(procNode);
                    float internalMemory = project.getProcessorMemorySize(procNode);
                    ProcessorPropertyType procProp = project.getProcessorProperty(procNode);
                    String propKey = procProp != null ? procProp.getKey() : "";
                    String propValue = procProp != null ? procProp.getValue() : "";
                    mrd.addProcessor(procName, computingUnits, architecture, speed, type, internalMemory, propKey, propValue);
                    continue;
                }
                if (object instanceof MemoryType) {
                    MemoryType memNode = (MemoryType)object;
                    mrd.setMemorySize(project.getMemorySize(memNode));
                    mrd.setMemoryType(project.getMemoryType(memNode));
                    continue;
                }
                if (object instanceof StorageType) {
                    StorageType strNode = (StorageType)object;
                    mrd.setStorageSize(project.getStorageSize(strNode));
                    mrd.setStorageType(project.getStorageType(strNode));
                    continue;
                }
                if (object instanceof OSType) {
                    OSType osNode = (OSType)object;
                    mrd.setOperatingSystemType(project.getOperatingSystemType(osNode));
                    mrd.setOperatingSystemDistribution(project.getOperatingSystemDistribution(osNode));
                    mrd.setOperatingSystemVersion(project.getOperatingSystemVersion(osNode));
                    continue;
                }
                if (object instanceof SoftwareListType) {
                    SoftwareListType softwares = (SoftwareListType)object;
                    List<String> apps = softwares.getApplication();
                    if (apps == null) continue;
                    for (String appName : apps) {
                        mrd.addApplication(appName);
                    }
                    continue;
                }
                if (object instanceof AttachedDisksListType) {
                    List<AttachedDiskType> disksList;
                    AttachedDisksListType disks = (AttachedDisksListType)object;
                    if (disks == null || (disksList = disks.getAttachedDisk()) == null) continue;
                    for (AttachedDiskType disk : disksList) {
                        SharedDiskType disk_resources = resources.getSharedDisk(disk.getName());
                        if (disk_resources != null) {
                            String diskName = disk.getName();
                            String diskMountPoint = disk.getMountPoint();
                            sharedDisks.put(diskName, diskMountPoint);
                            continue;
                        }
                        ErrorManager.warn("SharedDisk " + disk.getName() + " defined in the master node is not defined in the resources.xml. Skipping");
                    }
                    continue;
                }
                if (object instanceof es.bsc.compss.types.project.jaxb.PriceType) continue;
                LOGGER.warn("MasterNode has an unrecognized parameter: " + object.getClass());
            }
        }
        ((DynamicMethodWorker)((Object)Comm.getAppHost())).increaseFeatures(mrd);
        Comm.getAppHost().updateDisks(sharedDisks);
        for (Map.Entry entry : sharedDisks.entrySet()) {
            SharedDiskManager.addSharedToMachine((String)entry.getKey(), (String)entry.getValue(), Comm.getAppHost());
        }
        if (mrd.getTotalCPUComputingUnits() > 0) {
            ResourceManager.addDynamicWorker((DynamicMethodWorker)((Object)Comm.getAppHost()), mrd);
            return true;
        }
        return false;
    }

    private static boolean loadComputeNode(es.bsc.compss.types.project.jaxb.ComputeNodeType cn_project, ComputeNodeType cn_resources) {
        HashMap<String, String> sharedDisks;
        PriceType priceType;
        String name = cn_project.getName();
        MethodResourceDescription mrd = new MethodResourceDescription();
        List<es.bsc.compss.types.resources.jaxb.ProcessorType> processors = resources.getProcessors(cn_resources);
        if (processors != null) {
            for (es.bsc.compss.types.resources.jaxb.ProcessorType processorType : processors) {
                String procName = processorType.getName();
                int computingUnits = resources.getProcessorComputingUnits(processorType);
                String architecture = resources.getProcessorArchitecture(processorType);
                float speed = resources.getProcessorSpeed(processorType);
                Iterator<String> type = resources.getProcessorType(processorType);
                float internalMemory = resources.getProcessorMemorySize(processorType);
                es.bsc.compss.types.resources.jaxb.ProcessorPropertyType procProp = resources.getProcessorProperty(processorType);
                String propKey = procProp != null ? procProp.getKey() : "";
                String propValue = procProp != null ? procProp.getValue() : "";
                mrd.addProcessor(procName, computingUnits, architecture, speed, (String)((Object)type), internalMemory, propKey, propValue);
            }
        }
        mrd.setMemorySize(resources.getMemorySize(cn_resources));
        mrd.setMemoryType(resources.getMemoryType(cn_resources));
        mrd.setStorageSize(resources.getStorageSize(cn_resources));
        mrd.setStorageType(resources.getStorageType(cn_resources));
        mrd.setOperatingSystemType(resources.getOperatingSystemType(cn_resources));
        mrd.setOperatingSystemDistribution(resources.getOperatingSystemDistribution(cn_resources));
        mrd.setOperatingSystemVersion(resources.getOperatingSystemVersion(cn_resources));
        List<String> apps = resources.getApplications(cn_resources);
        if (apps != null) {
            for (String appName : apps) {
                mrd.addApplication(appName);
            }
        }
        if ((priceType = resources.getPrice(cn_resources)) != null) {
            mrd.setPriceTimeUnit(priceType.getTimeUnit());
            mrd.setPricePerUnit(priceType.getPricePerUnit());
        }
        if ((sharedDisks = resources.getSharedDisks(cn_resources)) != null) {
            List<String> declaredSharedDisks = resources.getSharedDisks_names();
            for (String diskName : sharedDisks.keySet()) {
                if (declaredSharedDisks != null && declaredSharedDisks.contains(diskName)) continue;
                ErrorManager.warn("SharedDisk " + diskName + " defined in the ComputeNode " + name + " is not defined in the resources.xml. Skipping");
                sharedDisks.remove(diskName);
            }
        }
        String loadedAdaptor = System.getProperty("compss.comm");
        List<String> queues_project = project.getAdaptorQueues(cn_project, loadedAdaptor);
        List<String> queues_resources = resources.getAdaptorQueues(cn_resources, loadedAdaptor);
        if (queues_project == null) {
            for (String queue : queues_resources) {
                mrd.addHostQueue(queue);
            }
        } else {
            for (String queue : queues_resources) {
                if (!queues_project.contains(queue)) continue;
                mrd.addHostQueue(queue);
            }
        }
        Object adaptorProperties_project = project.getAdaptorProperties(cn_project, loadedAdaptor);
        Object adaptorProperties_resources = resources.getAdaptorProperties(cn_resources, loadedAdaptor);
        MethodConfiguration config = null;
        try {
            config = (MethodConfiguration)Comm.constructConfiguration(loadedAdaptor, adaptorProperties_project, adaptorProperties_resources);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn("Adaptor " + loadedAdaptor + " configuration constructor failed", cce);
            return false;
        }
        config.setHost(cn_project.getName());
        config.setUser(project.getUser(cn_project));
        config.setInstallDir(project.getInstallDir(cn_project));
        config.setWorkingDir(project.getWorkingDir(cn_project));
        int limitOfTasks = project.getLimitOfTasks(cn_project);
        if (limitOfTasks >= 0) {
            config.setLimitOfTasks(limitOfTasks);
        } else {
            config.setLimitOfTasks(mrd.getTotalCPUComputingUnits());
        }
        config.setTotalComputingUnits(mrd.getTotalCPUComputingUnits());
        config.setTotalGPUComputingUnits(mrd.getTotalGPUComputingUnits());
        config.setTotalFPGAComputingUnits(mrd.getTotalFPGAComputingUnits());
        config.setTotalOTHERComputingUnits(mrd.getTotalOTHERComputingUnits());
        ApplicationType app = project.getApplication(cn_project);
        if (app != null) {
            config.setAppDir(app.getAppDir());
            config.setLibraryPath(app.getLibraryPath());
            config.setClasspath(app.getClasspath());
            config.setPythonpath(app.getPythonpath());
        }
        LOGGER.debug("Adding method worker " + name);
        MethodWorker methodWorker = ResourceLoader.createMethodWorker(name, mrd, sharedDisks, config);
        ResourceManager.addStaticResource(methodWorker);
        return true;
    }

    private static boolean loadService(es.bsc.compss.types.project.jaxb.ServiceType s_project, ServiceType s_resources) {
        String serviceAdaptorName = "es.bsc.compss.ws.master.WSAdaptor";
        String wsdl = s_project.getWsdl();
        String serviceName = s_resources.getName();
        String namespace = s_resources.getNamespace();
        String port = s_resources.getPort();
        ServiceResourceDescription srd = new ServiceResourceDescription(serviceName, namespace, port, Integer.MAX_VALUE);
        ServiceConfiguration config = null;
        try {
            config = (ServiceConfiguration)Comm.constructConfiguration(serviceAdaptorName, s_project, s_resources);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn("Service configuration constructor failed", cce);
            return false;
        }
        int limitOfTasks = s_project.getLimitOfTasks();
        if (limitOfTasks >= 0) {
            config.setLimitOfTasks(limitOfTasks);
        } else {
            config.setLimitOfTasks(Integer.MAX_VALUE);
        }
        LOGGER.debug("Adding service worker " + wsdl);
        ServiceWorker newResource = new ServiceWorker(wsdl, srd, config);
        ResourceManager.addStaticResource(newResource);
        return true;
    }

    private static MethodWorker createMethodWorker(String name, MethodResourceDescription rd, Map<String, String> sharedDisks, MethodConfiguration mc) {
        int taskCount = ResourceLoader.getValidMinimum(mc.getLimitOfTasks(), rd.getTotalCPUComputingUnits());
        mc.setLimitOfTasks(taskCount);
        int taskCountGPU = ResourceLoader.getValidMinimum(mc.getLimitOfGPUTasks(), rd.getTotalGPUComputingUnits());
        mc.setLimitOfGPUTasks(taskCountGPU);
        int taskCountFPGA = ResourceLoader.getValidMinimum(mc.getLimitOfFPGATasks(), rd.getTotalFPGAComputingUnits());
        mc.setLimitOfFPGATasks(taskCountFPGA);
        int taskCountOther = ResourceLoader.getValidMinimum(mc.getLimitOfOTHERsTasks(), rd.getTotalOTHERComputingUnits());
        mc.setLimitOfOTHERsTasks(taskCountOther);
        MethodWorker methodWorker = new MethodWorker(name, rd, mc, sharedDisks);
        return methodWorker;
    }

    private static int getValidMinimum(int x, int y) {
        if (x < 0 && y < 0) {
            return 0;
        }
        if (x < 0) {
            return y;
        }
        if (y < 0) {
            return x;
        }
        return Math.min(x, y);
    }

    private static boolean loadCloud(CloudType cloud) {
        Integer initialVMs = project.getInitialVMs(cloud);
        Integer minVMs = project.getMinVMs(cloud);
        Integer maxVMs = project.getMaxVMs(cloud);
        ResourceManager.setCloudVMsBoundaries(minVMs, initialVMs, maxVMs);
        boolean cloudEnabled = false;
        List<String> cp_resources = resources.getCloudProviders_names();
        for (es.bsc.compss.types.project.jaxb.CloudProviderType cp : project.getCloudProviders_list()) {
            if (cp_resources.contains(cp.getName())) {
                boolean isEnabled = ResourceLoader.loadCloudProvider(cp, resources.getCloudProvider(cp.getName()));
                cloudEnabled = cloudEnabled || isEnabled;
                continue;
            }
            ErrorManager.warn("CloudProvider " + cp.getName() + " not defined in resources.xml file. Skipping");
        }
        return cloudEnabled;
    }

    private static boolean loadCloudProvider(es.bsc.compss.types.project.jaxb.CloudProviderType cp_project, CloudProviderType cp_resources) {
        CloudProvider provider;
        String cpName = cp_project.getName();
        String runtimeConnector = System.getProperty("compss.conn");
        String connectorJarPath = "";
        String connectorMainClass = "";
        HashMap<String, String> properties = new HashMap<String, String>();
        EndpointType endpoint = cp_resources.getEndpoint();
        connectorJarPath = resources.getConnectorJarPath(endpoint);
        connectorMainClass = resources.getConnectorMainClass(endpoint);
        properties.put("Server", resources.getServer(endpoint));
        properties.put("Port", resources.getPort(endpoint));
        List<Object> objList = cp_project.getImagesOrInstanceTypesOrLimitOfVMs();
        if (objList != null) {
            for (Object obj : objList) {
                if (!(obj instanceof CloudPropertiesType)) continue;
                CloudPropertiesType cloud_props = (CloudPropertiesType)obj;
                for (CloudPropertyType prop : cloud_props.getProperty()) {
                    properties.put(prop.getName(), prop.getValue());
                }
            }
        }
        String appName = System.getProperty("compss.appName");
        appName = appName.toLowerCase();
        appName = appName.replace('.', '-');
        properties.put("app-name", appName);
        int limitOfVMs = -1;
        int maxCreationTime = -1;
        LinkedList<CloudImageDescription> images = new LinkedList<CloudImageDescription>();
        LinkedList<CloudInstanceTypeDescription> instanceTypes = new LinkedList<CloudInstanceTypeDescription>();
        objList = cp_project.getImagesOrInstanceTypesOrLimitOfVMs();
        if (objList != null) {
            for (Object obj : objList) {
                if (obj instanceof ImagesType) {
                    ImagesType imageList = (ImagesType)obj;
                    for (es.bsc.compss.types.project.jaxb.ImageType im_project : imageList.getImage()) {
                        ImageType im_resources;
                        CloudImageDescription cid = ResourceLoader.createImage(im_project, im_resources = resources.getImage(cp_resources, im_project.getName()), properties);
                        if (cid == null) continue;
                        images.add(cid);
                        int localCT = cid.getCreationTime();
                        if (localCT <= maxCreationTime) continue;
                        maxCreationTime = localCT;
                    }
                    continue;
                }
                if (obj instanceof InstanceTypesType) {
                    InstanceTypesType instancesList = (InstanceTypesType)obj;
                    for (InstanceTypeType instance_project : instancesList.getInstanceType()) {
                        String instanceName = instance_project.getName();
                        es.bsc.compss.types.resources.jaxb.InstanceTypeType instance_resources = resources.getInstance(cp_resources, instanceName);
                        if (instance_resources != null) {
                            CloudInstanceTypeDescription cmrd = ResourceLoader.createInstance(instance_resources);
                            if (cmrd == null) continue;
                            instanceTypes.add(cmrd);
                            continue;
                        }
                        ErrorManager.warn("Instance " + instanceName + " not defined in resources.xml. Skipping");
                    }
                    continue;
                }
                if (!(obj instanceof Integer)) continue;
                limitOfVMs = (Integer)obj;
            }
        }
        if (maxCreationTime > 0) {
            properties.put("max-vm-creation-time", Integer.toString(maxCreationTime));
        }
        try {
            provider = ResourceManager.registerCloudProvider(cpName, limitOfVMs, runtimeConnector, connectorJarPath, connectorMainClass, properties);
        }
        catch (Exception e) {
            ErrorManager.warn("Exception loading CloudProvider " + cpName, e);
            return false;
        }
        for (CloudImageDescription cid : images) {
            provider.addCloudImage(cid);
        }
        for (CloudInstanceTypeDescription instance : instanceTypes) {
            provider.addInstanceType(instance);
        }
        return true;
    }

    private static CloudImageDescription createImage(es.bsc.compss.types.project.jaxb.ImageType im_project, ImageType im_resources, Map<String, String> properties) {
        PriceType p;
        String imageName = im_project.getName();
        LOGGER.debug("Loading Image" + imageName);
        CloudImageDescription cid = new CloudImageDescription(imageName, properties);
        cid.setOperatingSystemType(resources.getOperatingSystemType(im_resources));
        cid.setOperatingSystemDistribution(resources.getOperatingSystemDistribution(im_resources));
        cid.setOperatingSystemVersion(resources.getOperatingSystemVersion(im_resources));
        List<String> apps = resources.getApplications(im_resources);
        if (apps != null) {
            for (String appName : apps) {
                cid.addApplication(appName);
            }
        }
        if ((p = resources.getPrice(im_resources)) != null) {
            cid.setPriceTimeUnit(p.getTimeUnit());
            cid.setPricePerUnit(p.getPricePerUnit());
        }
        cid.setCreationTime(resources.getCreationTime(im_resources));
        HashMap<String, String> sharedDisks = resources.getSharedDisks(im_resources);
        if (sharedDisks != null) {
            List<String> declaredSharedDisks = resources.getSharedDisks_names();
            for (String diskName : sharedDisks.keySet()) {
                if (declaredSharedDisks != null && declaredSharedDisks.contains(diskName)) continue;
                ErrorManager.warn("SharedDisk " + diskName + " defined in the Image " + imageName + " is not defined in the resources.xml. Skipping");
                sharedDisks.remove(diskName);
            }
        }
        cid.setSharedDisks(sharedDisks);
        String loadedAdaptor = System.getProperty("compss.comm");
        List<String> queues_project = project.getAdaptorQueues(im_project, loadedAdaptor);
        List<String> queues_resources = resources.getAdaptorQueues(im_resources, loadedAdaptor);
        for (String queue : queues_resources) {
            if (!queues_project.contains(queue)) continue;
            cid.addQueue(queue);
        }
        Object adaptorProperties_project = project.getAdaptorProperties(im_project, loadedAdaptor);
        Object adaptorProperties_resources = resources.getAdaptorProperties(im_resources, loadedAdaptor);
        MethodConfiguration config = null;
        try {
            config = (MethodConfiguration)Comm.constructConfiguration(loadedAdaptor, adaptorProperties_project, adaptorProperties_resources);
        }
        catch (ConstructConfigurationException cce) {
            ErrorManager.warn("Adaptor configuration constructor failed", cce);
            return null;
        }
        config.setHost(im_project.getName());
        config.setUser(project.getUser(im_project));
        config.setInstallDir(project.getInstallDir(im_project));
        config.setWorkingDir(project.getWorkingDir(im_project));
        config.setLimitOfTasks(project.getLimitOfTasks(im_project));
        ApplicationType app = project.getApplication(im_project);
        if (app != null) {
            config.setAppDir(app.getAppDir());
            config.setLibraryPath(app.getLibraryPath());
            config.setClasspath(app.getClasspath());
            config.setPythonpath(app.getClasspath());
        }
        List<PackageType> packages = project.getPackages(im_project);
        for (PackageType pack : packages) {
            cid.addPackage(pack.getSource(), pack.getTarget());
            SoftwareListType software = pack.getIncludedSoftware();
            if (software == null) continue;
            cid.addAllApplications(software.getApplication());
        }
        cid.setConfig(config);
        return cid;
    }

    private static CloudInstanceTypeDescription createInstance(es.bsc.compss.types.resources.jaxb.InstanceTypeType instance) {
        String type = instance.getName();
        MethodResourceDescription mrd = new MethodResourceDescription();
        List<es.bsc.compss.types.resources.jaxb.ProcessorType> processors = resources.getProcessors(instance);
        if (processors != null) {
            for (es.bsc.compss.types.resources.jaxb.ProcessorType p : processors) {
                String procName = p.getName();
                int computingUnits = resources.getProcessorComputingUnits(p);
                String architecture = resources.getProcessorArchitecture(p);
                float speed = resources.getProcessorSpeed(p);
                String procType = resources.getProcessorType(p);
                float internalMemory = resources.getProcessorMemorySize(p);
                es.bsc.compss.types.resources.jaxb.ProcessorPropertyType procProp = resources.getProcessorProperty(p);
                String propKey = procProp != null ? procProp.getKey() : "";
                String propValue = procProp != null ? procProp.getValue() : "";
                mrd.addProcessor(procName, computingUnits, architecture, speed, procType, internalMemory, propKey, propValue);
            }
        }
        mrd.setMemorySize(resources.getMemorySize(instance));
        mrd.setMemoryType(resources.getMemoryType(instance));
        mrd.setStorageSize(resources.getStorageSize(instance));
        mrd.setStorageType(resources.getStorageType(instance));
        PriceType p = resources.getPrice(instance);
        if (p != null) {
            mrd.setPriceTimeUnit(p.getTimeUnit());
            mrd.setPricePerUnit(p.getPricePerUnit());
        }
        return new CloudInstanceTypeDescription(type, mrd);
    }

    private static void loadDataNode(DataNodeType dn_project, es.bsc.compss.types.resources.jaxb.DataNodeType dn_resources) {
        String name = dn_project.getName();
        String host = resources.getHost(dn_resources);
        String path = resources.getPath(dn_resources);
        DataResourceDescription dd = new DataResourceDescription(host, path);
        dd.setStorageSize(resources.getStorageSize(dn_resources));
        dd.setStorageType(resources.getStorageType(dn_resources));
        LOGGER.warn("Cannot load DataNode " + name + ". DataNodes are not supported inside the Runtime");
    }

    static {
        LOGGER = LogManager.getLogger("es.bsc.compss.Components.ResourceManager");
    }
}

