/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor;

import es.bsc.compss.executor.types.Execution;
import es.bsc.compss.executor.utils.ExecutionPlatform;
import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.InvalidMapException;
import es.bsc.compss.util.ErrorManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ExecManager");
    private final ExecutionPlatform cpuExecutors;
    private final ExecutionPlatform ioExecutors;

    public ExecutionManager(InvocationContext context, int computingUnitsCPU, String cpuMap, int computingUnitsGPU, String gpuMap, int computingUnitsFPGA, String fpgaMap, int ioExecNum, int limitOfTasks) {
        ResourceManager rm = null;
        try {
            rm = new ResourceManager(computingUnitsCPU, cpuMap, computingUnitsGPU, gpuMap, computingUnitsFPGA, fpgaMap);
        }
        catch (InvalidMapException ime) {
            ErrorManager.fatal(ime);
        }
        this.cpuExecutors = new ExecutionPlatform("CPUThreadPool", context, computingUnitsCPU, rm);
        this.ioExecutors = new ExecutionPlatform("IOThreadPool", context, ioExecNum, rm);
    }

    public void init() throws InitializationException {
        LOGGER.info("Init Execution Manager");
        this.cpuExecutors.start();
        if (this.ioExecutors.getSize() > 0) {
            this.ioExecutors.start();
        }
    }

    public void enqueue(Execution exec) {
        if (exec.getInvocation().getMethodImplementation().isIO()) {
            if (this.ioExecutors.getSize() == 0) {
                ErrorManager.error("No available IO executors to execute: " + exec.getInvocation().getMethodImplementation().getSignature());
            } else {
                this.ioExecutors.execute(exec);
            }
        } else {
            this.cpuExecutors.execute(exec);
        }
    }

    public void stop() {
        LOGGER.info("Stopping Threads...");
        this.cpuExecutors.stop();
        if (this.ioExecutors.getSize() > 0) {
            this.ioExecutors.stop();
        }
    }

    public void increaseCapabilities(int cpuCount, int gpuCount, int fpgaCount, int otherCount) {
        this.cpuExecutors.addWorkerThreads(cpuCount);
    }

    public void reduceCapabilities(int cpuCount, int gpuCount, int fpgaCount, int otherCount) {
        this.cpuExecutors.removeWorkerThreads(cpuCount);
    }

    public void cancelJob(int jobId) {
        this.cpuExecutors.cancelJob(jobId);
    }
}

