/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.executor.external.commands.ExecuteTaskExternalCommand;
import es.bsc.compss.executor.external.piped.commands.ExecuteTaskPipeCommand;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.invokers.util.StdIOStream;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.PythonMPIImplementation;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class PythonMPIInvoker
extends ExternalInvoker {
    private final String mpiRunner;
    private final String declaringclass;
    private final String alternativeMethod;

    public PythonMPIInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        PythonMPIImplementation pythonmpiImpl = null;
        try {
            pythonmpiImpl = (PythonMPIImplementation)this.invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)this.invocation.getMethodImplementation().getMethodType()), e);
        }
        this.mpiRunner = pythonmpiImpl.getMpiRunner();
        this.declaringclass = pythonmpiImpl.getDeclaringClass();
        this.alternativeMethod = pythonmpiImpl.getAlternativeMethodName();
    }

    @Override
    protected ExecuteTaskExternalCommand getTaskExecutionCommand(InvocationContext context, Invocation invocation, String sandBox, InvocationResources assignedResources) {
        ExecuteTaskPipeCommand taskExecution = new ExecuteTaskPipeCommand(invocation.getJobId());
        return taskExecution;
    }

    @Override
    protected void invokeMethod() throws JobExecutionException {
        Object retObj;
        try {
            retObj = this.runPythonMPIInvocation();
        }
        catch (InvokeExecutionException e1) {
            throw new JobExecutionException(e1);
        }
        try {
            BinaryRunner.closeStreams(this.invocation.getParams(), this.pythonInterpreter);
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException(se);
        }
        if (this.invocation.isDebugEnabled()) {
            LOGGER.debug("Exit value of MPI executor of job " + this.invocation.getJobId() + " of task " + this.invocation.getTaskId() + ": " + retObj.toString());
        }
        if (retObj.toString().compareTo("0") != 0) {
            throw new JobExecutionException("Received non-zero exit value: " + retObj.toString() + " for job " + this.invocation.getJobId() + " of task " + this.invocation.getTaskId());
        }
    }

    private Object runPythonMPIInvocation() throws InvokeExecutionException {
        String numProcs;
        String taskCMD = this.command.getAsString();
        int numBasePythonMpiArgs = 8;
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, this.pythonInterpreter);
        String[] cmd = new String[8 + binaryParams.size()];
        cmd[0] = this.mpiRunner;
        cmd[1] = "-n";
        String hostfile = PythonMPIInvoker.writeHostfile(this.taskSandboxWorkingDir, this.workers);
        cmd[2] = numProcs = String.valueOf(this.numWorkers * this.computingUnits);
        cmd[3] = "-hostfile";
        cmd[4] = hostfile;
        cmd[5] = ((PythonParams)this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON)).getPythonInterpreter();
        String installDir = this.context.getInstallDir();
        String pycompssRelativePath = File.separator + "Bindings" + File.separator + "python";
        String pythonVersion = ((PythonParams)this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON)).getPythonVersion();
        String pyCOMPSsHome = installDir + pycompssRelativePath + File.separator + pythonVersion;
        cmd[6] = pyCOMPSsHome + File.separator + "pycompss" + File.separator + "worker" + File.separator + "external" + File.separator + "mpi_executor.py";
        cmd[7] = taskCMD;
        String pythonPath = System.getenv("PYTHONPATH");
        pythonPath = pyCOMPSsHome + ":" + pythonPath;
        for (int i = 0; i < binaryParams.size(); ++i) {
            cmd[8 + i] = binaryParams.get(i);
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[Python MPI INVOKER] Begin MPI call to " + this.declaringclass + "." + this.alternativeMethod);
            outLog.println("[Python MPI INVOKER] On WorkingDir : " + this.taskSandboxWorkingDir.getAbsolutePath());
            outLog.print("[Python MPI INVOKER] MPI CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
        }
        return BinaryRunner.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream(), pythonPath);
    }

    @Override
    public void cancelMethod() {
    }
}

