/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class COMPSsImplementation
extends AbstractMethodImplementation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 5;
    private static final String DEFAULT_RUNCOMPSS = "runcompss";
    private static final String DEFAULT_FLAGS = "";
    private String runcompss;
    private String flags;
    private String appName;
    private String workerInMaster;
    private String workingDir;

    public COMPSsImplementation() {
    }

    public COMPSsImplementation(String runcompss, String flags, String appName, String workerInMaster, String workingDir, Integer coreId, Integer implementationId, String signature, MethodResourceDescription annot) {
        super(coreId, implementationId, signature, annot);
        this.runcompss = runcompss != null && !runcompss.isEmpty() && !runcompss.equals("[unassigned]") ? runcompss : DEFAULT_RUNCOMPSS;
        this.flags = flags != null && !flags.isEmpty() && !flags.equals("[unassigned]") ? flags : DEFAULT_FLAGS;
        this.appName = appName;
        this.workerInMaster = workerInMaster;
        this.workingDir = workingDir;
    }

    public String getRuncompss() {
        return this.runcompss;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getWorkerInMaster() {
        return this.workerInMaster;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.COMPSs;
    }

    @Override
    public String getMethodDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("[RUNCOMPSS=").append(this.runcompss);
        sb.append(", FLAGS=").append(this.flags);
        sb.append(", APP_NAME=").append(this.appName);
        sb.append(", WORKER_IN_MASTER=").append(this.workerInMaster);
        sb.append(", WORKING_DIR=").append(this.workingDir);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + " COMPSs Method with appName " + this.appName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.runcompss = (String)in.readObject();
        this.flags = (String)in.readObject();
        this.appName = (String)in.readObject();
        this.workerInMaster = (String)in.readObject();
        this.workingDir = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.runcompss);
        out.writeObject(this.flags);
        out.writeObject(this.appName);
        out.writeObject(this.workerInMaster);
        out.writeObject(this.workingDir);
    }
}

