/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.invokers.util.StdIOStream;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.DecafImplementation;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class DecafInvoker
extends Invoker {
    private static final int NUM_BASE_DECAF_ARGS = 11;
    private static final String ERROR_DECAF_RUNNER = "ERROR: Invalid mpiRunner";
    private static final String ERROR_DECAF_BINARY = "ERROR: Invalid wfScript";
    private static final String ERROR_TARGET_PARAM = "ERROR: MPI Execution doesn't support target parameters";
    private final String mpiRunner;
    private String dfScript;
    private String dfExecutor;
    private String dfLib;
    private final boolean failByEV;
    private BinaryRunner br;

    public DecafInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        DecafImplementation decafImpl = null;
        try {
            decafImpl = (DecafImplementation)invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)invocation.getMethodImplementation().getMethodType()), e);
        }
        this.mpiRunner = decafImpl.getMpiRunner();
        this.dfScript = decafImpl.getDfScript();
        this.dfExecutor = decafImpl.getDfExecutor();
        this.dfLib = decafImpl.getDfLib();
        this.failByEV = decafImpl.isFailByEV();
        this.br = null;
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        this.checkArguments();
        LOGGER.info("Invoked " + this.dfScript + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException(iee);
        }
        try {
            if (this.br != null) {
                this.br.closeStreams(this.invocation.getParams(), this.pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException(se);
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            if (invocationParam.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(invocationParam, retValue);
                continue;
            }
            invocationParam.setValue(retValue);
            invocationParam.setValueClass(retValue.getClass());
        }
    }

    private void checkArguments() throws JobExecutionException {
        if (this.mpiRunner == null || this.mpiRunner.isEmpty()) {
            throw new JobExecutionException(ERROR_DECAF_RUNNER);
        }
        if (this.dfScript == null || this.dfScript.isEmpty()) {
            throw new JobExecutionException(ERROR_DECAF_BINARY);
        }
        if (!this.dfScript.startsWith(File.separator)) {
            this.dfScript = this.context.getAppDir() + File.separator + this.dfScript;
        }
        if (this.dfExecutor == null || this.dfExecutor.isEmpty() || this.dfExecutor.equals("[unassigned]")) {
            this.dfExecutor = "executor.sh";
        }
        if (!this.dfExecutor.startsWith(File.separator) && !this.dfExecutor.startsWith("./")) {
            this.dfExecutor = "./" + this.dfExecutor;
        }
        if (this.dfLib == null || this.dfLib.isEmpty()) {
            this.dfLib = "null";
        }
        if (this.invocation.getTarget() != null && this.invocation.getTarget().getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String dfRunner;
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, this.pythonInterpreter);
        String args = new String();
        for (int i = 0; i < binaryParams.size(); ++i) {
            args = i == 0 ? args.concat(binaryParams.get(i)) : args.concat(" " + binaryParams.get(i));
        }
        String[] cmd = args.isEmpty() ? new String[9] : new String[11];
        cmd[0] = dfRunner = this.context.getInstallDir() + DecafImplementation.SCRIPT_PATH;
        cmd[1] = this.dfScript;
        cmd[2] = this.dfExecutor;
        cmd[3] = this.dfLib;
        cmd[4] = this.mpiRunner;
        String numProcs = String.valueOf(this.numWorkers * this.computingUnits);
        cmd[5] = "-n";
        cmd[6] = numProcs;
        String hostfile = DecafInvoker.writeHostfile(this.taskSandboxWorkingDir, this.workers);
        cmd[7] = "--hostfile";
        cmd[8] = hostfile;
        if (!args.isEmpty()) {
            cmd[9] = "--args=\"";
            cmd[10] = args;
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[DECAF INVOKER] Begin DECAF call to " + this.dfScript);
            outLog.println("[DECAF INVOKER] On WorkingDir : " + this.taskSandboxWorkingDir.getAbsolutePath());
            outLog.print("[DECAF INVOKER] Decaf CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
            outLog.println("[DECAF INVOKER] Decaf STDIN: " + streamValues.getStdIn());
            outLog.println("[DECAF INVOKER] Decaf STDOUT: " + streamValues.getStdOut());
            outLog.println("[DECAF INVOKER] Decaf STDERR: " + streamValues.getStdErr());
        }
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream(), null, this.failByEV);
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling Decaf process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }
}

