/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.util.ErrorManager;
import java.util.List;

public class TaskDescription {
    private final TaskType type;
    private final COMPSsConstants.Lang lang;
    private final String signature;
    private final CoreElement coreElement;
    private final boolean priority;
    private final int numNodes;
    private final boolean mustReplicate;
    private final boolean mustDistribute;
    private final List<Parameter> parameters;
    private final boolean hasTarget;
    private final int numReturns;
    private final OnFailure onFailure;
    private final long timeOut;

    public TaskDescription(TaskType type, COMPSsConstants.Lang lang, String signature, CoreElement coreElement, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int numReturns, OnFailure onFailure, long timeOut, List<Parameter> parameters) {
        this.type = type;
        this.lang = lang;
        this.signature = signature;
        this.coreElement = coreElement;
        this.priority = isPrioritary;
        this.numNodes = numNodes;
        this.mustReplicate = isReplicated;
        this.mustDistribute = isDistributed;
        this.hasTarget = hasTarget;
        this.parameters = parameters;
        this.numReturns = numReturns;
        this.onFailure = onFailure;
        this.timeOut = timeOut;
        if (this.numNodes < 1) {
            ErrorManager.error("Invalid number of nodes " + this.numNodes + " on executeTask " + this.signature);
        }
    }

    public CoreElement getCoreElement() {
        return this.coreElement;
    }

    public COMPSsConstants.Lang getLang() {
        return this.lang;
    }

    public String getName() {
        String methodName = this.signature;
        int endIndex = methodName.indexOf(40);
        if (endIndex >= 0) {
            methodName = methodName.substring(0, endIndex);
        }
        return methodName;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public boolean isSingleNode() {
        return this.numNodes == 1;
    }

    public boolean isReplicated() {
        return this.mustReplicate;
    }

    public boolean isDistributed() {
        return this.mustDistribute;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean hasTargetObject() {
        return this.hasTarget;
    }

    public int getNumReturns() {
        return this.numReturns;
    }

    public TaskType getType() {
        return this.type;
    }

    public OnFailure getOnFailure() {
        return this.onFailure;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[Core id: ").append(this.coreElement.getCoreId()).append("]");
        buffer.append(", [Priority: ").append(this.priority).append("]");
        buffer.append(", [NumNodes: ").append(this.numNodes).append("]");
        buffer.append(", [MustReplicate: ").append(this.mustReplicate).append("]");
        buffer.append(", [MustDistribute: ").append(this.mustDistribute).append("]");
        buffer.append(", [").append(this.getName()).append("(");
        int numParams = this.parameters.size();
        if (this.hasTarget) {
            --numParams;
        }
        if ((numParams -= this.numReturns) > 0) {
            buffer.append((Object)this.parameters.get(0).getType());
            for (int i = 1; i < numParams; ++i) {
                buffer.append(", ").append((Object)this.parameters.get(i).getType());
            }
        }
        buffer.append(")]");
        return buffer.toString();
    }
}

