/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.types.data.DataInstanceId;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;

public class DataVersion {
    private final DataInstanceId dataInstanceId;
    private int readers = 0;
    private int writers;
    private boolean toDelete;
    private boolean used;
    private boolean semUsed;
    private List<Semaphore> semReaders;

    public DataVersion(int dataId, int versionId) {
        this.dataInstanceId = new DataInstanceId(dataId, versionId);
        this.writers = 0;
        this.toDelete = false;
        this.used = false;
        this.semReaders = new LinkedList<Semaphore>();
        this.semUsed = false;
    }

    public DataInstanceId getDataInstanceId() {
        return this.dataInstanceId;
    }

    public void willBeRead() {
        ++this.readers;
    }

    public void willBeWritten() {
        ++this.writers;
    }

    public boolean hasPendingLectures() {
        return this.readers > 0;
    }

    public boolean hasMoreReaders() {
        return this.readers > 1;
    }

    public boolean hasBeenRead() {
        --this.readers;
        if (this.readers == 0 && this.semUsed) {
            for (Semaphore s : this.semReaders) {
                s.release();
            }
        }
        return this.checkDeletion();
    }

    public boolean hasBeenWritten() {
        --this.writers;
        return this.checkDeletion();
    }

    public Integer getNumberOfReaders() {
        return this.readers;
    }

    public Integer getNumberOfWriters() {
        return this.writers;
    }

    public boolean markToDelete() {
        this.toDelete = true;
        return this.readers == 0 && this.writers == 0;
    }

    public void unmarkToDelete() {
        this.toDelete = false;
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    private boolean checkDeletion() {
        return this.toDelete && this.writers == 0 && this.readers == 0;
    }

    public void versionUsed() {
        this.used = true;
    }

    public boolean hasBeenUsed() {
        return this.used;
    }

    public boolean addSemaphore(Semaphore semWait) {
        if (this.readers != 0) {
            this.semUsed = true;
            this.semReaders.add(semWait);
            return true;
        }
        return false;
    }
}

